/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.economic.pt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import pt.ist.standards.economic.pt.EconomicActivityClassification;
import pt.ist.standards.economic.pt.EconomicActivityClassificationLeaf;
import pt.ist.standards.util.ResourceReader;

public class EconomicActivityClassificationGroup
extends EconomicActivityClassification {
    private static final String RESOURCE_PATH = "/economic/pt/EconomicActivityClassifications.csv";
    static SortedSet<EconomicActivityClassificationGroup> classificationGroups = new TreeSet<EconomicActivityClassificationGroup>();
    final SortedSet<EconomicActivityClassification> classifications = new TreeSet<EconomicActivityClassification>();

    public EconomicActivityClassificationGroup(String code, String description) {
        super(code, description);
    }

    private static Collection<EconomicActivityClassification> constructClassifications(String[] content, int i, EconomicActivityClassificationGroup group) {
        ArrayList<EconomicActivityClassification> set = new ArrayList<EconomicActivityClassification>();
        for (int j = i + 1; j < content.length; ++j) {
            String line = content[j];
            String[] parts = line.split("\t");
            String groupCode = parts[0].trim();
            if (!groupCode.isEmpty()) {
                return set;
            }
            String code = parts[1];
            String description = parts[2];
            set.add(new EconomicActivityClassificationLeaf(code, description, group));
        }
        return set;
    }

    public static SortedSet<EconomicActivityClassificationGroup> getCassificationGroups() {
        return Collections.unmodifiableSortedSet(classificationGroups);
    }

    public SortedSet<EconomicActivityClassification> getClassifications() {
        return Collections.unmodifiableSortedSet(this.classifications);
    }

    public static EconomicActivityClassificationLeaf importFromString(String string) {
        if (string != null && !string.isEmpty()) {
            String[] parts = string.split(":");
            for (EconomicActivityClassificationGroup group : classificationGroups) {
                if (!group.code.equals(parts[0])) continue;
                for (EconomicActivityClassification classification : group.classifications) {
                    if (!classification.code.equals(parts[1])) continue;
                    return (EconomicActivityClassificationLeaf)classification;
                }
            }
        }
        return null;
    }

    static {
        try {
            String[] content = ResourceReader.readLines(RESOURCE_PATH);
            for (int i = 0; i < content.length; ++i) {
                String line = content[i];
                String[] parts = line.split("\t");
                String groupCode = parts[0].trim();
                String description = parts[1].trim();
                EconomicActivityClassificationGroup group = new EconomicActivityClassificationGroup(groupCode, description);
                Collection<EconomicActivityClassification> EconomicActivityClassifications = EconomicActivityClassificationGroup.constructClassifications(content, i, group);
                i += EconomicActivityClassifications.size();
                classificationGroups.add(group);
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

