/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.standards.geographic;

import java.io.Serializable;
import java.util.Arrays;
import pt.ist.standards.geographic.Place;

public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Place<?, ?> place;
    private final String[] lines;
    private static final char LINE_SEPERATOR = '_';
    private static final char LINE_SIZE_SEPERATOR = '_';

    public Address(Place<?, ?> place, String[] lines) {
        this.place = place;
        this.lines = Arrays.copyOf(lines, lines.length);
    }

    public String[] lines() {
        return Arrays.copyOf(this.lines, this.lines.length);
    }

    public String exportAsString() {
        StringBuilder result = new StringBuilder();
        if (this.place != null) {
            this.place.exportAsString(result);
        }
        result.append('_');
        for (String line : this.lines) {
            int length = line.length();
            result.append(length);
            result.append('_');
            result.append(line);
        }
        return result.toString();
    }
}

