/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsEnvironmentMode;

public class SIBSInitializeServiceBean {
    private String entityId;
    private String bearerToken;
    private String endpointUrl;
    private String paymentEntity;
    private String paymentCurrency;
    private String aesKey;
    private SibsEnvironmentMode environmentMode;

    public SIBSInitializeServiceBean(String entityId, String bearerToken, String endpointUrl, String paymentEntity, String paymentCurrency, SibsEnvironmentMode environmentMode) {
        this.entityId = entityId;
        this.bearerToken = bearerToken;
        this.endpointUrl = endpointUrl;
        this.paymentEntity = paymentEntity;
        this.paymentCurrency = paymentCurrency;
        this.environmentMode = environmentMode;
    }

    public SIBSInitializeServiceBean(String entityId, String aesKey, SibsEnvironmentMode environmentMode) {
        this.entityId = entityId;
        this.aesKey = aesKey;
        this.environmentMode = environmentMode;
    }

    public SIBSInitializeServiceBean() {
    }

    public boolean isAuthPropertiesValid() {
        boolean returnValue = true;
        returnValue &= this.entityId != null && !this.entityId.isEmpty();
        returnValue &= this.bearerToken != null && !this.bearerToken.isEmpty();
        return returnValue &= this.environmentMode != null;
    }

    public boolean isPaymentPropertiesValid() {
        boolean returnValue = true;
        returnValue &= this.paymentEntity != null && !this.paymentEntity.isEmpty();
        return returnValue &= this.paymentCurrency != null && !this.paymentCurrency.isEmpty();
    }

    public boolean isNotificationPropertiesValid() {
        boolean returnValue = true;
        return returnValue &= this.aesKey != null && !this.aesKey.isEmpty();
    }

    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public String getBearerToken() {
        return this.bearerToken;
    }

    public void setBearerToken(String bearerToken) {
        this.bearerToken = "Bearer " + bearerToken;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public void setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    public String getPaymentEntity() {
        return this.paymentEntity;
    }

    public void setPaymentEntity(String paymentEntity) {
        this.paymentEntity = paymentEntity;
    }

    public String getPaymentCurrency() {
        return this.paymentCurrency;
    }

    public void setPaymentCurrency(String paymentCurrency) {
        this.paymentCurrency = paymentCurrency;
    }

    public String getAesKey() {
        return this.aesKey;
    }

    public void setAesKey(String aesKey) {
        this.aesKey = aesKey;
    }

    public SibsEnvironmentMode getEnvironmentMode() {
        return this.environmentMode;
    }

    public void setEnvironmentMode(SibsEnvironmentMode environmentMode) {
        this.environmentMode = environmentMode;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

