/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.Form;
import org.fenixedu.onlinepaymentsgateway.api.CheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.CustomerDataInputBean;
import org.fenixedu.onlinepaymentsgateway.api.HandleRequestBean;
import org.fenixedu.onlinepaymentsgateway.api.MbCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayCheckoutResultBean;
import org.fenixedu.onlinepaymentsgateway.api.MbWayPrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.PaymentFormBean;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.api.PrepareCheckoutInputBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSInitializeServiceBean;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.MerchantIdReportBean;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.NotificationBean;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentBrand;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentType;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareCheckout;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareCheckoutResult;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareHandle;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareMBCheckout;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareMBCheckoutResult;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareMBWayCheckout;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PrepareMBWayCheckoutResult;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.SibsResultCodeType;
import org.fenixedu.onlinepaymentsgateway.util.Decryption;
import org.glassfish.jersey.logging.LoggingFeature;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SIBSOnlinePaymentsGatewayService {
    private static Logger logger = LoggerFactory.getLogger(SIBSOnlinePaymentsGatewayService.class);
    private Feature feature = new LoggingFeature(java.util.logging.Logger.getLogger(SIBSOnlinePaymentsGatewayService.class.getName()), Level.FINEST, null, null);
    private Client client = ((ClientBuilder)ClientBuilder.newBuilder().register((Object)this.feature)).build();
    private WebTarget webTargetBase;
    private SIBSInitializeServiceBean initializeServiceBean;
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ssZ");

    public SIBSOnlinePaymentsGatewayService(SIBSInitializeServiceBean initializeServiceBean) {
        this.initializeServiceBean = initializeServiceBean;
        if (initializeServiceBean.getEndpointUrl() != null) {
            this.webTargetBase = this.client.target(initializeServiceBean.getEndpointUrl());
        }
    }

    public MbCheckoutResultBean generateMBPaymentReference(MbPrepareCheckoutInputBean mbPrepareCheckoutInputBean, CustomerDataInputBean customerInputBean) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (!this.initializeServiceBean.isPaymentPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service payment settings");
        }
        if (mbPrepareCheckoutInputBean == null || !mbPrepareCheckoutInputBean.isPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Amount or Dates");
        }
        if (mbPrepareCheckoutInputBean.getAmount().scale() > 2) {
            throw new IllegalArgumentException("Invalid Amount, Amount.scale() <= 2");
        }
        WebTarget target = this.webTargetBase.path("payments");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String paymentCurrency = this.initializeServiceBean.getPaymentCurrency();
        String paymentEntity = this.initializeServiceBean.getPaymentEntity();
        String paymentType = PaymentType.PA.name();
        String paymentBrand = "SIBS_MULTIBANCO";
        String billingCountry = "PT";
        String paymentAmount = mbPrepareCheckoutInputBean.getAmount().setScale(2, RoundingMode.HALF_EVEN).toString();
        String sibsRefIntDate = mbPrepareCheckoutInputBean.getSibsRefIntDate().toString(ISODateTimeFormat.dateTime());
        String sibsRefLmtDate = mbPrepareCheckoutInputBean.getSibsRefLmtDate().toString(ISODateTimeFormat.dateTime());
        PrepareMBCheckout mbPrepCheckout = new PrepareMBCheckout(entityId, paymentAmount, paymentCurrency, paymentType, "SIBS_MULTIBANCO", paymentEntity, sibsRefIntDate, sibsRefLmtDate, "PT", customerInputBean, this.initializeServiceBean.getEnvironmentMode());
        if (mbPrepareCheckoutInputBean.getMerchantTransactionId() != null) {
            String merchantTransactionId = mbPrepareCheckoutInputBean.getMerchantTransactionId();
            mbPrepCheckout.setMerchantTransactionId(merchantTransactionId);
        }
        String requestLog = mbPrepCheckout.toString();
        Form form = new Form(mbPrepCheckout.asMap());
        String responseLog = null;
        Invocation.Builder builder = target.request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).post(Entity.form((Form)form), String.class);
            PrepareMBCheckoutResult result = this.customMapper(responseLog, PrepareMBCheckoutResult.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(result.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(result.getResult().getDescription(), operationResultType);
            MbCheckoutResultBean mbCheckoutResult = new MbCheckoutResultBean(result.getId(), result.getMerchantTransactionId(), DateTime.parse((String)result.getTimestamp(), (DateTimeFormatter)formatter), result.getAmount(), result.getCurrency(), result.getPaymentBrand(), result.getPaymentType(), result.getCustomParameters().getSibsPaymentEntity(), result.getResultDetails().getPmtRef(), result.getCustomParameters().getSibsRefIntDate(), result.getCustomParameters().getSibsRefLmtDate(), operationResultType, operationResultDescription, result.getResult().getCode(), result.getResult().getDescription());
            if (result.getMerchantTransactionId() != null) {
                mbCheckoutResult.setMerchantTransactionId(result.getMerchantTransactionId());
            }
            mbCheckoutResult.setRequestLog(requestLog);
            mbCheckoutResult.setResponseLog(responseLog);
            boolean validAnswer = true;
            validAnswer &= mbPrepCheckout.getAmount() != null && mbCheckoutResult.getAmount() != null && mbPrepCheckout.getAmount().equals(mbCheckoutResult.getAmount().toString());
            validAnswer &= mbPrepCheckout.getCurrency() != null && mbCheckoutResult.getCurrency() != null && mbPrepCheckout.getCurrency().equals(mbCheckoutResult.getCurrency());
            validAnswer &= mbPrepCheckout.getPaymentBrand() != null && mbCheckoutResult.getPaymentBrand() != null && mbPrepCheckout.getPaymentBrand().equals((Object)mbCheckoutResult.getPaymentBrand());
            validAnswer &= mbPrepCheckout.getPaymentType() != null && mbCheckoutResult.getPaymentType() != null && mbPrepCheckout.getPaymentType().equals((Object)mbCheckoutResult.getPaymentType());
            if (mbPrepCheckout.getMerchantTransactionId() != null) {
                validAnswer &= mbCheckoutResult.getMerchantTransactionId() != null && mbPrepCheckout.getMerchantTransactionId().equals(mbCheckoutResult.getMerchantTransactionId());
            }
            if (!validAnswer) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, "Request and Response details do not match.");
            }
            logger.debug(mbCheckoutResult.toString());
            return mbCheckoutResult;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public MbWayCheckoutResultBean generateMbWayPayment(MbWayPrepareCheckoutInputBean mbwayPrepareCheckoutInputBean, CustomerDataInputBean customerInputBean) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (!this.initializeServiceBean.isPaymentPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service payment settings");
        }
        if (mbwayPrepareCheckoutInputBean == null || !mbwayPrepareCheckoutInputBean.isAmountValid()) {
            throw new IllegalArgumentException("Invalid Payment input");
        }
        if (mbwayPrepareCheckoutInputBean.getAmount().scale() > 2) {
            throw new IllegalArgumentException("Invalid Amount, Amount.scale() <= 2");
        }
        if (mbwayPrepareCheckoutInputBean == null || !mbwayPrepareCheckoutInputBean.isNumberValid()) {
            throw new IllegalArgumentException("Invalid Phone Number input");
        }
        WebTarget target = this.webTargetBase.path("payments");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String paymentCurrency = this.initializeServiceBean.getPaymentCurrency();
        String paymentType = PaymentType.DB.name();
        String paymentBrand = "MBWAY";
        String paymentAmount = mbwayPrepareCheckoutInputBean.getAmount().setScale(2, RoundingMode.HALF_EVEN).toString();
        String phoneNumber = mbwayPrepareCheckoutInputBean.getPhoneNumber();
        PrepareMBWayCheckout mbwayPrepCheckout = new PrepareMBWayCheckout(entityId, paymentAmount, paymentCurrency, paymentType, "MBWAY", phoneNumber, customerInputBean, this.initializeServiceBean.getEnvironmentMode());
        if (mbwayPrepareCheckoutInputBean.getMerchantTransactionId() != null) {
            String merchantTransactionId = mbwayPrepareCheckoutInputBean.getMerchantTransactionId();
            mbwayPrepCheckout.setMerchantTransactionId(merchantTransactionId);
        }
        String requestLog = mbwayPrepCheckout.toString();
        Form form = new Form(mbwayPrepCheckout.asMap());
        String responseLog = null;
        Invocation.Builder builder = target.request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).post(Entity.form((Form)form), String.class);
            PrepareMBWayCheckoutResult result = this.customMapper(responseLog, PrepareMBWayCheckoutResult.class);
            String answerContainingPhoneNumber = result.getResultDetails().getConnectorTxID3();
            String phoneNumberResult = answerContainingPhoneNumber.substring(answerContainingPhoneNumber.lastIndexOf("||") + 2, answerContainingPhoneNumber.lastIndexOf("||") + 15);
            SibsResultCodeType operationResultType = this.validateSibsResult(result.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(result.getResult().getDescription(), operationResultType);
            MbWayCheckoutResultBean mbwayCheckoutResult = new MbWayCheckoutResultBean(result.getId(), DateTime.parse((String)result.getTimestamp(), (DateTimeFormatter)formatter), new BigDecimal(result.getAmount()), result.getCurrency(), result.getPaymentBrand(), result.getPaymentType(), phoneNumberResult, result.getResultDetails().getAcquirerResponse(), operationResultType, operationResultDescription, result.getResult().getCode(), result.getResult().getDescription());
            if (result.getMerchantTransactionId() != null) {
                mbwayCheckoutResult.setMerchantTransactionId(result.getMerchantTransactionId());
            }
            mbwayCheckoutResult.setRequestLog(requestLog);
            mbwayCheckoutResult.setResponseLog(responseLog);
            boolean validAnswer = true;
            validAnswer &= mbwayPrepCheckout.getAmount() != null && mbwayCheckoutResult.getAmount() != null && mbwayPrepCheckout.getAmount().equals(mbwayCheckoutResult.getAmount().toString());
            validAnswer &= mbwayPrepCheckout.getCurrency() != null && mbwayCheckoutResult.getCurrency() != null && mbwayPrepCheckout.getCurrency().equals(mbwayCheckoutResult.getCurrency());
            validAnswer &= mbwayPrepCheckout.getPaymentBrand() != null && mbwayCheckoutResult.getPaymentBrand() != null && mbwayPrepCheckout.getPaymentBrand().equals((Object)mbwayCheckoutResult.getPaymentBrand());
            validAnswer &= mbwayPrepCheckout.getPaymentType() != null && mbwayCheckoutResult.getPaymentType() != null && mbwayPrepCheckout.getPaymentType().equals((Object)mbwayCheckoutResult.getPaymentType());
            if (mbwayPrepCheckout.getMerchantTransactionId() != null) {
                validAnswer &= mbwayCheckoutResult.getMerchantTransactionId() != null && mbwayPrepCheckout.getMerchantTransactionId().equals(mbwayCheckoutResult.getMerchantTransactionId());
            }
            if (!validAnswer) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, "Request and Response details do not match.");
            }
            return mbwayCheckoutResult;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public CheckoutResultBean prepareOnlinePaymentCheckout(PrepareCheckoutInputBean prepareCheckoutInputBean) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (!this.initializeServiceBean.isPaymentPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service payment settings");
        }
        if (prepareCheckoutInputBean == null || !(prepareCheckoutInputBean.getUseMB() == false ? prepareCheckoutInputBean.isPropertiesValid() : prepareCheckoutInputBean.isMBPropertiesValid())) {
            throw new IllegalArgumentException("Invalid Payment input");
        }
        if (prepareCheckoutInputBean.getAmount().scale() > 2) {
            throw new IllegalArgumentException("Amount.scale() <= 2");
        }
        WebTarget target = this.webTargetBase.path("checkouts");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String paymentCurrency = this.initializeServiceBean.getPaymentCurrency();
        String paymentEntity = this.initializeServiceBean.getPaymentEntity();
        Boolean useCreditCard = prepareCheckoutInputBean.getUseCreditCard();
        Boolean useMBway = prepareCheckoutInputBean.getUseMBway();
        Boolean useMB = prepareCheckoutInputBean.getUseMB();
        String paymentType = useMB != false ? PaymentType.PA.name() : PaymentType.DB.name();
        BigDecimal paymentAmount = prepareCheckoutInputBean.getAmount().setScale(2, RoundingMode.HALF_EVEN);
        String shopperResultUrl = prepareCheckoutInputBean.getShopperResultUrl();
        PrepareCheckout prepCheckout = new PrepareCheckout(entityId, paymentAmount.toString(), paymentCurrency, paymentType, this.initializeServiceBean.getEnvironmentMode());
        prepCheckout.fillBillingData(prepareCheckoutInputBean.getCardHolder(), prepareCheckoutInputBean.getBillingCountry(), prepareCheckoutInputBean.getBillingCity(), prepareCheckoutInputBean.getBillingStreet1(), prepareCheckoutInputBean.getBillingPostcode(), prepareCheckoutInputBean.getCustomerEmail());
        if (useMB.booleanValue()) {
            String sibsRefIntDate = prepareCheckoutInputBean.getSibsRefIntDate().toString();
            String sibsRefLmtDate = prepareCheckoutInputBean.getSibsRefLmtDate().toString();
            prepCheckout.setSIBSMULTIBANCO_PtmntEntty(paymentEntity);
            prepCheckout.setSIBSMULTIBANCO_RefIntlDtTm(sibsRefIntDate);
            prepCheckout.setSIBSMULTIBANCO_RefLmtDtTm(sibsRefLmtDate);
        }
        if (prepareCheckoutInputBean.getMerchantTransactionId() != null) {
            String merchantTransactionId = prepareCheckoutInputBean.getMerchantTransactionId();
            prepCheckout.setMerchantTransactionId(merchantTransactionId);
        }
        String requestLog = prepCheckout.toString();
        Form form = new Form(prepCheckout.asMap());
        String responseLog = null;
        Invocation.Builder builder = target.request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).post(Entity.form((Form)form), String.class);
            PrepareCheckoutResult result = this.customMapper(responseLog, PrepareCheckoutResult.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(result.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(result.getResult().getDescription(), operationResultType);
            CheckoutResultBean checkoutResult = new CheckoutResultBean(result.getId(), DateTime.parse((String)result.getTimestamp(), (DateTimeFormatter)formatter), shopperResultUrl, paymentAmount, paymentCurrency, operationResultType, operationResultDescription, result.getResult().getCode(), result.getResult().getDescription());
            checkoutResult.setRequestLog(requestLog);
            checkoutResult.setResponseLog(responseLog);
            Object paymentBrands = "";
            if (useCreditCard.booleanValue()) {
                paymentBrands = (String)paymentBrands + " " + PaymentBrand.VISA.name() + " " + PaymentBrand.MASTER.name() + " " + PaymentBrand.AMEX.name();
            }
            if (useMBway.booleanValue()) {
                paymentBrands = (String)paymentBrands + " " + PaymentBrand.MBWAY.name();
            }
            if (useMB.booleanValue()) {
                paymentBrands = PaymentBrand.SIBS_MULTIBANCO.name();
            }
            paymentBrands = ((String)paymentBrands).trim();
            checkoutResult.setPaymentBrands((String)paymentBrands);
            return checkoutResult;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public PaymentFormBean createOnlinePaymentForm(CheckoutResultBean checkoutResultBean) throws Exception {
        String endpointUrl = this.initializeServiceBean.getEndpointUrl();
        String checkoutId = checkoutResultBean.getCheckoutId();
        String shopperResultUrl = checkoutResultBean.getShopperResultUrl();
        String paymentBrands = checkoutResultBean.getPaymentBrands();
        String htmlScript = "<script src='" + endpointUrl + "/paymentWidgets.js?checkoutId=" + checkoutId + "'></script>";
        String htmlForm = "<form action='" + shopperResultUrl + "' class='paymentWidgets' data-brands='" + paymentBrands + "'></form>";
        PaymentFormBean paymentForm = new PaymentFormBean(htmlScript, htmlForm);
        return paymentForm;
    }

    public PaymentStateBean getPaymentStatusByCheckoutId(String checkoutId) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (checkoutId == null || checkoutId.isEmpty()) {
            throw new IllegalArgumentException("Invalid Checkout Id");
        }
        WebTarget target = this.webTargetBase.path("checkouts/" + checkoutId + "/payment");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        Invocation.Builder builder = target.queryParam("entityId", new Object[]{entityId}).request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        String requestLog = "Entity Id = " + entityId + ", Authorization = " + bearerToken + ", Checkout Id = " + checkoutId;
        String responseLog = null;
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).get(String.class);
            PaymentStateBean transactionStatus = this.customMapper(responseLog, PaymentStateBean.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(transactionStatus.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(transactionStatus.getResult().getDescription(), operationResultType);
            transactionStatus.setOperationResultType(operationResultType);
            transactionStatus.setOperationResultDescription(operationResultDescription);
            transactionStatus.setRequestLog(requestLog);
            transactionStatus.setResponseLog(responseLog);
            transactionStatus.setPaymentDate(DateTime.parse((String)transactionStatus.getTimestamp(), (DateTimeFormatter)formatter));
            return transactionStatus;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public PaymentStateBean getPaymentTransactionReportByTransactionId(String transactionId) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (transactionId == null || transactionId.isEmpty()) {
            throw new IllegalArgumentException("Invalid Transaction Id");
        }
        WebTarget target = this.webTargetBase.path("query/" + transactionId);
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String requestLog = "Entity Id = " + entityId + ", Authorization = " + bearerToken + ", Transaction Id = " + transactionId;
        String responseLog = null;
        Invocation.Builder builder = target.queryParam("entityId", new Object[]{entityId}).request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).get(String.class);
            PaymentStateBean transactionReport = this.customMapper(responseLog, PaymentStateBean.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(transactionReport.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(transactionReport.getResult().getDescription(), operationResultType);
            transactionReport.setOperationResultType(operationResultType);
            transactionReport.setOperationResultDescription(operationResultDescription);
            transactionReport.setRequestLog(requestLog);
            transactionReport.setResponseLog(responseLog);
            transactionReport.setPaymentDate(DateTime.parse((String)transactionReport.getTimestamp(), (DateTimeFormatter)formatter));
            boolean validAnswer = true;
            if (!(validAnswer &= transactionReport.getTransactionId() != null && transactionReport.getTransactionId().equals(transactionId))) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, "Request and Response details do not match.");
            }
            return transactionReport;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    @Deprecated
    public PaymentStateBean getPaymentTransactionReportByMerchantId(String merchantTransactionId) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (merchantTransactionId == null || merchantTransactionId.isEmpty()) {
            throw new IllegalArgumentException("Invalid Merchant Transaction Id");
        }
        WebTarget target = this.webTargetBase.path("query");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String requestLog = "Entity Id = " + entityId + ", Authorization = " + bearerToken + ", Merchant Transaction Id = " + merchantTransactionId;
        String responseLog = null;
        Invocation.Builder builder = target.queryParam("entityId", new Object[]{entityId}).queryParam("merchantTransactionId", new Object[]{merchantTransactionId}).request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).get(String.class);
            MerchantIdReportBean merchantReport = this.customMapper(responseLog, MerchantIdReportBean.class);
            String lastPayment = merchantReport.getPayments().get(merchantReport.getPayments().size() - 1).toString();
            PaymentStateBean transactionReport = this.customMapper(lastPayment, PaymentStateBean.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(transactionReport.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(transactionReport.getResult().getDescription(), operationResultType);
            transactionReport.setOperationResultType(operationResultType);
            transactionReport.setOperationResultDescription(operationResultDescription);
            transactionReport.setRequestLog(requestLog);
            transactionReport.setResponseLog(responseLog);
            transactionReport.setPaymentDate(DateTime.parse((String)transactionReport.getTimestamp(), (DateTimeFormatter)formatter));
            boolean validAnswer = true;
            if (!(validAnswer &= transactionReport.getMerchantTransactionId() != null && transactionReport.getMerchantTransactionId().equals(merchantTransactionId))) {
                throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, "Request and Response details do not match.");
            }
            return transactionReport;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public List<PaymentStateBean> getPaymentTransactionsReportListByMerchantId(String merchantTransactionId) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (merchantTransactionId == null || merchantTransactionId.isEmpty()) {
            throw new IllegalArgumentException("Invalid Merchant Transaction Id");
        }
        WebTarget target = this.webTargetBase.path("query");
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String requestLog = "Entity Id = " + entityId + ", Authorization = " + bearerToken + ", Merchant Transaction Id = " + merchantTransactionId;
        String responseLog = null;
        Invocation.Builder builder = target.queryParam("entityId", new Object[]{entityId}).queryParam("merchantTransactionId", new Object[]{merchantTransactionId}).request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).get(String.class);
            MerchantIdReportBean merchantReport = this.customMapper(responseLog, MerchantIdReportBean.class);
            ArrayList<PaymentStateBean> result = new ArrayList<PaymentStateBean>();
            for (MerchantIdReportBean.Payment payment : merchantReport.getPayments()) {
                String lastPayment = payment.toString();
                PaymentStateBean transactionReport = this.customMapper(lastPayment, PaymentStateBean.class);
                SibsResultCodeType operationResultType = this.validateSibsResult(transactionReport.getResult().getCode());
                String operationResultDescription = this.operationResultDescription(transactionReport.getResult().getDescription(), operationResultType);
                transactionReport.setOperationResultType(operationResultType);
                transactionReport.setOperationResultDescription(operationResultDescription);
                transactionReport.setRequestLog(requestLog);
                transactionReport.setResponseLog(responseLog);
                transactionReport.setPaymentDate(DateTime.parse((String)transactionReport.getTimestamp(), (DateTimeFormatter)formatter));
                boolean validAnswer = true;
                if (!(validAnswer &= transactionReport.getMerchantTransactionId() != null && transactionReport.getMerchantTransactionId().equals(merchantTransactionId))) {
                    throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, "Request and Response details do not match.");
                }
                result.add(transactionReport);
            }
            return result;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public PaymentStateBean handlePayment(String transactionId, HandleRequestBean handleRequestBean) throws OnlinePaymentsGatewayCommunicationException {
        if (!this.initializeServiceBean.isAuthPropertiesValid()) {
            throw new IllegalArgumentException("Invalid Service Authentication");
        }
        if (transactionId == null || transactionId.isEmpty()) {
            throw new IllegalArgumentException("Invalid Transaction Id");
        }
        WebTarget target = this.webTargetBase.path("payments/" + transactionId);
        String bearerToken = this.initializeServiceBean.getBearerToken();
        String entityId = this.initializeServiceBean.getEntityId();
        String paymentCurrency = this.initializeServiceBean.getPaymentCurrency();
        String paymentType = handleRequestBean.getPaymentType().name();
        String paymentAmount = handleRequestBean.getAmount().setScale(2, RoundingMode.HALF_EVEN).toString();
        PrepareHandle handlePayment = new PrepareHandle(entityId, paymentAmount, paymentCurrency, paymentType, this.initializeServiceBean.getEnvironmentMode());
        String requestLog = handlePayment.toString();
        Form form = new Form(handlePayment.asMap());
        String responseLog = null;
        Invocation.Builder builder = target.request(new String[]{"application/x-www-form-urlencoded; charset=UTF-8"}).accept(new String[]{"application/json"});
        try {
            responseLog = (String)builder.header("Authorization", (Object)bearerToken).post(Entity.form((Form)form), String.class);
            PaymentStateBean refundResult = this.customMapper(responseLog, PaymentStateBean.class);
            SibsResultCodeType operationResultType = this.validateSibsResult(refundResult.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(refundResult.getResult().getDescription(), operationResultType);
            refundResult.setOperationResultType(operationResultType);
            refundResult.setOperationResultDescription(operationResultDescription);
            refundResult.setRequestLog(requestLog);
            refundResult.setResponseLog(responseLog);
            logger.debug(refundResult.toString());
            return refundResult;
        }
        catch (WebApplicationException e) {
            responseLog = (String)e.getResponse().readEntity(String.class);
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(requestLog, responseLog, e);
        }
    }

    public PaymentStateBean handleNotificationRequest(String initializationVector, String authTag, String encryptedPayload) throws Exception {
        logger.debug("Request encrypted: " + encryptedPayload.toString());
        String decryptedPayload = null;
        try {
            Decryption notification = new Decryption(this.initializeServiceBean.getAesKey(), initializationVector, authTag, encryptedPayload);
            decryptedPayload = notification.decryptPayload();
            logger.debug("\n Request desencrypted: " + decryptedPayload);
            NotificationBean payload = this.customMapper(decryptedPayload, NotificationBean.class);
            logger.debug("\n Payload content: " + payload.toString());
            String payloadOnly = payload.getPayload().toJson();
            PaymentStateBean notificationReport = this.customMapper(payloadOnly, PaymentStateBean.class);
            notificationReport.setNotificationType(payload.getType().toString());
            SibsResultCodeType operationResultType = this.validateSibsResult(notificationReport.getResult().getCode());
            String operationResultDescription = this.operationResultDescription(notificationReport.getResult().getDescription(), operationResultType);
            notificationReport.setOperationResultType(operationResultType);
            notificationReport.setOperationResultDescription(operationResultDescription);
            notificationReport.setRequestLog(decryptedPayload);
            notificationReport.setPaymentDate(DateTime.parse((String)notificationReport.getTimestamp(), (DateTimeFormatter)formatter));
            return notificationReport;
        }
        catch (Exception e) {
            throw new OnlinePaymentsGatewayCommunicationException(decryptedPayload, null, e);
        }
    }

    public PaymentStateBean handleNotificationServletRequest(HttpServletRequest httpServletRequest) throws Exception {
        String initializationVector = SIBSOnlinePaymentsGatewayService.notificationInitializationVector(httpServletRequest);
        String authTag = SIBSOnlinePaymentsGatewayService.notificationAuthenticationTag(httpServletRequest);
        String encryptedPayload = SIBSOnlinePaymentsGatewayService.notificationEncryptedPayload(httpServletRequest);
        PaymentStateBean payload = this.handleNotificationRequest(initializationVector, authTag, encryptedPayload);
        return payload;
    }

    public static String notificationEncryptedPayload(HttpServletRequest request) throws Exception {
        return request.getReader().readLine();
    }

    public static String notificationInitializationVector(HttpServletRequest request) {
        return request.getHeader("X-Initialization-Vector");
    }

    public static String notificationAuthenticationTag(HttpServletRequest request) {
        return request.getHeader("X-Authentication-Tag");
    }

    private SibsResultCodeType validateSibsResult(String resultCode) {
        if (resultCode == null || resultCode.isEmpty()) {
            throw new NullPointerException("Problem fletching SIBS Result Code.");
        }
        for (SibsResultCodeType sibsResult : SibsResultCodeType.values()) {
            if (!Pattern.compile(sibsResult.getRegex()).matcher(resultCode).find()) continue;
            return sibsResult;
        }
        return null;
    }

    private String operationResultDescription(String resultDescription, SibsResultCodeType operationResultType) {
        if (operationResultType != null || resultDescription != null) {
            if (operationResultType != null && operationResultType.isSuccess()) {
                return "Valid Operation / " + operationResultType.name() + " / " + resultDescription;
            }
            return "Invalid Operation / " + operationResultType.name() + " / " + resultDescription;
        }
        return null;
    }

    private <T> T customMapper(String jsonPayload, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        Object result = mapper.readValue(jsonPayload, clazz);
        return (T)result;
    }

    private Logger fileLogger(String fileName) throws SecurityException, IOException {
        java.util.logging.Logger filelogger = java.util.logging.Logger.getLogger(SIBSOnlinePaymentsGatewayService.class.getName());
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy_HH:mm:ss.SSS");
        File logDir = new File("./logs/");
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        FileHandler fh = new FileHandler("logs/" + fileName + "_" + format.format(Calendar.getInstance().getTime()) + ".log");
        fh.setFormatter(new SimpleFormatter());
        filelogger.addHandler(fh);
        filelogger.setLevel(Level.FINEST);
        return logger;
    }

    public void closeClient() {
        this.client.close();
    }
}

