/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.onlinepaymentsgateway.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;

public class MbWayPrepareCheckoutInputBean {
    public BigDecimal amount;
    public String merchantTransactionId;
    public String phoneNumber;

    public MbWayPrepareCheckoutInputBean(BigDecimal amount, String merchantTransactionId, String phoneNumber) {
        this.amount = amount;
        this.merchantTransactionId = merchantTransactionId;
        this.phoneNumber = phoneNumber;
    }

    public MbWayPrepareCheckoutInputBean(BigDecimal amount, String phoneNumber) {
        this.amount = amount;
        this.phoneNumber = phoneNumber;
    }

    public MbWayPrepareCheckoutInputBean() {
    }

    public boolean isAmountValid() {
        boolean returnValue = true;
        return returnValue &= this.amount != null && this.getAmount().compareTo(BigDecimal.ZERO) > 0;
    }

    public boolean isNumberValid() {
        boolean returnValue = true;
        return returnValue &= this.phoneNumber != null && this.phoneNumber.matches("^351[#]\\d{9}$");
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public String getMerchantTransactionId() {
        return this.merchantTransactionId;
    }

    public void setMerchantTransactionId(String merchantTransactionId) {
        this.merchantTransactionId = merchantTransactionId;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }
}

