/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.scholarshiptypology;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Optional;
import java.util.TreeSet;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.GrantOwnerType;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ProfessionType;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.SchoolLevelType;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationServices;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.specifications.domain.PersonUlisboaSpecifications;
import org.fenixedu.ulisboa.specifications.domain.ProfessionTimeType;
import org.fenixedu.ulisboa.specifications.domain.SalarySpan;

public class ScholarshipTypologyReport
implements Comparable<ScholarshipTypologyReport> {
    private final ExecutionYear executionYear;
    private final Registration registration;

    public ScholarshipTypologyReport(Registration registration, ExecutionYear executionYear) {
        this.executionYear = executionYear;
        this.registration = registration;
        if (this.getStudentCurricularPlan() == null) {
            throw new ULisboaReportsDomainException("error.RegistrationHistoryReport.found.registration.without.student.curricular.plan", this.getStudent().getNumber().toString(), this.getDegree().getCode(), executionYear.getQualifiedName());
        }
    }

    @Override
    public int compareTo(ScholarshipTypologyReport o) {
        Comparator byYear = (x, y) -> ExecutionYear.COMPARATOR_BY_BEGIN_DATE.compare(x.getExecutionYear(), y.getExecutionYear());
        Comparator byRegistrationNumber = (x, y) -> x.getRegistrationNumber().compareTo(y.getRegistrationNumber());
        return byYear.thenComparing(byRegistrationNumber).compare(this, o);
    }

    public ExecutionYear getExecutionYear() {
        return this.executionYear;
    }

    public Registration getRegistration() {
        return this.registration;
    }

    protected Degree getDegree() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getDegree();
    }

    private Student getStudent() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getStudent();
    }

    private Person getPerson() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getPerson();
    }

    public PersonalIngressionData getPersonalIngressionData() {
        Student student = this.getStudent();
        return student == null ? null : student.getPersonalIngressionDataByExecutionYear(this.executionYear);
    }

    private PersonUlisboaSpecifications getPersonUlisboaSpecifications() {
        Person person = this.getPerson();
        return person == null ? null : person.getPersonUlisboaSpecifications();
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        if (this.registration.getStudentCurricularPlansSet().size() == 1) {
            return this.registration.getLastStudentCurricularPlan();
        }
        StudentCurricularPlan studentCurricularPlan = this.registration.getStudentCurricularPlan(this.getExecutionYear());
        if (studentCurricularPlan != null) {
            return studentCurricularPlan;
        }
        studentCurricularPlan = this.registration.getFirstStudentCurricularPlan();
        if (studentCurricularPlan.getStartExecutionYear().isAfterOrEquals(this.getExecutionYear())) {
            return studentCurricularPlan;
        }
        return null;
    }

    public String getStudentNumber() {
        Student student = this.getStudent();
        return student == null ? null : student.getNumber().toString();
    }

    public String getRegistrationNumber() {
        Registration registration = this.getRegistration();
        return registration == null ? null : registration.getNumber().toString();
    }

    public String getDegreeCode() {
        String code;
        String result = null;
        Degree degree = this.getDegree();
        String ministryCode = degree == null ? null : degree.getMinistryCode();
        String string = code = degree == null ? null : degree.getCode();
        if (ministryCode != null) {
            result = ministryCode;
        }
        if (code != null && !code.equals(ministryCode)) {
            result = result.isEmpty() ? code : result + " [" + code + "]";
        }
        return result;
    }

    public String getPersonName() {
        Person person = this.getPerson();
        return person == null ? null : person.getName();
    }

    public String getOtherConcludedRegistrationYears() {
        StringBuilder result = new StringBuilder();
        this.getStudent().getRegistrationsSet().stream().filter(r -> r != this.registration && r.isConcluded() && r.getLastStudentCurricularPlan() != null).forEach(r -> {
            TreeSet executionYears = Sets.newTreeSet(ExecutionYear.COMPARATOR_BY_BEGIN_DATE.reversed());
            executionYears.addAll(RegistrationServices.getEnrolmentYears((Registration)r));
            if (!executionYears.isEmpty()) {
                result.append(((ExecutionYear)executionYears.first()).getQualifiedName()).append("|");
            }
        });
        return result.toString().endsWith("|") ? result.delete(result.length() - 1, result.length()).toString() : result.toString();
    }

    public ProfessionalSituationConditionType getFatherProfessionalCondition() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getFatherProfessionalCondition();
    }

    public ProfessionType getFatherProfessionType() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getFatherProfessionType();
    }

    public SchoolLevelType getFatherSchoolLevel() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getFatherSchoolLevel();
    }

    public Unit getGrantOwnerProvider() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getGrantOwnerProvider();
    }

    public GrantOwnerType getGrantOwnerType() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getGrantOwnerType();
    }

    public SalarySpan getHouseholdSalarySpan() {
        return Optional.ofNullable(this.getPersonUlisboaSpecifications()).map(p -> p.getPersonUlisboaSpecificationsByExcutionYear(this.executionYear)).map(p -> p.getHouseholdSalarySpan()).orElse(null);
    }

    public ProfessionalSituationConditionType getMotherProfessionalCondition() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getMotherProfessionalCondition();
    }

    public ProfessionType getMotherProfessionType() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getMotherProfessionType();
    }

    public SchoolLevelType getMotherSchoolLevel() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getMotherSchoolLevel();
    }

    public ProfessionalSituationConditionType getProfessionalCondition() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getProfessionalCondition();
    }

    public ProfessionType getProfessionalType() {
        PersonalIngressionData personalIngressionData = this.getPersonalIngressionData();
        return personalIngressionData == null ? null : personalIngressionData.getProfessionType();
    }

    public ProfessionTimeType getProfessionTimeType() {
        return Optional.ofNullable(this.getPersonUlisboaSpecifications()).map(p -> p.getPersonUlisboaSpecificationsByExcutionYear(this.executionYear)).map(p -> p.getProfessionTimeType()).orElse(null);
    }
}

