/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.professorship;

import java.text.Collator;
import java.util.Comparator;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipReport;

public class ProfessorshipDegreeReport
extends ProfessorshipReport {
    private final Degree degree;

    public ProfessorshipDegreeReport(ShiftProfessorship shiftProfessorship, Degree degree) {
        super(shiftProfessorship);
        this.degree = degree;
    }

    @Override
    public int compareTo(ProfessorshipReport o) {
        if (!(o instanceof ProfessorshipDegreeReport)) {
            return super.compareTo(o);
        }
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byTeacher = (x, y) -> instance.compare(x.getTeacherName(), y.getTeacherName());
        Comparator bySemesterAndYear = (x, y) -> ExecutionInterval.COMPARATOR_BY_BEGIN_DATE.compare(x.getExecutionPeriod(), y.getExecutionPeriod());
        Comparator byDegreeName = (x, y) -> instance.compare(x.getDegreeName(), y.getDegreeName());
        Comparator byCourseName = (x, y) -> instance.compare(x.getExecutionCourseName(), y.getExecutionCourseName());
        return byTeacher.thenComparing(bySemesterAndYear).thenComparing(byDegreeName).thenComparing(byCourseName).compare(this, (ProfessorshipDegreeReport)o);
    }

    public String getDegreeName() {
        return this.degree.getNameI18N().getContent();
    }

    public String getDegreeCode() {
        return this.degree.getCode();
    }
}

