/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.course;

import java.text.Collator;
import java.util.Comparator;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;

public class CurricularCourseContextReport
implements Comparable<CurricularCourseContextReport> {
    private final CurricularCourse curricularCourse;
    private final Context context;

    public CurricularCourseContextReport(CurricularCourse curricularCourse, Context context) {
        this.curricularCourse = curricularCourse;
        this.context = context;
    }

    @Override
    public int compareTo(CurricularCourseContextReport o) {
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byCourseName = (x, y) -> instance.compare(x.getCompetenceCourseName(), y.getCompetenceCourseName());
        Comparator byCode = (x, y) -> instance.compare(x.getCompetenceCourseCode(), y.getCompetenceCourseCode());
        Comparator byDegreeName = (x, y) -> instance.compare(x.getDegreeName(), y.getDegreeName());
        Comparator byDegreeCode = (x, y) -> instance.compare(x.getDegreeCode(), y.getDegreeCode());
        Comparator byGroupName = (x, y) -> instance.compare(x.getContextGroupName(), y.getContextGroupName());
        return byCourseName.thenComparing(byCode).thenComparing(byDegreeName).thenComparing(byDegreeCode).thenComparing(byGroupName).compare(this, o);
    }

    public String getCompetenceCourseCode() {
        return this.curricularCourse.getCode();
    }

    public String getCompetenceCourseName() {
        return this.curricularCourse.getNameI18N().getContent();
    }

    public String getDegreeCode() {
        return this.curricularCourse.getDegree().getCode();
    }

    public String getDegreeName() {
        return this.curricularCourse.getDegree().getName();
    }

    public String getContextGroupName() {
        return this.context.getParentCourseGroup().getOneFullName();
    }

    public String getDegreeType() {
        return this.curricularCourse.getDegreeType().getName().getContent();
    }

    public String getOfficialDegreeCode() {
        return this.curricularCourse.getDegree().getMinistryCode();
    }

    public String getDegreeCurricularPlanName() {
        return this.context.getParentCourseGroup().getParentDegreeCurricularPlan().getName();
    }

    public String getTypology() {
        return this.context.getParentCourseGroup().isOptionalCourseGroup() ? ULisboaReportsUtil.bundle("curricularCourseContextReport.typology.optional", new String[0]) : ULisboaReportsUtil.bundle("curricularCourseContextReport.typology.mandatory", new String[0]);
    }

    public int getCurricularYear() {
        return this.context.getCurricularYear();
    }

    public String getCurricularPeriod() {
        return this.context.getCurricularPeriod().getLabel();
    }

    public String getContextBeginDate() {
        return this.context.getBeginExecutionPeriod().getQualifiedName();
    }

    public String getContextEndDate() {
        return this.context.getEndExecutionPeriod() == null ? ULisboaReportsUtil.bundle("curricularCourseContextReport.context.open", new String[0]) : this.context.getEndExecutionPeriod().getQualifiedName();
    }
}

