/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.ui.reports.competencecoursemarksheet;

import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.reports.dto.report.competencecoursemarksheet.CompetenceCourseMarkSheetReportParametersBean;
import org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheet.CompetenceCourseMarkSheetReport;
import org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheet.CompetenceCourseMarkSheetReportService;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsBaseController;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsController;
import org.fenixedu.ulisboa.reports.ui.reports.competencecoursemarksheet.CompetenceCourseMarkSheetReportController$callable$processReport;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.domain.file.ULisboaSpecificationsTemporaryFile;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduULisboaReportsController.class, title="label.org.fenixedu.ulisboa.reports.title.competenceCourseMarkSheet", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-reports/reports/competencecoursemarksheet/competencecoursemarksheetreport"})
public class CompetenceCourseMarkSheetReportController
extends FenixeduULisboaReportsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheet/competencecoursemarksheetreport";
    private static final String JSP_PATH;
    private static final String _POSTBACK_URI = "/postback";
    public static final String POSTBACK_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheet/competencecoursemarksheetreport/postback";
    public static final Advice advice$processReport;

    private static String getReportId(String exportName) {
        return CompetenceCourseMarkSheetReportController.normalizeName(CompetenceCourseMarkSheetReportController.bundle("competenceCourseMarkSheet.event." + exportName), "_") + "_UUID_" + UUID.randomUUID().toString();
    }

    private static String getFilename(String reportId) {
        return reportId.substring(0, reportId.indexOf("_UUID_"));
    }

    private static String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }

    public static String normalizeName(String input, String replacement) {
        String result = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace(" ", replacement).replace("[", replacement).replace("]", replacement).replace("*", replacement).replace("?", replacement).replace(":", replacement).replace("/", replacement).replace("\\", replacement);
        while (result.contains(replacement + replacement)) {
            result = result.replace(replacement + replacement, replacement);
        }
        return result.trim();
    }

    private static Collection<CompetenceCourseMarkSheetReport> generateReport(CompetenceCourseMarkSheetReportParametersBean bean) {
        CompetenceCourseMarkSheetReportService service = new CompetenceCourseMarkSheetReportService();
        service.filterEnrolmentExecutionSemester(bean.getExecutionSemester());
        return service.generateReport().stream().sorted().collect(Collectors.toList());
    }

    private void setParametersBean(CompetenceCourseMarkSheetReportParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-ulisboa-reports/reports/competencecoursemarksheet/competencecoursemarksheetreport/search", model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(new CompetenceCourseMarkSheetReportParametersBean(), model);
        return this.jspPage("competencecoursemarksheetreport");
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean") CompetenceCourseMarkSheetReportParametersBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(bean, model);
        return this.jspPage("competencecoursemarksheetreport");
    }

    @RequestMapping(value={"/exportreport"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportReport(@RequestParam(value="bean", required=false) CompetenceCourseMarkSheetReportParametersBean bean, Model model) {
        String reportId = CompetenceCourseMarkSheetReportController.getReportId("exportReport");
        new Thread(() -> this.processReport(this::exportToXLS, bean, reportId)).start();
        return new ResponseEntity((Object)reportId, HttpStatus.OK);
    }

    protected void processReport(Function<CompetenceCourseMarkSheetReportParametersBean, byte[]> function, CompetenceCourseMarkSheetReportParametersBean competenceCourseMarkSheetReportParametersBean, String string) {
        Object object = advice$processReport.perform((Callable)new CompetenceCourseMarkSheetReportController$callable$processReport(this, function, competenceCourseMarkSheetReportParametersBean, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ void advised$processReport(CompetenceCourseMarkSheetReportController this_, Function reportProcessor, CompetenceCourseMarkSheetReportParametersBean bean, String reportId) {
        byte[] content = null;
        try {
            content = (byte[])reportProcessor.apply(bean);
        }
        catch (Throwable e) {
            content = this_.createXLSWithError(e instanceof ULisboaReportsDomainException ? ((ULisboaReportsDomainException)((Object)e)).getLocalizedMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        ULisboaSpecificationsTemporaryFile.create((String)reportId, (byte[])content, (User)Authenticate.getUser());
    }

    private byte[] createXLSWithError(String error) {
        try {
            SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
            builder.addSheet(ULisboaReportsUtil.bundle("competenceCourseMarkSheet.competenceCourseMarkSheet", new String[0]), (SheetData)new SheetData<String>(Collections.singleton(error)){

                protected void makeLine(String item) {
                    this.addCell(ULisboaReportsUtil.bundle("unexpected.error.occured", new String[0]), item);
                }
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            builder.build((OutputStream)result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/exportstatus/{reportId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportStatus(@PathVariable(value="reportId") String reportId, Model model) {
        return new ResponseEntity((Object)String.valueOf(ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId).isPresent()), HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadreport/{reportId}"}, method={RequestMethod.GET})
    public void downloadReport(@PathVariable(value="reportId") String reportId, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        Optional temporaryFile = ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId);
        this.writeFile(response, CompetenceCourseMarkSheetReportController.getFilename(reportId) + "_" + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ((ULisboaSpecificationsTemporaryFile)temporaryFile.get()).getContent());
    }

    private byte[] exportToXLS(CompetenceCourseMarkSheetReportParametersBean bean) {
        Collection<CompetenceCourseMarkSheetReport> toExport = CompetenceCourseMarkSheetReportController.generateReport(bean);
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        builder.addSheet(CompetenceCourseMarkSheetReportController.bundle("competenceCourseMarkSheet.competenceCourseMarkSheet"), (SheetData)new SheetData<CompetenceCourseMarkSheetReport>(toExport){

            protected void makeLine(CompetenceCourseMarkSheetReport report) {
                this.addCompetenceCourseMarkSheetData(report);
            }

            private void addCompetenceCourseMarkSheetData(CompetenceCourseMarkSheetReport report) {
                this.addData("CompetenceCourseMarkSheetReport.courseName", report.getCompetenceCourseName());
                this.addData("CompetenceCourseMarkSheetReport.courseCode", report.getCompetenceCourseCode());
                this.addData("CompetenceCourseMarkSheetReport.executionPresentation", report.getExecutionPresentation());
                this.addData("CompetenceCourseMarkSheetReport.evaluationSeason", report.getEvaluationSeason());
                this.addData("CompetenceCourseMarkSheetReport.creationDate", report.getCreationDate());
                this.addData("CompetenceCourseMarkSheetReport.executionSemester", report.getExecutionSemester());
                this.addData("CompetenceCourseMarkSheetReport.checksum", report.getCheckSum());
                this.addData("CompetenceCourseMarkSheetReport.evaluationDate", report.getEvaluationDate());
                this.addData("CompetenceCourseMarkSheetReport.submissionDate", report.getLastSubmissionDate());
                this.addData("CompetenceCourseMarkSheetReport.certifier", report.getCertifier());
                this.addData("CompetenceCourseMarkSheetReport.state", report.getLastState());
                this.addData("CompetenceCourseMarkSheetReport.printed", report.getPrintStatus());
                this.addData("CompetenceCourseMarkSheetReport.pendingChange", report.getLastPendingChange());
            }

            private void addData(String key, Object value) {
                this.addCell(CompetenceCourseMarkSheetReportController.bundle(key), value == null ? "" : value);
            }
        });
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build((OutputStream)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    @RequestMapping(value={"/postback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> postback(@RequestParam(value="bean", required=false) CompetenceCourseMarkSheetReportParametersBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    static {
        advice$processReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

