/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheetstatechange;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheetstatechange.CompetenceCourseMarkSheetStateChangeReport;

public class CompetenceCourseMarkSheetStateChangeReportService {
    private ExecutionInterval executionInterval;
    private CompetenceCourse competenceCourse;

    public void filterEnrolmentExecutionSemester(ExecutionInterval executionInterval) {
        this.executionInterval = executionInterval;
    }

    public void filterEnrolmentCompetenceCourse(CompetenceCourse competenceCourse) {
        this.competenceCourse = competenceCourse;
    }

    public Collection<CompetenceCourseMarkSheetStateChangeReport> generateReport() {
        return this.process(this.executionInterval, this.competenceCourse);
    }

    private Collection<CompetenceCourseMarkSheetStateChangeReport> process(ExecutionInterval executionInterval, CompetenceCourse competenceCourse) {
        return this.buildSearchUniverse(executionInterval, competenceCourse).stream().map(this::buildReport).collect(Collectors.toSet());
    }

    private Set<CompetenceCourseMarkSheet> buildSearchUniverse(ExecutionInterval executionInterval, CompetenceCourse competenceCourse) {
        return competenceCourse.getCompetenceCourseMarkSheetSet().stream().filter(ccms -> ccms.getExecutionSemester().getOid().equals(executionInterval.getOid()) && ccms.isConfirmed()).filter(ccms -> ccms.getCompetenceCourse().getOid().equals(competenceCourse.getOid())).collect(Collectors.toSet());
    }

    private CompetenceCourseMarkSheetStateChangeReport buildReport(CompetenceCourseMarkSheet competenceCourseMarkSheet) {
        return new CompetenceCourseMarkSheetStateChangeReport(competenceCourseMarkSheet);
    }
}

