/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.ui.reports.scholarshiptypology;

import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.reports.dto.report.scholarshiptypology.ScholarshipTypologyReportParametersBean;
import org.fenixedu.ulisboa.reports.services.report.scholarshiptypology.ScholarshipTypologyReport;
import org.fenixedu.ulisboa.reports.services.report.scholarshiptypology.ScholarshipTypologyReportService;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsBaseController;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsController;
import org.fenixedu.ulisboa.reports.ui.reports.scholarshiptypology.ScholarshipTypologyReportController$callable$processReport;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.domain.file.ULisboaSpecificationsTemporaryFile;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduULisboaReportsController.class, title="label.org.fenixedu.ulisboa.reports.title.scholarshipTypology", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-reports/reports/scholarshiptypology/scholarshiptypologyreport"})
public class ScholarshipTypologyReportController
extends FenixeduULisboaReportsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-reports/reports/scholarshiptypology/scholarshiptypologyreport";
    private static final String JSP_PATH;
    private static final String _POSTBACK_URI = "/postback";
    public static final String POSTBACK_URL = "/fenixedu-ulisboa-reports/reports/scholarshiptypology/scholarshiptypologyreport/postback";
    public static final Advice advice$processReport;

    private void setParametersBean(ScholarshipTypologyReportParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-ulisboa-reports/reports/scholarshiptypology/scholarshiptypologyreport/search", model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(new ScholarshipTypologyReportParametersBean(), model);
        return this.jspPage("scholarshiptypologyreport");
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean") ScholarshipTypologyReportParametersBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(bean, model);
        this.setResults(ScholarshipTypologyReportController.generateReport(bean), model);
        return this.jspPage("scholarshiptypologyreport");
    }

    private void setResults(Collection<ScholarshipTypologyReport> results, Model model) {
        model.addAttribute("results", results);
    }

    private static String getReportId(String exportName) {
        return ScholarshipTypologyReportController.normalizeName(ScholarshipTypologyReportController.bundle("scholarshipTypology.event." + exportName), "_") + "_UUID_" + UUID.randomUUID().toString();
    }

    private static String getFilename(String reportId) {
        return reportId.substring(0, reportId.indexOf("_UUID_"));
    }

    public static String normalizeName(String input, String replacement) {
        String result = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace(" ", replacement).replace("[", replacement).replace("]", replacement).replace("*", replacement).replace("?", replacement).replace(":", replacement).replace("/", replacement).replace("\\", replacement);
        while (result.contains(replacement + replacement)) {
            result = result.replace(replacement + replacement, replacement);
        }
        return result.trim();
    }

    private static String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }

    @RequestMapping(value={"/exportreport"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportReport(@RequestParam(value="bean", required=false) ScholarshipTypologyReportParametersBean bean, Model model) {
        String reportId = ScholarshipTypologyReportController.getReportId("exportReport");
        new Thread(() -> this.processReport(this::exportToXLS, bean, reportId)).start();
        return new ResponseEntity((Object)reportId, HttpStatus.OK);
    }

    protected void processReport(Function<ScholarshipTypologyReportParametersBean, byte[]> function, ScholarshipTypologyReportParametersBean scholarshipTypologyReportParametersBean, String string) {
        Object object = advice$processReport.perform((Callable)new ScholarshipTypologyReportController$callable$processReport(this, function, scholarshipTypologyReportParametersBean, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ void advised$processReport(ScholarshipTypologyReportController this_, Function reportProcessor, ScholarshipTypologyReportParametersBean bean, String reportId) {
        byte[] content = null;
        try {
            content = (byte[])reportProcessor.apply(bean);
        }
        catch (Throwable e) {
            content = this_.createXLSWithError(e instanceof ULisboaReportsDomainException ? ((ULisboaReportsDomainException)((Object)e)).getLocalizedMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        ULisboaSpecificationsTemporaryFile.create((String)reportId, (byte[])content, (User)Authenticate.getUser());
    }

    @RequestMapping(value={"/exportstatus/{reportId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportStatus(@PathVariable(value="reportId") String reportId, Model model) {
        return new ResponseEntity((Object)String.valueOf(ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId).isPresent()), HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadreport/{reportId}"}, method={RequestMethod.GET})
    public void downloadReport(@PathVariable(value="reportId") String reportId, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        Optional temporaryFile = ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId);
        this.writeFile(response, ScholarshipTypologyReportController.getFilename(reportId) + "_" + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ((ULisboaSpecificationsTemporaryFile)temporaryFile.get()).getContent());
    }

    private static Collection<ScholarshipTypologyReport> generateReport(ScholarshipTypologyReportParametersBean bean) {
        ScholarshipTypologyReportService service = new ScholarshipTypologyReportService();
        service.filterEnrolmentExecutionYear(bean.getExecutionYear());
        return service.generateReport().stream().sorted().collect(Collectors.toList());
    }

    private byte[] exportToXLS(final ScholarshipTypologyReportParametersBean bean) {
        Collection<ScholarshipTypologyReport> toExport = ScholarshipTypologyReportController.generateReport(bean);
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        builder.addSheet(ULisboaReportsUtil.bundle("scholarshipTypology.scholarshipTypology", new String[0]), (SheetData)new SheetData<ScholarshipTypologyReport>(toExport){

            protected void makeLine(ScholarshipTypologyReport report) {
                this.addPrimaryData(report);
                this.addComplementarPersonalData(bean, report);
            }

            private void addPrimaryData(ScholarshipTypologyReport report) {
                this.addData("ScholarshipTypologyReport.executionYear", report.getExecutionYear().getQualifiedName());
                this.addData("ScholarshipTypologyReport.studentNumber", report.getStudentNumber());
                this.addData("ScholarshipTypologyReport.personName", report.getPersonName());
                this.addData("ScholarshipTypologyReport.degreeMinistryCode", report.getDegreeCode());
            }

            private void addComplementarPersonalData(ScholarshipTypologyReportParametersBean bean2, ScholarshipTypologyReport report) {
                this.addData("ScholarshipTypologyReport.professionalCondition", this.getProfessionalCondition(report));
                this.addData("ScholarshipTypologyReport.professionType", this.getProfessionalType(report));
                this.addData("ScholarshipTypologyReport.professionTimeType", this.getProfessionTimeType(report));
                this.addData("ScholarshipTypologyReport.grantOwnerType", this.getGrantOwnerType(report));
                this.addData("ScholarshipTypologyReport.grantOwnerProvider", this.getGrantOwnerProvider(report));
                this.addData("ScholarshipTypologyReport.motherSchoolLevel", this.getMotherSchoolLevel(report));
                this.addData("ScholarshipTypologyReport.motherProfessionType", this.getMotherProfessionType(report));
                this.addData("ScholarshipTypologyReport.motherProfessionalCondition", this.getMotherProfessionalCondition(report));
                this.addData("ScholarshipTypologyReport.fatherSchoolLevel", this.getFatherSchoolLevel(report));
                this.addData("ScholarshipTypologyReport.fatherProfessionType", this.getFatherProfessionType(report));
                this.addData("ScholarshipTypologyReport.fatherProfessionalCondition", this.getFatherProfessionalCondition(report));
                this.addData("ScholarshipTypologyReport.householdSalarySpan", this.getHouseholdSalarySpan(report));
            }

            private String getProfessionalCondition(ScholarshipTypologyReport report) {
                return report.getProfessionalCondition() != null ? report.getProfessionalCondition().getLocalizedName() : null;
            }

            private String getProfessionalType(ScholarshipTypologyReport report) {
                return report.getProfessionalType() != null ? report.getProfessionalType().getLocalizedName() : null;
            }

            private String getProfessionTimeType(ScholarshipTypologyReport report) {
                return report.getProfessionTimeType() != null ? report.getProfessionTimeType().getLocalizedName() : null;
            }

            private String getGrantOwnerType(ScholarshipTypologyReport report) {
                return report.getGrantOwnerType() != null ? ULisboaReportsUtil.bundle("GrantOwnerType." + report.getGrantOwnerType(), new String[0]) : null;
            }

            private String getGrantOwnerProvider(ScholarshipTypologyReport report) {
                return report.getGrantOwnerProvider() != null ? report.getGrantOwnerProvider().getNameI18n().getContent() : null;
            }

            private String getMotherSchoolLevel(ScholarshipTypologyReport report) {
                return report.getMotherSchoolLevel() != null ? report.getMotherSchoolLevel().getLocalizedName() : null;
            }

            private String getMotherProfessionType(ScholarshipTypologyReport report) {
                return report.getMotherProfessionType() != null ? report.getMotherProfessionType().getLocalizedName() : null;
            }

            private String getMotherProfessionalCondition(ScholarshipTypologyReport report) {
                return report.getMotherProfessionalCondition() != null ? report.getMotherProfessionalCondition().getLocalizedName() : null;
            }

            private String getFatherSchoolLevel(ScholarshipTypologyReport report) {
                return report.getFatherSchoolLevel() != null ? report.getFatherSchoolLevel().getLocalizedName() : null;
            }

            private String getFatherProfessionType(ScholarshipTypologyReport report) {
                return report.getFatherProfessionType() != null ? report.getFatherProfessionType().getLocalizedName() : null;
            }

            private String getFatherProfessionalCondition(ScholarshipTypologyReport report) {
                return report.getFatherProfessionalCondition() != null ? report.getFatherProfessionalCondition().getLocalizedName() : null;
            }

            private String getHouseholdSalarySpan(ScholarshipTypologyReport report) {
                return report.getHouseholdSalarySpan() != null ? report.getHouseholdSalarySpan().getLocalizedName() : null;
            }

            private void addData(String key, Object value) {
                this.addCell(ScholarshipTypologyReportController.bundle(key), value == null ? "" : value);
            }

            private String booleanString(boolean value) {
                return value ? ScholarshipTypologyReportController.bundle("yes") : ScholarshipTypologyReportController.bundle("no");
            }
        });
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build((OutputStream)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    private byte[] createXLSWithError(String error) {
        try {
            SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
            builder.addSheet(ULisboaReportsUtil.bundle("scholarshipTypology.scholarshipTypology", new String[0]), (SheetData)new SheetData<String>(Collections.singleton(error)){

                protected void makeLine(String item) {
                    this.addCell(ULisboaReportsUtil.bundle("unexpected.error.occured", new String[0]), item);
                }
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            builder.build((OutputStream)result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/postback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> postback(@RequestParam(value="bean", required=false) ScholarshipTypologyReportParametersBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    static {
        advice$processReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

