/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.ui.reports.professorship;

import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.reports.dto.report.professorship.ProfessorshipReportParametersBean;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipDegreeReport;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipDegreeReportService;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipReport;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipReportService;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsBaseController;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsController;
import org.fenixedu.ulisboa.reports.ui.reports.professorship.ProfessorshipReportController$callable$processReport;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.domain.file.ULisboaSpecificationsTemporaryFile;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduULisboaReportsController.class, title="label.org.fenixedu.ulisboa.reports.title.professorship", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-reports/reports/professorship/professorshipreport"})
public class ProfessorshipReportController
extends FenixeduULisboaReportsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-reports/reports/professorship/professorshipreport";
    private static final String JSP_PATH;
    private static final String _POSTBACK_URI = "/postback";
    public static final String POSTBACK_URL = "/fenixedu-ulisboa-reports/reports/professorship/professorshipreport/postback";
    public static final Advice advice$processReport;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-ulisboa-reports/reports/professorship/professorshipreport/search", model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(new ProfessorshipReportParametersBean(), model);
        return this.jspPage("professorshipreport");
    }

    private void setParametersBean(ProfessorshipReportParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean") ProfessorshipReportParametersBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(bean, model);
        this.setResults(ProfessorshipReportController.generateProfessorshipReport(bean), model);
        return this.jspPage("professorshipreport");
    }

    private void setResults(Collection<? extends ProfessorshipReport> results, Model model) {
        model.addAttribute("results", results);
    }

    private static Collection<ProfessorshipReport> generateProfessorshipReport(ProfessorshipReportParametersBean bean) {
        ProfessorshipReportService service = new ProfessorshipReportService();
        service.filterEnrolmentExecutionYear(bean.getExecutionYear());
        return service.generateReport().stream().sorted().collect(Collectors.toList());
    }

    @RequestMapping(value={"/exportreport"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportReport(@RequestParam(value="bean", required=false) ProfessorshipReportParametersBean bean, Model model) {
        String reportId = ProfessorshipReportController.getReportId("exportReport");
        new Thread(() -> this.processReport(this::exportToXLS, bean, reportId)).start();
        return new ResponseEntity((Object)reportId, HttpStatus.OK);
    }

    private static String getReportId(String exportName) {
        return ProfessorshipReportController.normalizeName(ProfessorshipReportController.bundle("professorship.event." + exportName), "_") + "_UUID_" + UUID.randomUUID().toString();
    }

    public static String normalizeName(String input, String replacement) {
        String result = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace(" ", replacement).replace("[", replacement).replace("]", replacement).replace("*", replacement).replace("?", replacement).replace(":", replacement).replace("/", replacement).replace("\\", replacement);
        while (result.contains(replacement + replacement)) {
            result = result.replace(replacement + replacement, replacement);
        }
        return result.trim();
    }

    private static String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }

    protected void processReport(Function<ProfessorshipReportParametersBean, byte[]> function, ProfessorshipReportParametersBean professorshipReportParametersBean, String string) {
        Object object = advice$processReport.perform((Callable)new ProfessorshipReportController$callable$processReport(this, function, professorshipReportParametersBean, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ void advised$processReport(ProfessorshipReportController this_, Function reportProcessor, ProfessorshipReportParametersBean bean, String reportId) {
        byte[] content = null;
        try {
            content = (byte[])reportProcessor.apply(bean);
        }
        catch (Throwable e) {
            content = this_.createXLSWithError(e instanceof ULisboaReportsDomainException ? ((ULisboaReportsDomainException)((Object)e)).getLocalizedMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        ULisboaSpecificationsTemporaryFile.create((String)reportId, (byte[])content, (User)Authenticate.getUser());
    }

    private byte[] createXLSWithError(String error) {
        try {
            SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
            builder.addSheet(ULisboaReportsUtil.bundle("professorship.professorship", new String[0]), (SheetData)new SheetData<String>(Collections.singleton(error)){

                protected void makeLine(String item) {
                    this.addCell(ULisboaReportsUtil.bundle("unexpected.error.occured", new String[0]), item);
                }
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            builder.build((OutputStream)result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/exportstatus/{reportId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportStatus(@PathVariable(value="reportId") String reportId, Model model) {
        return new ResponseEntity((Object)String.valueOf(ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId).isPresent()), HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadreport/{reportId}"}, method={RequestMethod.GET})
    public void downloadReport(@PathVariable(value="reportId") String reportId, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        Optional temporaryFile = ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId);
        this.writeFile(response, ProfessorshipReportController.getFilename(reportId) + "_" + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ((ULisboaSpecificationsTemporaryFile)temporaryFile.get()).getContent());
    }

    private static String getFilename(String reportId) {
        return reportId.substring(0, reportId.indexOf("_UUID_"));
    }

    private byte[] exportToXLS(ProfessorshipReportParametersBean bean) {
        Collection<ProfessorshipReport> toExport = ProfessorshipReportController.generateProfessorshipReport(bean);
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        builder.addSheet(ULisboaReportsUtil.bundle("professorship.professorship", new String[0]), (SheetData)new SheetData<ProfessorshipReport>(toExport){

            protected void makeLine(ProfessorshipReport report) {
                this.addPrimaryData(report);
                this.addProfessorshipData(report);
            }

            private void addPrimaryData(ProfessorshipReport report) {
                this.addData("ProfessorshipReport.teacher", report.getTeacherName());
                this.addData("ProfessorshipReport.teacherUsername", report.getTeacherUsername());
                this.addData("ProfessorshipReport.teacherDepartment", report.getTeacherDepartment());
                this.addData("ProfessorshipReport.responsible", report.getIsResponsible());
                this.addData("ProfessorshipReport.executionYear", report.getExecutionYearName());
                this.addData("ProfessorshipReport.executionSemester", report.getExecutionSemesterName());
            }

            private void addData(String key, Object value) {
                this.addCell(ProfessorshipReportController.bundle(key), value == null ? "" : value);
            }

            private void addProfessorshipData(ProfessorshipReport report) {
                this.addData("ProfessorshipReport.executionCourse", report.getExecutionCourseName());
                this.addData("ProfessorshipReport.courseCode", report.getCompetenceCourseCode());
                this.addData("ProfessorshipReport.courseRegime", report.getCompetenceCourseRegime());
                this.addData("ProfessorshipReport.courseDepartment", report.getCompetenceCourseDepartment());
                this.addData("ProfessorshipReport.classes", report.getClassesName());
                this.addData("ProfessorshipReport.shift", report.getShiftName());
                this.addData("ProfessorshipReport.shiftType", report.getShiftTypeName());
                this.addData("ProfessorshipReport.shiftOcupation", report.getShiftOccupation());
                this.addData("ProfessorshipReport.shiftCapacity", report.getShiftCapacity());
                this.addData("ProfessorshipReport.totalHours", report.getTotalHours());
                this.addData("ProfessorshipReport.allocationPercentage", report.getAllocationPercentage());
                this.addData("ProfessorshipReport.workload", report.getTeacherHours());
            }
        });
        Collection<ProfessorshipDegreeReport> newReports = ProfessorshipReportController.generateProfessorshipDegreeReport(toExport);
        builder.addSheet(ULisboaReportsUtil.bundle("professorship.professorshipDegree", new String[0]), (SheetData)new SheetData<ProfessorshipDegreeReport>(newReports){

            protected void makeLine(ProfessorshipDegreeReport report) {
                this.addPrimaryData(report);
                this.addDegreeData(report);
                this.addProfessorshipData(report);
            }

            private void addPrimaryData(ProfessorshipDegreeReport report) {
                this.addData("ProfessorshipReport.teacher", report.getTeacherName());
                this.addData("ProfessorshipReport.teacherUsername", report.getTeacherUsername());
                this.addData("ProfessorshipReport.teacherDepartment", report.getTeacherDepartment());
                this.addData("ProfessorshipReport.responsible", report.getIsResponsible());
                this.addData("ProfessorshipReport.executionYear", report.getExecutionYearName());
                this.addData("ProfessorshipReport.executionSemester", report.getExecutionSemesterName());
            }

            private void addData(String key, Object value) {
                this.addCell(ProfessorshipReportController.bundle(key), value == null ? "" : value);
            }

            private void addDegreeData(ProfessorshipDegreeReport report) {
                this.addData("ProfessorshipDegreeReport.degree", report.getDegreeName());
                this.addData("ProfessorshipDegreeReport.degreeCode", report.getDegreeCode());
            }

            private void addProfessorshipData(ProfessorshipDegreeReport report) {
                this.addData("ProfessorshipReport.executionCourse", report.getExecutionCourseName());
                this.addData("ProfessorshipReport.courseCode", report.getCompetenceCourseCode());
                this.addData("ProfessorshipReport.courseRegime", report.getCompetenceCourseRegime());
                this.addData("ProfessorshipReport.courseDepartment", report.getCompetenceCourseDepartment());
                this.addData("ProfessorshipReport.classes", report.getClassesName());
                this.addData("ProfessorshipReport.shift", report.getShiftName());
                this.addData("ProfessorshipReport.shiftType", report.getShiftTypeName());
                this.addData("ProfessorshipReport.shiftOcupation", report.getShiftOccupation());
                this.addData("ProfessorshipReport.shiftCapacity", report.getShiftCapacity());
                this.addData("ProfessorshipReport.totalHours", report.getTotalHours());
                this.addData("ProfessorshipReport.allocationPercentage", report.getAllocationPercentage());
                this.addData("ProfessorshipReport.workload", report.getTeacherHours());
            }
        });
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build((OutputStream)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    private static Collection<ProfessorshipDegreeReport> generateProfessorshipDegreeReport(Collection<ProfessorshipReport> professorshipReports) {
        Set<ShiftProfessorship> shiftProfessorships = professorshipReports.stream().map(pr -> pr.getShiftProfessorship()).collect(Collectors.toSet());
        ProfessorshipDegreeReportService service = new ProfessorshipDegreeReportService(shiftProfessorships);
        return service.generateReport().stream().sorted().collect(Collectors.toList());
    }

    @RequestMapping(value={"/postback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> postback(@RequestParam(value="bean", required=false) ProfessorshipReportParametersBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    static {
        advice$processReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

