/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.ui.reports.course;

import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.reports.dto.report.course.CourseReportParametersBean;
import org.fenixedu.ulisboa.reports.services.report.course.CompetenceCourseReport;
import org.fenixedu.ulisboa.reports.services.report.course.CompetenceCourseReportService;
import org.fenixedu.ulisboa.reports.services.report.course.CompetenceCourseService;
import org.fenixedu.ulisboa.reports.services.report.course.CurricularCourseContextReport;
import org.fenixedu.ulisboa.reports.services.report.course.CurricularCourseContextReportService;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsBaseController;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsController;
import org.fenixedu.ulisboa.reports.ui.reports.course.CourseReportController$callable$processReport;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.domain.file.ULisboaSpecificationsTemporaryFile;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduULisboaReportsController.class, title="label.org.fenixedu.ulisboa.reports.title.course", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-reports/reports/course/coursereport"})
public class CourseReportController
extends FenixeduULisboaReportsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-reports/reports/course/coursereport";
    private static final String JSP_PATH;
    private static final String _POSTBACK_URI = "/postback";
    public static final String POSTBACK_URL = "/fenixedu-ulisboa-reports/reports/course/coursereport/postback";
    public static final Advice advice$processReport;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-ulisboa-reports/reports/course/coursereport/search", model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(new CourseReportParametersBean(), model);
        return this.jspPage("coursereport");
    }

    private void setParametersBean(CourseReportParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean") CourseReportParametersBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(bean, model);
        return this.jspPage("coursereport");
    }

    @RequestMapping(value={"/exportreport"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportReport(@RequestParam(value="bean", required=false) CourseReportParametersBean bean, Model model) {
        String reportId = CourseReportController.getReportId("exportReport");
        new Thread(() -> this.processReport(this::exportToXLS, bean, reportId)).start();
        return new ResponseEntity((Object)reportId, HttpStatus.OK);
    }

    private static String getReportId(String exportName) {
        return CourseReportController.normalizeName(CourseReportController.bundle("course.event." + exportName), "_") + "_UUID_" + UUID.randomUUID().toString();
    }

    public static String normalizeName(String input, String replacement) {
        String result = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace(" ", replacement).replace("[", replacement).replace("]", replacement).replace("*", replacement).replace("?", replacement).replace(":", replacement).replace("/", replacement).replace("\\", replacement);
        while (result.contains(replacement + replacement)) {
            result = result.replace(replacement + replacement, replacement);
        }
        return result.trim();
    }

    private static String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }

    protected void processReport(Function<CourseReportParametersBean, byte[]> function, CourseReportParametersBean courseReportParametersBean, String string) {
        Object object = advice$processReport.perform((Callable)new CourseReportController$callable$processReport(this, function, courseReportParametersBean, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ void advised$processReport(CourseReportController this_, Function reportProcessor, CourseReportParametersBean bean, String reportId) {
        byte[] content = null;
        try {
            content = (byte[])reportProcessor.apply(bean);
        }
        catch (Throwable e) {
            content = this_.createXLSWithError(e instanceof ULisboaReportsDomainException ? ((ULisboaReportsDomainException)((Object)e)).getLocalizedMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        ULisboaSpecificationsTemporaryFile.create((String)reportId, (byte[])content, (User)Authenticate.getUser());
    }

    private byte[] createXLSWithError(String error) {
        try {
            SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
            builder.addSheet(ULisboaReportsUtil.bundle("competenceCourse.competenceCourse", new String[0]), (SheetData)new SheetData<String>(Collections.singleton(error)){

                protected void makeLine(String item) {
                    this.addCell(ULisboaReportsUtil.bundle("unexpected.error.occured", new String[0]), item);
                }
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            builder.build((OutputStream)result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/exportstatus/{reportId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportStatus(@PathVariable(value="reportId") String reportId, Model model) {
        return new ResponseEntity((Object)String.valueOf(ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId).isPresent()), HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadreport/{reportId}"}, method={RequestMethod.GET})
    public void downloadReport(@PathVariable(value="reportId") String reportId, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        Optional temporaryFile = ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId);
        this.writeFile(response, CourseReportController.getFilename(reportId) + "_" + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ((ULisboaSpecificationsTemporaryFile)temporaryFile.get()).getContent());
    }

    private static String getFilename(String reportId) {
        return reportId.substring(0, reportId.indexOf("_UUID_"));
    }

    private byte[] exportToXLS(CourseReportParametersBean bean) {
        CompetenceCourseService service = new CompetenceCourseService();
        service.filterExecutionYear(bean.getExecutionYear());
        Collection<CompetenceCourse> competenceCourses = service.process();
        CompetenceCourseReportService competenceCourseReportService = new CompetenceCourseReportService(competenceCourses);
        Collection competenceCourseReports = competenceCourseReportService.generateReport().stream().sorted().collect(Collectors.toList());
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        builder.addSheet(ULisboaReportsUtil.bundle("course.competenceCourse", new String[0]), (SheetData)new SheetData<CompetenceCourseReport>((Iterable)competenceCourseReports){

            protected void makeLine(CompetenceCourseReport report) {
                this.addCompetenceCourseData(report);
            }

            private void addCompetenceCourseData(CompetenceCourseReport report) {
                this.addData("CompetenceCourseReport.code", report.getCode());
                this.addData("CompetenceCourseReport.name", report.getName());
                this.addData("CompetenceCourseReport.nameEN", report.getNameEn());
                this.addData("CompetenceCourseReport.beginDate", report.getBeginExecutionPeriod());
                this.addData("CompetenceCourseReport.department", report.getDepartment());
                this.addData("CompetenceCourseReport.area", report.getScientificArea());
                this.addData("CompetenceCourseReport.acronym", report.getAcronym());
                this.addData("CompetenceCourseReport.type", report.getType());
                this.addData("CompetenceCourseReport.regime", report.getRegime());
                this.addData("CompetenceCourseReport.load.theoretical", report.getTheoreticalHours());
                this.addData("CompetenceCourseReport.load.problems", report.getProblemsHours());
                this.addData("CompetenceCourseReport.load.laboratorial", report.getLaboratorialHours());
                this.addData("CompetenceCourseReport.load.seminary", report.getSeminaryHours());
                this.addData("CompetenceCourseReport.load.fieldWork", report.getFieldWorkHours());
                this.addData("CompetenceCourseReport.load.training", report.getTrainingPeriodHours());
                this.addData("CompetenceCourseReport.load.tutorialOrientation", report.getTutorialOrientationHours());
                this.addData("CompetenceCourseReport.load.other", report.getOtherHours());
                this.addData("CompetenceCourseReport.load.autonomous", report.getAutonomousWorkHours());
                this.addData("CompetenceCourseReport.load.total", report.getTotalHours());
                this.addData("CompetenceCourseReport.ects", report.getECTS());
            }

            private void addData(String key, Object value) {
                this.addCell(CourseReportController.bundle(key), value == null ? "" : value);
            }
        });
        CurricularCourseContextReportService curricularContextService = new CurricularCourseContextReportService(competenceCourses, bean.getExecutionYear());
        Collection curricularContextReports = curricularContextService.generateReport().stream().sorted().collect(Collectors.toList());
        builder.addSheet(ULisboaReportsUtil.bundle("course.curricularCourse", new String[0]), (SheetData)new SheetData<CurricularCourseContextReport>((Iterable)curricularContextReports){

            protected void makeLine(CurricularCourseContextReport report) {
                this.addCurricularCourseContextData(report);
            }

            private void addCurricularCourseContextData(CurricularCourseContextReport report) {
                this.addData("curricularCourseContextReport.courseCode", report.getCompetenceCourseCode());
                this.addData("curricularCourseContextReport.courseName", report.getCompetenceCourseName());
                this.addData("curricularCourseContextReport.degreeCode", report.getDegreeCode());
                this.addData("curricularCourseContextReport.officialDegreeCode", report.getOfficialDegreeCode());
                this.addData("curricularCourseContextReport.degreeName", report.getDegreeName());
                this.addData("curricularCourseContextReport.degreeType", report.getDegreeType());
                this.addData("curricularCourseContextReport.curricularPlan", report.getDegreeCurricularPlanName());
                this.addData("curricularCourseContextReport.group", report.getContextGroupName());
                this.addData("curricularCourseContextReport.typology", report.getTypology());
                this.addData("curricularCourseContextReport.curricularYear", report.getCurricularYear());
                this.addData("curricularCourseContextReport.curricularPeriod", report.getCurricularPeriod());
                this.addData("curricularCourseContextReport.beginDate", report.getContextBeginDate());
                this.addData("curricularCourseContextReport.endDate", report.getContextEndDate());
            }

            private void addData(String key, Object value) {
                this.addCell(CourseReportController.bundle(key), value == null ? "" : value);
            }
        });
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build((OutputStream)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    @RequestMapping(value={"/postback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> postback(@RequestParam(value="bean", required=false) CourseReportParametersBean bean, Model model) {
        bean.updateData();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    static {
        advice$processReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

