/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.ui.reports.competencecoursemarksheetstatechange;

import fr.opensagres.xdocreport.core.io.internal.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetChangeRequestStateEnum;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshotEntry;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateEnum;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.spreadsheet.SheetData;
import org.fenixedu.commons.spreadsheet.SpreadsheetBuilderForXLSX;
import org.fenixedu.ulisboa.reports.domain.exceptions.ULisboaReportsDomainException;
import org.fenixedu.ulisboa.reports.dto.report.competencecoursemarksheetstatechange.CompetenceCourseMarkSheetStateChangeReportParametersBean;
import org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheetstatechange.CompetenceCourseMarkSheetStateChangeReport;
import org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheetstatechange.CompetenceCourseMarkSheetStateChangeReportService;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsBaseController;
import org.fenixedu.ulisboa.reports.ui.FenixeduULisboaReportsController;
import org.fenixedu.ulisboa.reports.ui.reports.competencecoursemarksheetstatechange.CompetenceCourseMarkSheetStateChangeReportController$callable$processReport;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.domain.file.ULisboaSpecificationsTemporaryFile;
import org.joda.time.DateTime;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=FenixeduULisboaReportsController.class, title="label.org.fenixedu.ulisboa.reports.title.competenceCourseMarkSheetStateChange", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport"})
public class CompetenceCourseMarkSheetStateChangeReportController
extends FenixeduULisboaReportsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport";
    private static final String JSP_PATH;
    private static final String _POSTBACK_URI = "/postback";
    public static final String POSTBACK_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport/postback";
    private static final String _SEARCH_CHANGE_REQUESTS_URI = "/searchchangerequests/";
    public static final String SEARCH_CHANGE_REQUESTS_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport/searchchangerequests/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport/search/view/";
    private static final String _SEARCHPOSTBACK_URI = "/searchpostback/";
    public static final String SEARCHPOSTBACK_URL = "/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport/searchpostback/";
    public static final Advice advice$processReport;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/fenixedu-ulisboa-reports/reports/competencecoursemarksheetstatechange/competencecoursemarksheetstatechangereport/search", model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(@RequestParam(value="executionsemester", required=false) ExecutionInterval executionInterval, @RequestParam(value="competencecourse", required=false) CompetenceCourse competenceCourse, Model model, RedirectAttributes redirectAttributes) {
        List<CompetenceCourseMarkSheet> searchResultsDataSet = this.filterSearch(executionInterval, competenceCourse);
        this.setParametersBean(new CompetenceCourseMarkSheetStateChangeReportParametersBean(), model);
        model.addAttribute("searchcompetencecoursemarksheetstatechangeResultsDataSet", searchResultsDataSet);
        return this.jspPage("competencecoursemarksheetstatechangereport");
    }

    private void setParametersBean(CompetenceCourseMarkSheetStateChangeReportParametersBean bean, Model model) {
        bean.update();
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private List<CompetenceCourseMarkSheet> filterSearch(ExecutionInterval executionInterval, CompetenceCourse competenceCourse) {
        return this.getSearchUniverseSearchDataSet(executionInterval, competenceCourse).collect(Collectors.toList());
    }

    private Stream<CompetenceCourseMarkSheet> getSearchUniverseSearchDataSet(ExecutionInterval interval, CompetenceCourse competence) {
        return CompetenceCourseMarkSheet.findBy((ExecutionInterval)interval, (CompetenceCourse)competence, (ExecutionCourse)null, (EvaluationSeason)null, (DateTime)null, (Set)null, (CompetenceCourseMarkSheetStateEnum)null, (CompetenceCourseMarkSheetChangeRequestStateEnum)null);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    @RequestMapping(value={"/searchchangerequests/{oid}"}, method={RequestMethod.GET})
    public String searchChangeRequests(@PathVariable(value="oid") CompetenceCourseMarkSheetStateChangeReportParametersBean competenceCourseMarkSheetStateChangeReportParametersBean, Model model, RedirectAttributes redirectAttributes) throws IOException {
        this.setParametersBean(competenceCourseMarkSheetStateChangeReportParametersBean, model);
        this.setResults(CompetenceCourseMarkSheetStateChangeReportController.generateReport(competenceCourseMarkSheetStateChangeReportParametersBean), model);
        return this.jspPage("searchchangerequests");
    }

    private static Collection<CompetenceCourseMarkSheetStateChangeReport> generateReport(CompetenceCourseMarkSheetStateChangeReportParametersBean bean) {
        CompetenceCourseMarkSheetStateChangeReportService service = new CompetenceCourseMarkSheetStateChangeReportService();
        service.filterEnrolmentExecutionSemester(bean.getExecutionSemester());
        service.filterEnrolmentCompetenceCourse(bean.getCompetenceCourse());
        return service.generateReport().stream().sorted().collect(Collectors.toList());
    }

    private void setResults(Collection<CompetenceCourseMarkSheetStateChangeReport> results, Model model) {
        model.addAttribute("results", results);
    }

    @RequestMapping(value={"/searchpostback/"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> searchpostback(@RequestParam(value="bean", required=false) CompetenceCourseMarkSheetStateChangeReportParametersBean bean, Model model) {
        bean.update();
        this.setParametersBean(bean, model);
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.POST})
    public String search(@RequestParam(value="bean") CompetenceCourseMarkSheetStateChangeReportParametersBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setParametersBean(bean, model);
        model.addAttribute("searchcompetencecoursemarksheetstatechangeResultsDataSet", this.filterSearch(bean.getExecutionSemester(), bean.getCompetenceCourse()));
        this.setResults(CompetenceCourseMarkSheetStateChangeReportController.generateReport(bean), model);
        return this.jspPage("competencecoursemarksheetstatechangereport");
    }

    @RequestMapping(value={"/exportreport"}, method={RequestMethod.POST}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportReport(@RequestParam(value="bean", required=false) CompetenceCourseMarkSheetStateChangeReportParametersBean bean, Model model) {
        String reportId = CompetenceCourseMarkSheetStateChangeReportController.getReportId("exportReport");
        new Thread(() -> this.processReport(this::exportToXLS, bean, reportId)).start();
        return new ResponseEntity((Object)reportId, HttpStatus.OK);
    }

    private static String getReportId(String exportName) {
        return CompetenceCourseMarkSheetStateChangeReportController.normalizeName(CompetenceCourseMarkSheetStateChangeReportController.bundle("competenceCourseMarkSheetStateChange.event." + exportName), "_") + "_UUID_" + UUID.randomUUID().toString();
    }

    private static String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }

    public static String normalizeName(String input, String replacement) {
        String result = Normalizer.normalize(input, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").replace(" ", replacement).replace("[", replacement).replace("]", replacement).replace("*", replacement).replace("?", replacement).replace(":", replacement).replace("/", replacement).replace("\\", replacement);
        while (result.contains(replacement + replacement)) {
            result = result.replace(replacement + replacement, replacement);
        }
        return result.trim();
    }

    protected void processReport(Function<CompetenceCourseMarkSheetStateChangeReportParametersBean, byte[]> function, CompetenceCourseMarkSheetStateChangeReportParametersBean competenceCourseMarkSheetStateChangeReportParametersBean, String string) {
        Object object = advice$processReport.perform((Callable)new CompetenceCourseMarkSheetStateChangeReportController$callable$processReport(this, function, competenceCourseMarkSheetStateChangeReportParametersBean, string));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    protected static /* synthetic */ void advised$processReport(CompetenceCourseMarkSheetStateChangeReportController this_, Function reportProcessor, CompetenceCourseMarkSheetStateChangeReportParametersBean bean, String reportId) {
        byte[] content = null;
        try {
            content = (byte[])reportProcessor.apply(bean);
        }
        catch (Throwable e) {
            content = this_.createXLSWithError(e instanceof ULisboaReportsDomainException ? ((ULisboaReportsDomainException)((Object)e)).getLocalizedMessage() : ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        ULisboaSpecificationsTemporaryFile.create((String)reportId, (byte[])content, (User)Authenticate.getUser());
    }

    private byte[] createXLSWithError(String error) {
        try {
            SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
            builder.addSheet(ULisboaReportsUtil.bundle("competenceCourseMarkSheetStateChange.competenceCourseMarkSheetStateChange", new String[0]), (SheetData)new SheetData<String>(Collections.singleton(error)){

                protected void makeLine(String item) {
                    this.addCell(ULisboaReportsUtil.bundle("unexpected.error.occured", new String[0]), item);
                }
            });
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            builder.build((OutputStream)result);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @RequestMapping(value={"/exportstatus/{reportId}"}, method={RequestMethod.GET}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> exportStatus(@PathVariable(value="reportId") String reportId, Model model) {
        return new ResponseEntity((Object)String.valueOf(ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId).isPresent()), HttpStatus.OK);
    }

    @RequestMapping(value={"/downloadreport/{reportId}"}, method={RequestMethod.GET})
    public void downloadReport(@PathVariable(value="reportId") String reportId, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) throws IOException {
        Optional temporaryFile = ULisboaSpecificationsTemporaryFile.findByUserAndFilename((User)Authenticate.getUser(), (String)reportId);
        this.writeFile(response, CompetenceCourseMarkSheetStateChangeReportController.getFilename(reportId) + "_" + new DateTime().toString("yyyy-MM-dd_HH-mm-ss") + ".xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", ((ULisboaSpecificationsTemporaryFile)temporaryFile.get()).getContent());
    }

    private static String getFilename(String reportId) {
        return reportId.substring(0, reportId.indexOf("_UUID_"));
    }

    private byte[] exportToXLS(CompetenceCourseMarkSheetStateChangeReportParametersBean bean) {
        Collection<CompetenceCourseMarkSheetStateChangeReport> toExport = CompetenceCourseMarkSheetStateChangeReportController.generateReport(bean);
        SpreadsheetBuilderForXLSX builder = new SpreadsheetBuilderForXLSX();
        toExport.forEach(r -> builder.addSheet(CompetenceCourseMarkSheetStateChangeReportController.normalizeName(r.getEvaluationSeasonCode().concat(" ").concat(r.getCreationDateShort()), "_"), (SheetData)new SheetData<CompetenceCourseMarkSheetSnapshotEntry>((Iterable)r.getCompetenceCourseMarkSheetLastSnapshot().getSortedEntries()){

            protected void makeLine(CompetenceCourseMarkSheetSnapshotEntry report) {
                this.addCompetenceCourseMarkSheetSnapshotEntryData(report);
            }

            private void addCompetenceCourseMarkSheetSnapshotEntryData(CompetenceCourseMarkSheetSnapshotEntry report) {
                this.addData("competenceCourseMarkSheetStateChange.courseCode", r.getCompetenceCourseCode());
                this.addData("competenceCourseMarkSheetStateChange.courseName", r.getCompetenceCourseName());
                this.addData("competenceCourseMarkSheetStateChange.evaluationSeason", r.getEvaluationSeason());
                this.addData("competenceCourseMarkSheetStateChange.executionSemester", r.getExecutionSemester());
                this.addData("competenceCourseMarkSheetStateChange.studentNumber", report.getStudentNumber());
                this.addData("competenceCourseMarkSheetStateChange.studentName", report.getStudentName());
                this.addData("competenceCourseMarkSheetStateChange.studentGrade", report.getGrade() == null ? "NA" : report.getGrade().getValue());
                this.addData("competenceCourseMarkSheetStateChange.studentGradeChanged", r.hasGradeChanged(report));
                this.addData("competenceCourseMarkSheetStateChange.gradeAvailableDate", r.gradeAvailableDate(report));
            }

            private void addData(String key, Object value) {
                this.addCell(CompetenceCourseMarkSheetStateChangeReportController.bundle(key), value == null ? "" : value);
            }
        }));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            builder.build((OutputStream)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toByteArray();
    }

    @RequestMapping(value={"/postback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> postback(@RequestParam(value="bean", required=false) CompetenceCourseMarkSheetStateChangeReportParametersBean bean, Model model) {
        bean.updateData();
        bean.update();
        return new ResponseEntity((Object)this.getBeanJson(bean), HttpStatus.OK);
    }

    static {
        advice$processReport = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        JSP_PATH = CONTROLLER_URL.substring(1);
    }
}

