/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.scholarshiptypology;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.RegistrationDataServices;
import org.fenixedu.ulisboa.reports.services.report.scholarshiptypology.ScholarshipTypologyReport;

public class ScholarshipTypologyReportService {
    private ExecutionYear enrolmentExecutionYear;

    public void filterEnrolmentExecutionYear(ExecutionYear executionYear) {
        this.enrolmentExecutionYear = executionYear;
    }

    public Collection<ScholarshipTypologyReport> generateReport() {
        return this.process(this.enrolmentExecutionYear);
    }

    private Predicate<ScholarshipTypologyReport> filterPredicate() {
        Predicate<ScholarshipTypologyReport> result = r -> true;
        Predicate<ScholarshipTypologyReport> hasPersonalIngressionDataFilter = r -> r.getPersonalIngressionData() != null;
        result = result.and(hasPersonalIngressionDataFilter);
        return result;
    }

    private Collection<ScholarshipTypologyReport> process(ExecutionYear executionYear) {
        if (executionYear == null) {
            return Sets.newHashSet();
        }
        Predicate<ScholarshipTypologyReport> filterPredicate = this.filterPredicate();
        return this.buildSearchUniverse(executionYear).stream().map(r -> this.buildReport((Registration)r, executionYear)).filter(filterPredicate).collect(Collectors.toSet());
    }

    private Set<Registration> buildSearchUniverse(ExecutionYear executionYear) {
        HashSet result = Sets.newHashSet();
        result.addAll(executionYear.getStudentsSet());
        result.addAll(executionYear.getExecutionPeriodsSet().stream().flatMap(semester -> semester.getEnrolmentsSet().stream().map(enrolment -> enrolment.getRegistration()).filter(registration -> RegistrationDataServices.getRegistrationData((Registration)registration, (ExecutionYear)executionYear) != null)).collect(Collectors.toSet()));
        return result;
    }

    private ScholarshipTypologyReport buildReport(Registration registration, ExecutionYear executionYear) {
        ScholarshipTypologyReport result = new ScholarshipTypologyReport(registration, executionYear);
        return result;
    }
}

