/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.professorship;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipReport;

public class ProfessorshipReportService {
    private ExecutionYear executionYear;

    public void filterEnrolmentExecutionYear(ExecutionYear executionYear) {
        this.executionYear = executionYear;
    }

    public Collection<ProfessorshipReport> generateReport() {
        return this.process(this.executionYear);
    }

    private Collection<ProfessorshipReport> process(ExecutionYear executionYear) {
        return this.buildSearchUniverse().stream().map(r -> this.buildReport((ShiftProfessorship)r)).collect(Collectors.toSet());
    }

    private Set<ShiftProfessorship> buildSearchUniverse() {
        if (this.executionYear == null) {
            return Sets.newHashSet();
        }
        return this.executionYear.getExecutionPeriodsSet().stream().flatMap(ep -> ep.getAssociatedExecutionCoursesSet().stream()).flatMap(ec -> ec.getAssociatedShifts().stream()).flatMap(s -> s.getAssociatedShiftProfessorshipSet().stream()).collect(Collectors.toSet());
    }

    private ProfessorshipReport buildReport(ShiftProfessorship shiftProfessorship) {
        return new ProfessorshipReport(shiftProfessorship);
    }
}

