/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.professorship;

import java.text.Collator;
import java.util.Comparator;
import java.util.Optional;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftEnrolment;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.academic.domain.schedule.shiftCapacity.ShiftCapacity;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;

public class ProfessorshipReport
implements Comparable<ProfessorshipReport> {
    private final ShiftProfessorship shiftProfessorship;

    public ProfessorshipReport(ShiftProfessorship shiftProfessorship) {
        this.shiftProfessorship = shiftProfessorship;
    }

    @Override
    public int compareTo(ProfessorshipReport o) {
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byTeacher = (x, y) -> instance.compare(x.getTeacherName(), y.getTeacherName());
        Comparator bySemesterAndYear = (x, y) -> ExecutionInterval.COMPARATOR_BY_BEGIN_DATE.compare(x.getExecutionPeriod(), y.getExecutionPeriod());
        Comparator byCourseName = (x, y) -> instance.compare(x.getExecutionCourseName(), y.getExecutionCourseName());
        return byTeacher.thenComparing(bySemesterAndYear).thenComparing(byCourseName).compare(this, o);
    }

    public String getTeacherName() {
        Person person = this.getTeacherPerson();
        return person == null ? null : person.getName();
    }

    public String getCompetenceCourseCode() {
        return this.getCompetenceCourse().getCode();
    }

    private CompetenceCourse getCompetenceCourse() {
        return (CompetenceCourse)this.getExecutionCourse().getCompetenceCourses().iterator().next();
    }

    protected ExecutionCourse getExecutionCourse() {
        Shift shift = this.getShift();
        return shift == null ? null : shift.getExecutionCourse();
    }

    protected Shift getShift() {
        return this.shiftProfessorship.getShift();
    }

    public String getCompetenceCourseRegime() {
        return this.getCompetenceCourse().getRegime().getLocalizedName();
    }

    public String getCompetenceCourseDepartment() {
        return this.getCompetenceCourse().getDepartmentUnit().getName();
    }

    public String getTeacherUsername() {
        Person person = this.getTeacherPerson();
        return person == null ? null : person.getUsername();
    }

    protected Person getTeacherPerson() {
        Professorship professorship = this.getProfessorship();
        return professorship == null ? null : professorship.getPerson();
    }

    protected Professorship getProfessorship() {
        return this.shiftProfessorship.getProfessorship();
    }

    public String getTeacherDepartment() {
        return Optional.ofNullable(this.getProfessorship()).map(o -> o.getTeacher()).flatMap(o -> o.getTeacherAuthorization(this.getExecutionPeriod().getAcademicInterval())).map(o -> o.getDepartment()).map(o -> o.getNameI18n().getContent()).orElse("");
    }

    public ExecutionInterval getExecutionPeriod() {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        return executionCourse == null ? null : executionCourse.getExecutionPeriod();
    }

    public String getIsResponsible() {
        return this.getProfessorship().isResponsibleFor() ? ULisboaReportsUtil.bundle("yes", new String[0]) : ULisboaReportsUtil.bundle("no", new String[0]);
    }

    public String getExecutionYearName() {
        ExecutionYear executionYear = this.getExecutionYear();
        return executionYear == null ? null : executionYear.getQualifiedName();
    }

    public ExecutionYear getExecutionYear() {
        ExecutionCourse executionCourse = this.getExecutionCourse();
        return executionCourse == null ? null : executionCourse.getExecutionYear();
    }

    public String getExecutionSemesterName() {
        ExecutionInterval executionInterval = this.getExecutionPeriod();
        return executionInterval == null ? null : executionInterval.getName();
    }

    public String getExecutionCourseName() {
        return this.getExecutionCourse().getNameI18N().getContent();
    }

    public String getClassesName() {
        Shift shift = this.getShift();
        return shift == null ? null : shift.getClassesPrettyPrint();
    }

    public String getShiftName() {
        Shift shift = this.getShift();
        return shift == null ? null : shift.getNome();
    }

    public String getShiftTypeName() {
        Shift shift = this.getShift();
        return shift == null ? null : shift.getShiftTypesPrettyPrint();
    }

    public String getShiftOccupation() {
        return Integer.toString(ShiftEnrolment.getTotalEnrolments((Shift)this.getShift()));
    }

    public String getShiftCapacity() {
        return Integer.toString(ShiftCapacity.getTotalCapacity((Shift)this.getShift()));
    }

    public String getTotalHours() {
        return this.getShift().getCourseLoadTotalHours() == null ? null : this.minutesToHours(this.getShift().getCourseLoadTotalHours().longValue() * 60L);
    }

    private long getTotalMinutes() {
        return this.getShift().getCourseLoadTotalHours() == null ? null : Long.valueOf(this.getShift().getCourseLoadTotalHours().longValue() * 60L);
    }

    private String minutesToHours(long min) {
        int t = (int)min;
        int hours = t / 60;
        int minutes = t % 60;
        return String.format("%d:%02d", hours, minutes);
    }

    public String getTeacherHours() {
        return this.getAllocationPercentage() == null ? null : this.minutesToHours((long)(this.getAllocationPercentage() / 100.0 * (double)this.getTotalMinutes()));
    }

    public Double getAllocationPercentage() {
        return this.getShiftProfessorship().getPercentage();
    }

    public ShiftProfessorship getShiftProfessorship() {
        return this.shiftProfessorship;
    }
}

