/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.professorship;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.ShiftProfessorship;
import org.fenixedu.ulisboa.reports.services.report.professorship.ProfessorshipDegreeReport;

public class ProfessorshipDegreeReportService {
    final Collection<ShiftProfessorship> shiftProfessorships;

    public ProfessorshipDegreeReportService(Collection<ShiftProfessorship> shiftProfessorships) {
        this.shiftProfessorships = shiftProfessorships;
    }

    public Collection<ProfessorshipDegreeReport> generateReport() {
        return this.process();
    }

    private Collection<ProfessorshipDegreeReport> process() {
        HashSet result = Sets.newHashSet();
        this.shiftProfessorships.stream().forEach(sp -> sp.getShift().getExecutionCourse().getExecutionDegrees().stream().forEach(ed -> result.add(this.buildReport((ShiftProfessorship)sp, ed.getDegree()))));
        return result;
    }

    private ProfessorshipDegreeReport buildReport(ShiftProfessorship shiftProfessorship, Degree degree) {
        return new ProfessorshipDegreeReport(shiftProfessorship, degree);
    }
}

