/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.course;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.ulisboa.reports.services.report.course.CurricularCourseContextReport;

public class CurricularCourseContextReportService {
    private final Collection<CompetenceCourse> competenceCourses;
    private final ExecutionYear executionYear;

    public CurricularCourseContextReportService(Collection<CompetenceCourse> competenceCourses, ExecutionYear executionYear) {
        this.competenceCourses = competenceCourses;
        this.executionYear = executionYear;
    }

    public Collection<CurricularCourseContextReport> generateReport() {
        return this.process();
    }

    private Collection<CurricularCourseContextReport> process() {
        HashSet result = Sets.newHashSet();
        this.competenceCourses.stream().map(cc -> cc.getAssociatedCurricularCoursesSet()).flatMap(Collection::stream).forEach(course -> course.getParentContextsSet().stream().filter(context -> context.isOpen(this.executionYear)).forEach(context -> result.add(this.buildReport((CurricularCourse)course, (Context)context))));
        return result;
    }

    private CurricularCourseContextReport buildReport(CurricularCourse curricularCourse, Context context) {
        return new CurricularCourseContextReport(curricularCourse, context);
    }
}

