/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.course;

import java.text.Collator;
import java.util.Comparator;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public class CompetenceCourseReport
implements Comparable<CompetenceCourseReport> {
    private final CompetenceCourse competenceCourse;

    public CompetenceCourseReport(CompetenceCourse competenceCourse) {
        this.competenceCourse = competenceCourse;
    }

    @Override
    public int compareTo(CompetenceCourseReport o) {
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byCourseName = (x, y) -> instance.compare(x.getName(), y.getName());
        Comparator byCode = (x, y) -> instance.compare(x.getCode(), y.getCode());
        return byCourseName.thenComparing(byCode).compare(this, o);
    }

    public String getCode() {
        return this.competenceCourse.getCode();
    }

    public String getName() {
        return this.competenceCourse.getNameI18N().getContent();
    }

    public String getNameEn() {
        return this.competenceCourse.getNameEn();
    }

    public String getBeginExecutionPeriod() {
        return this.competenceCourse.getBeginExecutionInterval().getQualifiedName();
    }

    public String getDepartment() {
        return this.competenceCourse.getDepartmentUnit().getNameI18n().getContent();
    }

    public String getScientificArea() {
        return this.competenceCourse.getCompetenceCourseGroupUnit().getParentUnits().stream().filter(u -> u.isScientificAreaUnit()).map(u -> u.getName()).collect(Collectors.joining(", "));
    }

    public String getAcronym() {
        return this.competenceCourse.getAcronym();
    }

    public String getType() {
        return BundleUtil.getLocalizedString((String)"resources.EnumerationResources", (String)this.competenceCourse.getType().name(), (String[])new String[0]).getContent();
    }

    public String getRegime() {
        return this.competenceCourse.getRegime().getLocalizedName();
    }

    public Double getTotalHours() {
        return this.getTheoreticalHours() + this.getProblemsHours() + this.getFieldWorkHours() + this.getLaboratorialHours() + this.getOtherHours() + this.getSeminaryHours() + this.getTrainingPeriodHours() + this.getTutorialOrientationHours() + this.getAutonomousWorkHours();
    }

    public Double getTheoreticalHours() {
        return this.competenceCourse.getTheoreticalHours();
    }

    public Double getProblemsHours() {
        return this.competenceCourse.getProblemsHours();
    }

    public Double getLaboratorialHours() {
        return this.competenceCourse.getLaboratorialHours();
    }

    public Double getSeminaryHours() {
        return this.competenceCourse.getSeminaryHours();
    }

    public Double getFieldWorkHours() {
        return this.competenceCourse.getFieldWorkHours();
    }

    public Double getTrainingPeriodHours() {
        return this.competenceCourse.getTrainingPeriodHours();
    }

    public Double getTutorialOrientationHours() {
        return this.competenceCourse.getTutorialOrientationHours();
    }

    public Double getOtherHours() {
        return this.competenceCourse.getOtherHours();
    }

    public Double getAutonomousWorkHours() {
        return this.competenceCourse.getAutonomousWorkHours();
    }

    public Double getECTS() {
        return this.competenceCourse.getEctsCredits();
    }
}

