/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheetstatechange;

import edu.emory.mathcs.backport.java.util.Collections;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshot;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetSnapshotEntry;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.academic.dto.evaluation.markSheet.MarkBean;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.dto.evaluation.markSheet.CompetenceCourseMarkSheetBean;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import pt.ist.fenixframework.dml.runtime.DirectRelation;

public class CompetenceCourseMarkSheetStateChangeReport
implements Comparable<CompetenceCourseMarkSheetStateChangeReport> {
    private final CompetenceCourseMarkSheet competenceCourseMarkSheet;
    private final List<MarkBean> gradeDifferences;
    private final List<MarkBean> gradeAvailableDates;
    private final CompetenceCourseMarkSheetBean competenceCourseMarkSheetBean;
    private EvaluationSeason evaluationSeason;
    private Evaluation evaluation;

    public CompetenceCourseMarkSheetStateChangeReport(CompetenceCourseMarkSheet competenceCourseMarkSheet) {
        this.competenceCourseMarkSheet = competenceCourseMarkSheet;
        this.gradeDifferences = this.getCompetenceCourseMarkSheetPreviousSnapshot() == null ? Collections.emptyList() : this.getCompetenceCourseMarkSheetPreviousSnapshot().getDifferencesToNextGradeValues();
        this.competenceCourseMarkSheetBean = new CompetenceCourseMarkSheetBean(this.competenceCourseMarkSheet);
        this.gradeAvailableDates = this.competenceCourseMarkSheetBean.getUpdateGradeAvailableDateBeans();
    }

    @Override
    public int compareTo(CompetenceCourseMarkSheetStateChangeReport o) {
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byCourseName = (x, y) -> instance.compare(x.getCompetenceCourseName(), y.getCompetenceCourseName());
        Comparator byCode = (x, y) -> instance.compare(x.getCompetenceCourseCode(), y.getCompetenceCourseCode());
        Comparator<CompetenceCourseMarkSheetStateChangeReport> byCreationDate = Comparator.comparing(x -> x.getCompetenceCourseMarkSheet().getCreationDate());
        Comparator byCheckSum = (x, y) -> instance.compare(x.getCheckSum(), y.getCheckSum());
        return byCourseName.thenComparing(byCode).thenComparing(byCreationDate).thenComparing(byCheckSum).compare(this, o);
    }

    public static DirectRelation<EvaluationSeason, CompetenceCourseMarkSheet> getRelationCompetenceCourseMarkSheetEvaluationSeason() {
        return EvaluationSeason.getRelationCompetenceCourseMarkSheetEvaluationSeason();
    }

    public String getCompetenceCourseCode() {
        return this.competenceCourseMarkSheet.getCompetenceCourse().getCode();
    }

    public String getCompetenceCourseName() {
        return this.getCompetenceCourseMarkSheet().getCompetenceCourse().getNameI18N().getContent();
    }

    public String getExecutionPresentation() {
        return CompetenceCourseMarkSheetBean.getExecutionCoursePresentation((ExecutionCourse)this.competenceCourseMarkSheet.getExecutionCourse());
    }

    public String getEvaluationSeasonCode() {
        return this.competenceCourseMarkSheet.getEvaluationSeason().getAcronym().getContent();
    }

    public String getEvaluationSeason() {
        return EvaluationSeasonServices.getDescriptionI18N((EvaluationSeason)this.competenceCourseMarkSheet.getEvaluationSeason()).getContent();
    }

    public String getCreationDateShort() {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd").print((ReadableInstant)this.competenceCourseMarkSheet.getCreationDate());
    }

    public String getCreationDate() {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").print((ReadableInstant)this.competenceCourseMarkSheet.getCreationDate());
    }

    public String getExecutionSemester() {
        return this.competenceCourseMarkSheet.getExecutionSemester().getQualifiedName();
    }

    public String getCheckSum() {
        return this.competenceCourseMarkSheet.getFormattedCheckSum();
    }

    public String getEvaluationDate() {
        return this.competenceCourseMarkSheet.getEvaluationDatePresentation();
    }

    public String getLastSubmissionDate() {
        CompetenceCourseMarkSheetStateChange lastSubmissionStateChange = this.competenceCourseMarkSheet.getStateChangeSet().stream().filter(sc -> sc.isSubmitted()).sorted(Comparator.reverseOrder()).findFirst().orElse(null);
        return lastSubmissionStateChange == null ? this.bundle("CompetenceCourseMarkSheetReport.submissionDate.notfound") : DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").print((ReadableInstant)lastSubmissionStateChange.getDate());
    }

    public String getCertifier() {
        return CompetenceCourseMarkSheetBean.getPersonDescription((Person)this.competenceCourseMarkSheet.getCertifier());
    }

    public String getLastState() {
        return this.competenceCourseMarkSheet.getStateChangeSet().stream().sorted(Comparator.reverseOrder()).map(sc -> sc.getState().getDescriptionI18N().getContent()).findFirst().orElse(null);
    }

    public String getPrintStatus() {
        return this.competenceCourseMarkSheet.getPrinted() ? this.bundle("yes") : this.bundle("no");
    }

    public String getLastPendingChange() {
        return this.competenceCourseMarkSheet.getLastPendingChangeRequest() != null ? this.bundle("yes") : this.bundle("no");
    }

    private CompetenceCourseMarkSheet getCompetenceCourseMarkSheet() {
        return this.competenceCourseMarkSheet;
    }

    public CompetenceCourseMarkSheetSnapshot getCompetenceCourseMarkSheetLastSnapshot() {
        return (CompetenceCourseMarkSheetSnapshot)this.competenceCourseMarkSheet.getLastSnapshot().get();
    }

    public CompetenceCourseMarkSheetSnapshot getCompetenceCourseMarkSheetPreviousSnapshot() {
        Comparator comp = (ss1, ss2) -> ss1.getStateChange().compareTo(ss2.getStateChange());
        return this.competenceCourseMarkSheet.getPreviousSnapshots().stream().sorted(comp.reversed()).findFirst().orElse(null);
    }

    public Collection<CompetenceCourseMarkSheetSnapshotEntry> getEntries(CompetenceCourseMarkSheetSnapshot competenceCourseMarkSheetSnapshot) {
        return competenceCourseMarkSheetSnapshot.getSortedEntries();
    }

    public String hasGradeChanged(CompetenceCourseMarkSheetSnapshotEntry competenceCourseMarkSheetSnapshotEntry) {
        return this.gradeDifferences.stream().filter(gd -> gd.getStudentNumber().equals(competenceCourseMarkSheetSnapshotEntry.getStudentNumber())).findFirst().isPresent() ? this.bundle("yes") : " ";
    }

    public LocalDate gradeAvailableDate(CompetenceCourseMarkSheetSnapshotEntry competenceCourseMarkSheetSnapshotEntry) {
        return this.gradeAvailableDates.stream().filter(gad -> gad.getStudentNumber().equals(competenceCourseMarkSheetSnapshotEntry.getStudentNumber())).findFirst().map(gad -> gad.getGradeAvailableDate()).orElse(null);
    }

    private String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }
}

