/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.services.report.competencecoursemarksheet;

import java.text.Collator;
import java.util.Comparator;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheet;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateChange;
import org.fenixedu.academic.domain.evaluation.markSheet.CompetenceCourseMarkSheetStateEnum;
import org.fenixedu.academic.domain.evaluation.season.EvaluationSeasonServices;
import org.fenixedu.ulisboa.reports.util.ULisboaReportsUtil;
import org.fenixedu.ulisboa.specifications.dto.evaluation.markSheet.CompetenceCourseMarkSheetBean;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public class CompetenceCourseMarkSheetReport
implements Comparable<CompetenceCourseMarkSheetReport> {
    private final CompetenceCourseMarkSheet competenceCourseMarkSheet;

    public CompetenceCourseMarkSheetReport(CompetenceCourseMarkSheet competenceCourseMarkSheet) {
        this.competenceCourseMarkSheet = competenceCourseMarkSheet;
    }

    @Override
    public int compareTo(CompetenceCourseMarkSheetReport o) {
        Collator instance = Collator.getInstance();
        instance.setStrength(0);
        Comparator byCourseName = (x, y) -> instance.compare(x.getCompetenceCourseName(), y.getCompetenceCourseName());
        Comparator byCode = (x, y) -> instance.compare(x.getCompetenceCourseCode(), y.getCompetenceCourseCode());
        Comparator<CompetenceCourseMarkSheetReport> byCreationDate = Comparator.comparing(x -> x.getCompetenceCourseMarkSheet().getCreationDate());
        Comparator byCheckSum = (x, y) -> {
            if (!x.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent()) && y.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent())) {
                return 1;
            }
            if (x.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent()) && y.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent())) {
                return 0;
            }
            if (x.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent()) && !y.getLastState().equals(CompetenceCourseMarkSheetStateEnum.EDITION.getDescriptionI18N().getContent())) {
                return -1;
            }
            return instance.compare(x.getCheckSum(), y.getCheckSum());
        };
        return byCourseName.thenComparing(byCode).thenComparing(byCreationDate).thenComparing(byCheckSum).compare(this, o);
    }

    public String getCompetenceCourseCode() {
        return this.competenceCourseMarkSheet.getCompetenceCourse().getCode();
    }

    public String getCompetenceCourseName() {
        return this.getCompetenceCourseMarkSheet().getCompetenceCourse().getNameI18N().getContent();
    }

    public String getExecutionPresentation() {
        return CompetenceCourseMarkSheetBean.getExecutionCoursePresentation((ExecutionCourse)this.competenceCourseMarkSheet.getExecutionCourse());
    }

    public String getEvaluationSeason() {
        return EvaluationSeasonServices.getDescriptionI18N((EvaluationSeason)this.competenceCourseMarkSheet.getEvaluationSeason()).getContent();
    }

    public String getCreationDate() {
        return DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").print((ReadableInstant)this.competenceCourseMarkSheet.getCreationDate());
    }

    public String getExecutionSemester() {
        return this.competenceCourseMarkSheet.getExecutionSemester().getQualifiedName();
    }

    public String getCheckSum() {
        return this.competenceCourseMarkSheet.getFormattedCheckSum();
    }

    public String getEvaluationDate() {
        return this.competenceCourseMarkSheet.getEvaluationDatePresentation();
    }

    public String getLastSubmissionDate() {
        CompetenceCourseMarkSheetStateChange lastSubmissionStateChange = this.competenceCourseMarkSheet.getStateChangeSet().stream().filter(sc -> sc.isSubmitted()).sorted(Comparator.reverseOrder()).findFirst().orElse(null);
        return lastSubmissionStateChange == null ? this.bundle("CompetenceCourseMarkSheetReport.submissionDate.notfound") : DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").print((ReadableInstant)lastSubmissionStateChange.getDate());
    }

    public String getCertifier() {
        return CompetenceCourseMarkSheetBean.getPersonDescription((Person)this.competenceCourseMarkSheet.getCertifier());
    }

    public String getLastState() {
        return this.competenceCourseMarkSheet.getStateChangeSet().stream().sorted(Comparator.reverseOrder()).map(sc -> sc.getState().getDescriptionI18N().getContent()).findFirst().orElse(null);
    }

    public String getPrintStatus() {
        return this.competenceCourseMarkSheet.getPrinted() ? this.bundle("yes") : this.bundle("no");
    }

    public String getLastPendingChange() {
        return this.competenceCourseMarkSheet.getLastPendingChangeRequest() != null ? this.bundle("yes") : this.bundle("no");
    }

    private CompetenceCourseMarkSheet getCompetenceCourseMarkSheet() {
        return this.competenceCourseMarkSheet;
    }

    private String bundle(String key) {
        return ULisboaReportsUtil.bundle(key, new String[0]);
    }
}

