/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.reports.dto.report.competencecoursemarksheetstatechange;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;

public class CompetenceCourseMarkSheetStateChangeReportParametersBean
implements IBean {
    private ExecutionInterval executionSemester;
    private List<TupleDataSourceBean> executionSemesterDataSource;
    private CompetenceCourse competenceCourse;
    private List<TupleDataSourceBean> competenceCourseDataSource;
    private ExecutionCourse executionCourse;
    private List<TupleDataSourceBean> executionCourseDataSource;

    public CompetenceCourseMarkSheetStateChangeReportParametersBean() {
        this.update();
    }

    public List<TupleDataSourceBean> getExecutionSemestersDataSource() {
        return this.executionSemesterDataSource;
    }

    public void updateData() {
        this.executionSemesterDataSource = ExecutionInterval.findActiveChilds().stream().sorted(ExecutionInterval.COMPARATOR_BY_BEGIN_DATE.reversed()).map(x -> new TupleDataSourceBean(x.getExternalId(), x.getQualifiedName())).collect(Collectors.toList());
    }

    public void update() {
        this.setExecutionSemesterDataSource(ExecutionInterval.findActiveChilds());
        this.updateCompetenceCourseDataSource();
    }

    public void setExecutionSemesterDataSource(Collection<ExecutionInterval> value) {
        this.executionSemesterDataSource = value.stream().sorted(ExecutionInterval.COMPARATOR_BY_BEGIN_DATE.reversed()).map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getQualifiedName());
            return tuple;
        }).collect(Collectors.toList());
    }

    private void updateCompetenceCourseDataSource() {
        Set<Object> value = this.getExecutionCourse() != null ? this.getExecutionCourse().getAssociatedCurricularCoursesSet().stream().map(e -> e.getCompetenceCourse()).collect(Collectors.toSet()) : (this.getExecutionSemester() != null ? this.getExecutionSemester().getAssociatedExecutionCoursesSet().stream().flatMap(e -> e.getCompetenceCourses().stream()).collect(Collectors.toSet()) : Sets.newHashSet());
        this.competenceCourseDataSource = value.stream().sorted(CompetenceCourse.COMPETENCE_COURSE_COMPARATOR_BY_NAME).map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getCode() + " - " + x.getName().replace("'", " ").replace("\"", " "));
            return tuple;
        }).collect(Collectors.toList());
    }

    public ExecutionCourse getExecutionCourse() {
        return this.executionCourse;
    }

    public CompetenceCourse getCompetenceCourse() {
        return this.competenceCourse;
    }

    public ExecutionInterval getExecutionSemester() {
        return this.executionSemester;
    }

    public List<TupleDataSourceBean> getExecutionSemesterDataSource() {
        return this.executionSemesterDataSource;
    }

    public List<TupleDataSourceBean> getCompetenceCourseDataSource() {
        return this.competenceCourseDataSource;
    }

    public void setExecutionSemester(ExecutionInterval executionInterval) {
        this.executionSemester = executionInterval;
    }

    public void setCompetenceCourse(CompetenceCourse competenceCourse) {
        this.competenceCourse = competenceCourse;
    }
}

