/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.ui.teacher.calendar;

import java.util.Collection;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.applications.dto.teacher.shift.calendar.TeacherLessonCalendarParametersBean;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarReport;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarService;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsBaseController;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsController;
import org.fenixedu.ulisboa.applications.util.TeacherLessonCalendarUtil;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=FenixeduULisboaApplicationsController.class, title="label.org.fenixedu.ulisboa.applications.teacher.teacherLessonCalendar", accessGroup="logged")
@RequestMapping(value={"/fenixedu-ulisboa-applications/teacher/teacherlessoncalendar"})
public class TeacherLessonCalendarController
extends FenixeduULisboaApplicationsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-applications/teacher/teacherlessoncalendar";
    private static final String JSP_PATH = "/fenixedu-ulisboa-applications/teacher/teacherlessoncalendar".substring(1);
    private static final TeacherLessonCalendarParametersBean.ExecutionSemesterProviderType EXECUTION_SEMESTER_PROVIDER_TYPE = TeacherLessonCalendarParametersBean.ExecutionSemesterProviderType.CURRENT_EXECUTION_YEAR;
    private static final TeacherLessonCalendarParametersBean.TeacherProviderType TEACHER_PROVIDER_TYPE = TeacherLessonCalendarParametersBean.TeacherProviderType.CURRENT_AUTHENTICATED_TEACHER;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        ExecutionInterval executionInterval = ExecutionInterval.findFirstCurrentChild(null);
        TeacherLessonCalendarParametersBean bean = new TeacherLessonCalendarParametersBean(EXECUTION_SEMESTER_PROVIDER_TYPE, TEACHER_PROVIDER_TYPE);
        bean.setExecutionSemester(executionInterval);
        return this.home(model, redirectAttributes, bean);
    }

    @RequestMapping(method={RequestMethod.POST})
    public String home(Model model, RedirectAttributes redirectAttributes, @RequestParam(value="bean") TeacherLessonCalendarParametersBean bean) {
        bean.setTeacher(Authenticate.getUser().getPerson().getTeacher());
        bean.updateData(EXECUTION_SEMESTER_PROVIDER_TYPE, TEACHER_PROVIDER_TYPE);
        this.setParametersBean(bean, model);
        this.setJsonEvents(TeacherLessonCalendarUtil.getJsonLessonEvents(this.getTeacherLessonEvents(bean)), model);
        model.addAttribute("showTeacherSelector", (Object)false);
        model.addAttribute("controllerUrl", (Object)CONTROLLER_URL);
        return this.jspPage("teacherlessoncalendar");
    }

    private void setParametersBean(TeacherLessonCalendarParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private String jspPage(String page) {
        return JSP_PATH + "/" + page;
    }

    private void setJsonEvents(String events, Model model) {
        model.addAttribute("events", (Object)events);
    }

    private Collection<TeacherLessonCalendarReport> getTeacherLessonEvents(TeacherLessonCalendarParametersBean bean) {
        ExecutionInterval currentExecutionSemester = bean.getExecutionSemester();
        Teacher currentTeacher = bean.getTeacher();
        TeacherLessonCalendarService service = new TeacherLessonCalendarService(currentExecutionSemester, currentTeacher);
        return service.getLessonEvents();
    }
}

