/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.ui.management.teacher.calendar;

import java.util.Collection;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.applications.dto.teacher.shift.calendar.TeacherLessonCalendarParametersBean;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarReport;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarService;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsBaseController;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsController;
import org.fenixedu.ulisboa.applications.util.TeacherLessonCalendarUtil;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=FenixeduULisboaApplicationsController.class, title="label.org.fenixedu.ulisboa.applications.management.teacher.teacherLessonCalendar", accessGroup="#resourceAllocationManager")
@RequestMapping(value={"/fenixedu-ulisboa-applications/management/teacher/teacherlessoncalendar"})
public class ManagementTeacherLessonCalendarController
extends FenixeduULisboaApplicationsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-applications/management/teacher/teacherlessoncalendar";
    private static final String TEACHER_LESSON_CALENDAR_JSP_PATH = "/fenixedu-ulisboa-applications/teacher/teacherlessoncalendar".substring(1);
    private static final TeacherLessonCalendarParametersBean.ExecutionSemesterProviderType EXECUTION_SEMESTER_PROVIDER_TYPE = TeacherLessonCalendarParametersBean.ExecutionSemesterProviderType.INCLUDE_ALL;
    private static final TeacherLessonCalendarParametersBean.TeacherProviderType TEACHER_PROVIDER_TYPE = TeacherLessonCalendarParametersBean.TeacherProviderType.INCLUDE_ALL_WITH_AUTHORIZATION;

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        ExecutionInterval executionInterval = ExecutionInterval.findFirstCurrentChild(null);
        TeacherLessonCalendarParametersBean bean = new TeacherLessonCalendarParametersBean(EXECUTION_SEMESTER_PROVIDER_TYPE, TEACHER_PROVIDER_TYPE);
        bean.setExecutionSemester(executionInterval);
        return this.home(model, redirectAttributes, bean);
    }

    @RequestMapping(method={RequestMethod.POST})
    public String home(Model model, RedirectAttributes redirectAttributes, @RequestParam(value="bean") TeacherLessonCalendarParametersBean bean) {
        bean.updateData(EXECUTION_SEMESTER_PROVIDER_TYPE, TEACHER_PROVIDER_TYPE);
        this.setParametersBean(bean, model);
        this.setJsonEvents(TeacherLessonCalendarUtil.getJsonLessonEvents(this.getTeacherLessonEvents(bean)), model);
        model.addAttribute("showTeacherSelector", (Object)(bean.getExecutionSemester() != null ? 1 : 0));
        model.addAttribute("controllerUrl", (Object)CONTROLLER_URL);
        return this.teacherLessonCalendarJspPage("teacherlessoncalendar");
    }

    private void setParametersBean(TeacherLessonCalendarParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private String teacherLessonCalendarJspPage(String page) {
        return TEACHER_LESSON_CALENDAR_JSP_PATH + "/" + page;
    }

    private void setJsonEvents(String events, Model model) {
        model.addAttribute("events", (Object)events);
    }

    private Collection<TeacherLessonCalendarReport> getTeacherLessonEvents(TeacherLessonCalendarParametersBean bean) {
        ExecutionInterval currentExecutionSemester = bean.getExecutionSemester();
        Teacher currentTeacher = bean.getTeacher();
        TeacherLessonCalendarService service = new TeacherLessonCalendarService(currentExecutionSemester, currentTeacher);
        return service.getLessonEvents();
    }
}

