/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.ui;

import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.FenixEDUBaseController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;

public class FenixeduULisboaApplicationsBaseController
extends FenixEDUBaseController {
    @Autowired
    protected HttpServletRequest request;

    @ModelAttribute
    protected void addModelProperties(Model model) {
        String errorMessages;
        String warningMessages;
        super.addModelProperties(model, this.request);
        String infoMessages = this.request.getParameter("infoMessages");
        if (infoMessages != null) {
            this.addInfoMessage(infoMessages, model);
        }
        if ((warningMessages = this.request.getParameter("warningMessages")) != null) {
            this.addWarningMessage(warningMessages, model);
        }
        if ((errorMessages = this.request.getParameter("errorMessages")) != null) {
            this.addErrorMessage(errorMessages, model);
        }
    }

    protected void registerTypeAdapters(GsonBuilder builder) {
        super.registerTypeAdapters(builder);
    }

    protected void writeFile(HttpServletResponse response, String filename, String contentType, byte[] content) throws IOException {
        response.setContentLength(content.length);
        response.setContentType(contentType);
        response.addHeader("Content-Disposition", "attachment; filename=\"" + filename + "\"");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            outputStream.write(content);
            outputStream.flush();
            response.flushBuffer();
        }
    }

    protected static class SecToken {
        private static String SEED = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_-";
        private static int DEFAULT_KEY_SIZE = 16;

        protected SecToken() {
        }

        public static String generate(int keySize) {
            char[] key = new char[keySize];
            for (int i = 0; i < keySize; ++i) {
                key[i] = SEED.charAt(ThreadLocalRandom.current().nextInt(0, SEED.length() - 1));
            }
            return String.valueOf(key);
        }

        public static String generate() {
            return SecToken.generate(DEFAULT_KEY_SIZE);
        }
    }
}

