/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarReport;

public class TeacherLessonCalendarUtil {
    public static String getJsonLessonEvents(Collection<TeacherLessonCalendarReport> collection) {
        JsonArray result = new JsonArray();
        for (TeacherLessonCalendarReport lessonEventReport : collection) {
            JsonObject event = new JsonObject();
            event.addProperty("start", lessonEventReport.getEvent().getBegin().toString());
            event.addProperty("end", lessonEventReport.getEvent().getEnd().toString());
            Shift lessonShift = lessonEventReport.getLesson().getShift();
            JsonObject shiftJSON = new JsonObject();
            shiftJSON.addProperty("name", lessonShift.getNome());
            shiftJSON.addProperty("typeInitials", ((ShiftType)lessonShift.getTypes().iterator().next()).getSiglaTipoAula());
            shiftJSON.addProperty("type", ((ShiftType)lessonShift.getTypes().iterator().next()).getFullNameTipoAula());
            event.add("shift", (JsonElement)shiftJSON);
            ExecutionCourse lessonExecutionCourse = lessonEventReport.getLesson().getExecutionCourse();
            JsonObject executionCourseJSON = new JsonObject();
            executionCourseJSON.addProperty("id", lessonExecutionCourse.getExternalId());
            executionCourseJSON.addProperty("name", lessonExecutionCourse.getNameI18N().getContent());
            executionCourseJSON.addProperty("initials", lessonExecutionCourse.getSigla());
            executionCourseJSON.addProperty("code", lessonExecutionCourse.getCode());
            executionCourseJSON.addProperty("url", lessonExecutionCourse.getSiteUrl());
            event.add("executionCourse", (JsonElement)executionCourseJSON);
            Space space = lessonEventReport.getLesson().getSala();
            if (space != null) {
                JsonObject spaceJSON = new JsonObject();
                spaceJSON.addProperty("name", space.getName());
                spaceJSON.addProperty("presentationName", space.getPresentationName());
                event.add("space", (JsonElement)spaceJSON);
            }
            event.addProperty("title", lessonExecutionCourse.getSigla() + " (" + lessonExecutionCourse.getCode() + " - " + lessonShift.getNome() + " " + ((ShiftType)lessonShift.getTypes().iterator().next()).getSiglaTipoAula() + ")");
            result.add((JsonElement)event);
        }
        return result.toString();
    }
}

