/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.ui.management.cms.site.alternativesite;

import java.io.File;
import java.io.IOException;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.applications.dto.management.cms.site.alternativesite.ManagementAlternativeSitesParametersBean;
import org.fenixedu.ulisboa.applications.services.cms.site.alternativesite.AlternativeSitesImporter;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsBaseController;
import org.fenixedu.ulisboa.applications.ui.FenixeduULisboaApplicationsController;
import org.fenixedu.ulisboa.applications.util.ULisboaApplicationsUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=FenixeduULisboaApplicationsController.class, title="label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.title", accessGroup="#eLearningManagers")
@RequestMapping(value={"/fenixedu-ulisboa-applications/management/cms/site/alternativesite"})
public class ManagementAlternativeSiteController
extends FenixeduULisboaApplicationsBaseController {
    public static final String CONTROLLER_URL = "/fenixedu-ulisboa-applications/management/cms/site/alternativesite";
    private static final String JSP_PATH = "/fenixedu-ulisboa-applications/management/cms/site/alternativesite";
    @Autowired
    private AlternativeSitesImporter importer;
    private static final String _MANAGE_URI = "/manage";
    public static final String MANAGE_URL = "/fenixedu-ulisboa-applications/management/cms/site/alternativesite/manage";
    private static final String _UPLOAD_FILE_URI = "/upload";
    public static final String UPLOAD_FILE_URL = "/fenixedu-ulisboa-applications/management/cms/site/alternativesite/upload";

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        ExecutionSemester executionSemester = ExecutionSemester.readActualExecutionSemester();
        ManagementAlternativeSitesParametersBean bean = new ManagementAlternativeSitesParametersBean();
        bean.setExecutionSemester(executionSemester);
        return this.manage(model, redirectAttributes, bean);
    }

    @RequestMapping(value={"/manage"})
    public String manage(Model model, RedirectAttributes redirectAttributes, @RequestParam(value="bean") ManagementAlternativeSitesParametersBean bean) {
        this.setParametersBean(bean, model);
        return this.jspPage("manage");
    }

    @RequestMapping(value={"/upload"}, headers={"content-type=multipart/*"}, method={RequestMethod.POST})
    public String manage(@RequestParam(value="bean") ManagementAlternativeSitesParametersBean bean, @RequestParam(value="inputFile") MultipartFile file, Model model, RedirectAttributes redirectAttributes) {
        if (bean.getExecutionSemester() != null && file != null && !file.isEmpty()) {
            try {
                File temporaryFile = File.createTempFile(((Object)((Object)this)).getClass().getSimpleName(), "");
                temporaryFile.deleteOnExit();
                file.transferTo(temporaryFile);
                AlternativeSitesImporter.ProcessResult result = this.importer.processFile(temporaryFile, bean.getExecutionSemester());
                if (result.hasFailed()) {
                    this.addProcessFileErrorMessage(model);
                } else {
                    if (result.getErrorMessages().isEmpty()) {
                        this.addInfoMessage(ULisboaApplicationsUtil.bundle("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.fileProcessedWithoutErrors", new String[0]), model);
                    } else {
                        this.addInfoMessage(ULisboaApplicationsUtil.bundle("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.fileProcessedWithErrors", new String[0]), model);
                    }
                    for (String infoMessage : result.getInfoMessages()) {
                        this.addInfoMessage(infoMessage, model);
                    }
                    for (String errorMessage : result.getErrorMessages()) {
                        this.addErrorMessage(errorMessage, model);
                    }
                }
                temporaryFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.addProcessFileErrorMessage(model);
            }
        }
        return this.manage(model, redirectAttributes, bean);
    }

    private void setParametersBean(ManagementAlternativeSitesParametersBean bean, Model model) {
        model.addAttribute("beanJson", (Object)this.getBeanJson(bean));
        model.addAttribute("bean", (Object)bean);
    }

    private void addProcessFileErrorMessage(Model model) {
        this.addErrorMessage(ULisboaApplicationsUtil.bundle("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.failure", new String[0]), model);
    }

    private String jspPage(String page) {
        return "/fenixedu-ulisboa-applications/management/cms/site/alternativesite/" + page;
    }
}

