/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.services.teacher.calendar;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Lesson;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.util.icalendar.EventBean;
import org.fenixedu.ulisboa.applications.services.teacher.calendar.TeacherLessonCalendarReport;

public class TeacherLessonCalendarService {
    private final ExecutionSemester executionSemester;
    private final Teacher teacher;

    public TeacherLessonCalendarService(ExecutionSemester executionSemester, Teacher teacher) {
        this.teacher = teacher;
        this.executionSemester = executionSemester;
    }

    public Collection<TeacherLessonCalendarReport> getLessonEvents() {
        return this.buildSearchUniverse();
    }

    private Collection<TeacherLessonCalendarReport> buildSearchUniverse() {
        if (this.executionSemester == null || this.teacher == null) {
            return Sets.newHashSet();
        }
        return this.teacher.getProfessorships(this.executionSemester).stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).map(sp -> sp.getShift()).flatMap(s -> s.getAssociatedLessonsSet().stream()).flatMap(l -> l.getAllLessonsEvents().stream().map(e -> new TeacherLessonCalendarReport((Lesson)l, (EventBean)e))).sorted(TeacherLessonCalendarReport.COMPARATOR_BY_BEGIN).collect(Collectors.toList());
    }
}

