/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.services.cms.site.alternativesite;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.ulisboa.applications.services.cms.site.alternativesite.AlternativeSitesImporter$callable$processFile;
import org.fenixedu.ulisboa.applications.util.ULisboaApplicationsUtil;
import org.springframework.stereotype.Service;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Service
public class AlternativeSitesImporter {
    private static int NUMBER_REQUIRED_COLUMS;
    private static int COLUMN_DEGREE_CODE;
    private static int COLUMN_DEGREE_CURRICULAR_PLAN_NAME;
    private static int COLUMN_COMPETENCE_COURSE_CODE;
    private static int COLUMN_ALTERNATIVE_SITE_LINK;
    public static final Advice advice$processFile;

    public ProcessResult processFile(File file, ExecutionSemester executionSemester) {
        return (ProcessResult)advice$processFile.perform((Callable)new AlternativeSitesImporter$callable$processFile(this, file, executionSemester));
    }

    static /* synthetic */ ProcessResult advised$processFile(AlternativeSitesImporter this_, File file, ExecutionSemester executionSemester) {
        ProcessResult result = this_.new ProcessResult();
        this_.processFile(file, executionSemester, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File file, ExecutionSemester executionSemester, ProcessResult result) {
        Workbook wb = null;
        try {
            wb = WorkbookFactory.create((File)file);
            Sheet sheet = wb.getSheetAt(0);
            this.processSheet(sheet, executionSemester, result);
        }
        catch (IOException | InvalidFormatException e) {
            e.printStackTrace();
            result.reportFailure();
        }
        finally {
            if (wb != null) {
                try {
                    wb.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    result.reportFailure();
                }
            }
        }
    }

    private void processSheet(Sheet sheet, ExecutionSemester executionSemester, ProcessResult result) {
        Iterator rowIterator = sheet.rowIterator();
        rowIterator.next();
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            this.processRow(row, executionSemester, result);
        }
    }

    private void processRow(Row row, ExecutionSemester executionSemester, ProcessResult result) {
        if (row.getPhysicalNumberOfCells() >= NUMBER_REQUIRED_COLUMS) {
            Degree degree = this.getDegree(row, result);
            if (degree == null) {
                return;
            }
            DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(row, degree, result);
            if (degreeCurricularPlan == null) {
                return;
            }
            ExecutionCourse executionCourse = this.getExecutionCourse(row, degreeCurricularPlan, executionSemester, result);
            if (executionCourse == null) {
                return;
            }
            if (executionCourse.getSite() == null) {
                result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.noSiteConfigured", String.valueOf(row.getRowNum() + 1), executionSemester.getQualifiedName(), degreeCurricularPlan.getName(), executionCourse.getCode());
                return;
            }
            String alternativeSiteLink = row.getCell(COLUMN_ALTERNATIVE_SITE_LINK, Row.CREATE_NULL_AS_BLANK).getStringCellValue().trim();
            if (Strings.isNullOrEmpty((String)alternativeSiteLink)) {
                alternativeSiteLink = null;
            }
            executionCourse.getSite().setAlternativeSite(alternativeSiteLink);
        } else {
            result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.invalidLine", String.valueOf(row.getRowNum() + 1));
        }
    }

    private Degree getDegree(Row row, ProcessResult result) {
        String degreeCode = this.getCellValueAsString(row, row.getCell(COLUMN_DEGREE_CODE), result);
        if (degreeCode != null) {
            Degree degree = Degree.find((String)degreeCode);
            if (degree == null) {
                result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.unknownDegree", String.valueOf(row.getRowNum() + 1), degreeCode);
                return null;
            }
            return degree;
        }
        return null;
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(Row row, Degree degree, ProcessResult result) {
        String degreeCurricularPlanName = this.getCellValueAsString(row, row.getCell(COLUMN_DEGREE_CURRICULAR_PLAN_NAME), result);
        if (degreeCurricularPlanName != null) {
            DegreeCurricularPlan degreeCurricularPlan = degree.findDegreeCurricularPlan(new LocalizedString(Locale.getDefault(), degreeCurricularPlanName));
            if (degreeCurricularPlan == null) {
                result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.unknownDegreeCurricularPlan", String.valueOf(row.getRowNum() + 1), degree.getPresentationName(), degreeCurricularPlanName);
                return null;
            }
            return degreeCurricularPlan;
        }
        return null;
    }

    private ExecutionCourse getExecutionCourse(Row row, DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, ProcessResult result) {
        String competenceCourseCode = this.getCellValueAsString(row, row.getCell(COLUMN_COMPETENCE_COURSE_CODE), result);
        if (competenceCourseCode != null) {
            Optional<ExecutionCourse> executionCourseOptional = degreeCurricularPlan.getExecutionCoursesByExecutionPeriod(executionSemester).stream().filter(ec -> Objects.equals(ec.getCode(), competenceCourseCode)).findFirst();
            if (!executionCourseOptional.isPresent()) {
                result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.unknownExecutionCourse", String.valueOf(row.getRowNum() + 1), executionSemester.getQualifiedName(), degreeCurricularPlan.getName(), competenceCourseCode);
                return null;
            }
            return executionCourseOptional.get();
        }
        return null;
    }

    private String getCellValueAsString(Row row, Cell cell, ProcessResult result) {
        if (cell.getCellType() == 0) {
            return String.valueOf((int)cell.getNumericCellValue());
        }
        if (cell.getCellType() == 3 || cell.getCellType() == 1) {
            return cell.getStringCellValue();
        }
        result.addErrorMessage("label.org.fenixedu.ulisboa.applications.management.cms.site.alternativesite.process.error.invalidCell", String.valueOf(row.getRowNum() + 1), String.valueOf(cell.getColumnIndex() + 1));
        return null;
    }

    static {
        advice$processFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        NUMBER_REQUIRED_COLUMS = 3;
        COLUMN_DEGREE_CODE = 0;
        COLUMN_DEGREE_CURRICULAR_PLAN_NAME = 1;
        COLUMN_COMPETENCE_COURSE_CODE = 2;
        COLUMN_ALTERNATIVE_SITE_LINK = 3;
    }

    public class ProcessResult {
        private List<String> infoMessages = new ArrayList<String>();
        private List<String> errorMessages = new ArrayList<String>();
        private boolean processFailed = false;

        public void addInfoMessage(String message, String ... args) {
            this.infoMessages.add(ULisboaApplicationsUtil.bundle(message, args));
        }

        public void addErrorMessage(String message, String ... args) {
            this.errorMessages.add(ULisboaApplicationsUtil.bundle(message, args));
        }

        protected void reportFailure() {
            this.processFailed = true;
        }

        public boolean hasFailed() {
            return this.processFailed;
        }

        public List<String> getInfoMessages() {
            return this.infoMessages;
        }

        public List<String> getErrorMessages() {
            return this.errorMessages;
        }
    }
}

