/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.ulisboa.applications.services.teacher.calendar;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.LessonInstance;
import org.fenixedu.academic.domain.Teacher;

public class TeacherLessonCalendarService {
    private ExecutionSemester executionSemester;
    private Teacher teacher;

    public TeacherLessonCalendarService(Teacher teacher, ExecutionSemester executionSemester) {
        this.teacher = teacher;
        this.executionSemester = executionSemester;
    }

    public Collection<LessonInstance> getLessonInstances() {
        return this.buildSearchUniverse();
    }

    private Collection<LessonInstance> buildSearchUniverse() {
        if (this.teacher == null || this.executionSemester == null) {
            return Sets.newHashSet();
        }
        return this.teacher.getProfessorships(this.executionSemester).stream().flatMap(p -> p.getAssociatedShiftProfessorshipSet().stream()).map(sp -> sp.getShift()).flatMap(s -> s.getAssociatedLessonsSet().stream()).flatMap(l -> l.getLessonInstancesSet().stream()).sorted(LessonInstance.COMPARATOR_BY_BEGIN_DATE_TIME).collect(Collectors.toList());
    }
}

