<%@page import="org.fenixedu.treasury.ui.integration.erp.FinantialDocumentController"%>
<%@page import="org.fenixedu.treasury.domain.document.FinantialDocument"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<%@ taglib prefix="joda" uri="http://www.joda.org/joda/time/tags" %>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.12/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/select/1.2.0/js/dataTables.select.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.2/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/2.5.0/jszip.min.js"></script>
<script type="text/javascript" src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdn.rawgit.com/bpampuch/pdfmake/0.1.18/build/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.2.2/js/buttons.html5.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.2.2/css/buttons.dataTables.min.css" />


<spring:url var="datatablesBootstrapJsUrl" value="/javaScript/dataTables/media/js/jquery.dataTables.bootstrap.min.js"></spring:url>
<script type="text/javascript" src="${datatablesBootstrapJsUrl}"></script>
<spring:url var="datatablesCssUrl" value="/CSS/dataTables/dataTables.bootstrap.min.css" />

<link rel="stylesheet" href="${datatablesCssUrl}" />
<spring:url var="datatablesI18NUrl" value="/javaScript/dataTables/media/i18n/${portal.locale.language}.json" />
<link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/CSS/dataTables/dataTables.bootstrap.min.css" />

<!-- Choose ONLY ONE:  bennuToolkit OR bennuAngularToolkit -->
<%-- ${portal.angularToolkit()} --%>
${portal.toolkit()}

<link href="${pageContext.request.contextPath}/static/fenixedu-ulisboa-specifications/css/dataTables.responsive.css" rel="stylesheet" />
<script src="${pageContext.request.contextPath}/static/fenixedu-ulisboa-specifications/js/dataTables.responsive.js"></script>
<link href="${pageContext.request.contextPath}/webjars/datatables-tools/2.2.4/css/dataTables.tableTools.css" rel="stylesheet" />
<script src="${pageContext.request.contextPath}/webjars/datatables-tools/2.2.4/js/dataTables.tableTools.js"></script>
<link href="${pageContext.request.contextPath}/webjars/select2/4.0.0-rc.2/dist/css/select2.min.css" rel="stylesheet" />
<script src="${pageContext.request.contextPath}/webjars/select2/4.0.0-rc.2/dist/js/select2.min.js"></script>
<script type="text/javascript" src="${pageContext.request.contextPath}/webjars/bootbox/4.4.0/bootbox.js"></script>
<script src="${pageContext.request.contextPath}/static/fenixedu-ulisboa-specifications/js/omnis.js"></script>

<script src="${pageContext.request.contextPath}/webjars/angular-sanitize/1.3.11/angular-sanitize.js"></script>
<link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath}/webjars/angular-ui-select/0.11.2/select.min.css" />
<script src="${pageContext.request.contextPath}/webjars/angular-ui-select/0.11.2/select.min.js"></script>




<%-- TITLE --%>
<div class="page-header">
	<h1><spring:message code="label.integration.erp.searchFinantialDocument" />
		<small></small>
	</h1>
</div>
<%-- NAVIGATION --%>
<div class="well well-sm" style="display:inline-block">
<span class="glyphicon glyphicon-arrow-left" aria-hidden="true"></span>&nbsp;<a class="" href="${pageContext.request.contextPath}/treasury/integration/erp/erpexportoperation/"  ><spring:message code="label.event.back" /></a>
<%-- 
	&nbsp;|&nbsp;
    <span class="glyphicon glyphicon-cog" aria-hidden="true"></span>&nbsp;
    <a id="forceIntegrationExportAction" class="" href="${pageContext.request.contextPath}/treasury/integration/erp/finantialdocument/search/forceintegrationexport?finantialinstitution=${param.finantialinstitution}"  >
    	<spring:message code="label.event.integration.erp.forceIntegrationExport" />
    </a>
    |&nbsp;
    <span class="glyphicon glyphicon-cog" aria-hidden="true"></span>&nbsp;
    <a class="" href="${pageContext.request.contextPath}/treasury/integration/erp/finantialdocument/search/forcecheckstatus?finantialinstitution=${param.finantialinstitution}">
    	<spring:message code="label.event.integration.erp.forceCheckStatus" />
    </a>
--%>	    
</div>
	<c:if test="${not empty infoMessages}">
				<div class="alert alert-info" role="alert">
					
					<c:forEach items="${infoMessages}" var="message"> 
						<p> <span class="glyphicon glyphicon glyphicon-ok-sign" aria-hidden="true">&nbsp;</span>
  							${message}
  						</p>
					</c:forEach>
					
				</div>	
			</c:if>
			<c:if test="${not empty warningMessages}">
				<div class="alert alert-warning" role="alert">
					
					<c:forEach items="${warningMessages}" var="message"> 
						<p> <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true">&nbsp;</span>
  							${message}
  						</p>
					</c:forEach>
					
				</div>	
			</c:if>
			<c:if test="${not empty errorMessages}">
				<div class="alert alert-danger" role="alert">
					
					<c:forEach items="${errorMessages}" var="message"> 
						<p> <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true">&nbsp;</span>
  							${message}
  						</p>
					</c:forEach>
					
				</div>	
			</c:if>

<script type="text/javascript">
    function submitOptions(tableID, formID, attributeName) {
    array = $("#" + tableID).DataTable().rows(".selected")[0];  
    $("#" + formID).empty();
    if (array.length>0) {
        $.each(array,function(index, value) {
            externalId = $("#" + tableID).DataTable().row(value).data()["DT_RowId"];
            $("#" + formID).append("<input type='hidden' name='" + attributeName+ "' value='" + externalId + "'/>");
        });
        $("#" + formID).submit();
    }
    else
    {
        messageAlert('<spring:message code = "label.warning"/>','<spring:message code = "label.select.mustselect"/>');
    }
        
    }
    
    Omnis.block('forceIntegrationExportAction');
    
</script>


<div class="panel panel-default">
<form method="get" class="form-horizontal">
<div class="panel-body">
<div class="form-group row">
<div class="col-sm-2 control-label"><spring:message code="label.Series.finantialInstitution"/></div> 

<div class="col-sm-4">
    <%-- Relation to side 1 drop down rendered in input --%>
         <select id="finantialDocument_finantialInstitution" class="js-example-basic-single" name="finantialinstitution">
        </select>
                </div>
</div>      
</div>
<div class="panel-footer">
    <input type="submit" class="btn btn-default" role="button" value="<spring:message code="label.search" />"/>
</div>
</form>
</div>


<c:choose>
	<c:when test="${not empty searchfinantialdocumentResultsDataSet}">
		<table id="searchfinantialdocumentTable" class="table responsive table-bordered table-hover" width="100%">
			<thead>
				<tr>
					<%--!!!  Field names here --%>
					<th><spring:message code="label.FinantialDocument.documentNumber"/></th>
					<th><spring:message code="label.FinantialDocument.documentDate"/></th>
					<th><spring:message code="label.DebitNote.closeDate"/></th>
					<th><spring:message code="label.FinantialDocument.state"/></th>
					<th><spring:message code="label.Customer.businessIdentificationStudent.short"/></th>
					<th><spring:message code="label.Customer.name"/></th>
					<%-- Operations Column --%>
					<th></th>
				</tr>
			</thead>
			<tbody>
				<c:forEach items="${searchfinantialdocumentResultsDataSet}" var="f">
					<tr>
						<td>
							<a target="blank" href="${pageContext.request.contextPath}/treasury/integration/erp/finantialdocument/readfinantialdocument/${f.externalId}">
								<c:out value="${f.uiDocumentNumber}"/>
							</a>
							<br/>
							<em>(<c:out value="${f.state.descriptionI18N.content}"/>)</em>
						</td>
						<td><c:out value='${f.documentDate.toString("YYYY-MM-dd HH:mm:ss")}'/></td>
						<td><c:out value='${f.closeDate.toString("YYYY-MM-dd")}'/></td>
						<td>
							<font size="0.3em">
								<c:out value="${f.uiLastERPExportationErrorMessage}" escapeXml="false" />
							</font>
						</td>
						<td><c:out value="${f.debtAccount.customer.businessIdentification}"/></td>
						<td><c:out value="${f.debtAccount.customer.shortName}"/></td>
						<td>
							<a target="#" class="btn btn-default btn-xs" 
								href="${pageContext.request.contextPath}/treasury/integration/erp/finantialdocument/search/view/${f.externalId}">
									<spring:message code='label.view'/>
							</a>
						</td>
					</tr>
				</c:forEach>
			</tbody>
		</table>

<%-- 
        <form id="markMultipleAsExported"
            action="${pageContext.request.contextPath}<%=FinantialDocumentController.SEARCH_TO_MARK_MULTIPLE_EXPORTED_URL %>"
            style="display: none;" method="POST"></form>

        <button id="markMultipleAsExported" type="button"
            onClick="javascript:submitOptions('searchfinantialdocumentTable', 'markMultipleAsExported', 'document')">
            <span class="glyphicon glyphicon-ok-sign" aria-hidden="true"></span>&nbsp;
            <spring:message
                code='label.integration.erp.finantialdocument.markMultipleAsExported' />
        </button>
--%>

	</c:when>
	<c:otherwise>
				<div class="alert alert-warning" role="alert">
					
					<p> <span class="glyphicon glyphicon-exclamation-sign" aria-hidden="true">&nbsp;</span>			<spring:message code="label.noResultsFound" /></p>
					
				</div>	
		
	</c:otherwise>
</c:choose>

<script>
	$(document).ready(function() {

		<%-- Block for providing finantialInstitution options --%>
	    <%-- CHANGE_ME --%> <%-- INSERT YOUR FORMAT FOR element --%>
	    finantialInstitution_options = [
	        <c:forEach items="${FinantialDocument_finantialInstitution_options}" var="element"> 
	            {
	                text :"<c:out value='${element.name}'/>", 
	                id : "<c:out value='${element.externalId}'/>"
	            },
	        </c:forEach>
	    ];
	    
	    $("#finantialDocument_finantialInstitution").select2(
	        {
	            data : finantialInstitution_options,
	        }     
	            );
	            
	            <%-- If it's not from parameter change param.finantialInstitution to whatever you need (it's the externalId already) --%>
	            <c:if test ='${not empty param.finantialinstitution}'>
	            $("#finantialDocument_finantialInstitution").select2().select2('val', '<c:out value='${param.finantialinstitution}'/>');
	            </c:if>
                <c:if test ='${not empty finantialinstitution}'>
                $("#finantialDocument_finantialInstitution").select2().select2('val', '<c:out value='${finantialinstitution}'/>');
                </c:if>
	    <%-- End block for providing finantialDocumentType options --%>


		var table = $('#searchfinantialdocumentTable').DataTable({
				language : {
					url : "${datatablesI18NUrl}",			
				},
	
				"columnDefs": [
				    { "width": "10%", "targets": 0 },
				    { "width": "10%", "targets": 1 },
				    { "width": "10%", "targets": 2 },
				    { "width": "30%", "targets": 3 },
				    { "width": "5%", "targets": 4 },
				    { "width": "30%", "targets": 5 }
				  ],

				//Documentation: https://datatables.net/reference/option/dom
		        //"dom": 'T<"clear">lrtip', //FilterBox = NO && ExportOptions = YES
		        //"dom": '<"col-sm-6"l><"col-sm-6"f>rtip', //FilterBox = YES && ExportOptions = NO
		        //"dom": '<"col-sm-6"l>rtip', // FilterBox = NO && ExportOptions = NO
		        dom: '<"col-sm-5"l><"col-sm-3"f><"col-sm-3"B>rtip', //FilterBox = YES && ExportOptions = YES
	
		        buttons: [
		            'copyHtml5',
		            'excelHtml5',
		            'csvHtml5',
		            'pdfHtml5'
		        ],
	
		        "tableTools": {
		            "sSwfPath": "${pageContext.request.contextPath}/webjars/datatables-tools/2.2.4/swf/copy_csv_xls_pdf.swf"        	
		        }
			});
		
			table.columns.adjust().draw();
			
			  $('#searchfinantialdocumentTable tbody').on( 'click', 'tr', function () {
			        $(this).toggleClass('selected');
		    });
		  
	}); 
</script>

