/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.integration.erp;

import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPImportOperation;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.integration.erp.ERPImportOperationController$callable$cloneERPImportOperation;
import org.fenixedu.treasury.ui.integration.erp.ERPImportOperationController$callable$createERPImportOperation;
import org.fenixedu.treasury.ui.integration.erp.ERPImportOperationController$callable$deleteERPImportOperation;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.integration.erp.import", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/integration/erp/erpimportoperation"})
public class ERPImportOperationController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/integration/erp/erpimportoperation";
    public static final long SEARCH_LIMIT_SIZE = 1000L;
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/integration/erp/erpimportoperation/";
    private static final String _SEARCH_TO_DELETEMULTIPLE_URI = "/search/deletemultiple";
    public static final String SEARCH_TO_DELETEMULTIPLE_URL = "/treasury/integration/erp/erpimportoperation/search/deletemultiple";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/integration/erp/erpimportoperation/search/view/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/integration/erp/erpimportoperation/create";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/integration/erp/erpimportoperation/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/integration/erp/erpimportoperation/delete/";
    public static final Advice advice$deleteERPImportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createERPImportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
    public static final Advice advice$cloneERPImportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/integration/erp/erpimportoperation/";
    }

    private ERPImportOperation getERPImportOperation(Model model) {
        return (ERPImportOperation)model.asMap().get("eRPImportOperation");
    }

    private void setERPImportOperation(ERPImportOperation eRPImportOperation, Model model) {
        model.addAttribute("eRPImportOperation", (Object)eRPImportOperation);
    }

    public void deleteERPImportOperation(ERPImportOperation eRPImportOperation) {
        Object object = advice$deleteERPImportOperation.perform((Callable)new ERPImportOperationController$callable$deleteERPImportOperation(this, eRPImportOperation));
    }

    static /* synthetic */ void advised$deleteERPImportOperation(ERPImportOperationController this_, ERPImportOperation eRPImportOperation) {
        eRPImportOperation.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="finantialinstitution", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="fromexecutiondate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime fromExecutionDate, @RequestParam(value="toexecutiondate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime toExecutionDate, @RequestParam(value="success", required=false) Boolean success, @RequestParam(value="documentnumber", required=false) String documentNumber, Model model) {
        List<ERPImportOperation> result;
        if (fromExecutionDate != null) {
            fromExecutionDate = fromExecutionDate.toLocalDate().toDateTimeAtStartOfDay();
        }
        if (toExecutionDate != null) {
            toExecutionDate = toExecutionDate.toLocalDate().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
        }
        model.addAttribute("limit_exceeded", (Object)((long)(result = this.filterSearch(finantialInstitution, fromExecutionDate, toExecutionDate, success, documentNumber)).size() > 1000L ? 1 : 0));
        model.addAttribute("searcherpimportoperationResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searcherpimportoperationResultsDataSet", result.stream().limit(1000L).collect(Collectors.toList()));
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/integration/erp/erpimportoperation/search";
    }

    private Stream<ERPImportOperation> getSearchUniverse(FinantialInstitution finantialInstitution, String documentNumber) {
        FinantialDocument finantialDocument = FinantialDocument.findByUiDocumentNumber((FinantialInstitution)finantialInstitution, (String)documentNumber);
        if (finantialDocument != null) {
            return ERPImportOperation.find((FinantialDocument)finantialDocument);
        }
        if (finantialInstitution != null) {
            return ERPImportOperation.findByFinantialInstitution((FinantialInstitution)finantialInstitution);
        }
        return ERPImportOperation.findAll();
    }

    private List<ERPImportOperation> filterSearch(FinantialInstitution finantialInstitution, DateTime fromExecutionDate, DateTime toExecutionDate, Boolean success, String documentNumber) {
        ArrayList result = Lists.newArrayList();
        boolean search = false;
        Predicate<ERPImportOperation> predicate = i -> true;
        if (!StringUtils.isEmpty((Object)documentNumber)) {
            search = true;
        }
        if (fromExecutionDate != null) {
            search = true;
            predicate = predicate.and(i -> i.getExecutionDate().isAfter((ReadableInstant)fromExecutionDate));
        }
        if (toExecutionDate != null) {
            search = true;
            predicate = predicate.and(i -> i.getExecutionDate().isBefore((ReadableInstant)toExecutionDate));
        }
        if (success != null) {
            search = true;
            predicate = predicate.and(i -> i.getSuccess() == success.booleanValue());
        }
        if (search) {
            this.getSearchUniverse(finantialInstitution, documentNumber).filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/deletemultiple"})
    public String processSearchToDeleteMultiple(@RequestParam(value="eRPImportOperations") List<ERPImportOperation> eRPImportOperations, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!eRPImportOperations.isEmpty()) {
                this.assertUserIsBackOfficeMember(eRPImportOperations.get(0).getFinantialInstitution(), model);
            }
            for (ERPImportOperation operation : eRPImportOperations) {
                this.deleteERPImportOperation(operation);
            }
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + eRPImportOperation.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/integration/erp/erpimportoperation/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="finantialinstitution", required=true) FinantialInstitution finantialInstitution, @RequestParam(value="file", required=true) MultipartFile file, Model model, RedirectAttributes redirectAttributes) {
        try {
            ERPImportOperation eRPImportOperation = this.createERPImportOperation(finantialInstitution, file);
            IERPImporter erpImporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPImporter(file.getInputStream());
            erpImporter.processAuditFile(eRPImportOperation);
            model.addAttribute("eRPImportOperation", (Object)eRPImportOperation);
            return this.redirect(READ_URL + this.getERPImportOperation(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    public ERPImportOperation createERPImportOperation(FinantialInstitution finantialInstitution, MultipartFile multipartFile) throws IOException {
        return (ERPImportOperation)advice$createERPImportOperation.perform((Callable)new ERPImportOperationController$callable$createERPImportOperation(this, finantialInstitution, multipartFile));
    }

    static /* synthetic */ ERPImportOperation advised$createERPImportOperation(ERPImportOperationController this_, FinantialInstitution finantialInstitution, MultipartFile file) throws IOException {
        IERPImporter erpImporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPImporter(file.getInputStream());
        FinantialInstitution finantialInstitutionFromFile = FinantialInstitution.findUniqueByFiscalCode((String)erpImporter.readTaxRegistrationNumberFromAuditFile()).orElse(null);
        if (finantialInstitution != finantialInstitutionFromFile) {
            throw new TreasuryDomainException("label.error.integration.erp.erpimportoperation.invalid.fiscalinstitution.file", new String[0]);
        }
        ERPImportOperation eRPImportOperation = ERPImportOperation.create((String)file.getOriginalFilename(), (byte[])file.getBytes(), (FinantialInstitution)finantialInstitution, null, (DateTime)new DateTime(), (boolean)false, (boolean)false, (boolean)false);
        return eRPImportOperation;
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model) {
        this.setERPImportOperation(eRPImportOperation, model);
        return "treasury/integration/erp/erpimportoperation/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes) {
        this.setERPImportOperation(eRPImportOperation, model);
        try {
            this.assertUserIsBackOfficeMember(eRPImportOperation.getFinantialInstitution(), model);
            this.deleteERPImportOperation(eRPImportOperation);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getERPImportOperation(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}/downloadfile"})
    public void processReadToDownloadFile(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPImportOperation(eRPImportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPImportOperation.getFinantialInstitution(), model);
            response.setContentType(eRPImportOperation.getFile().getContentType());
            String filename = eRPImportOperation.getFile().getFilename();
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(eRPImportOperation.getFile().getContent());
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getERPImportOperation(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/retryimport"})
    public String processReadToRetryImport(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes) {
        this.setERPImportOperation(eRPImportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPImportOperation.getFinantialInstitution(), model);
            ERPImportOperation newERPImportOperation = this.cloneERPImportOperation(eRPImportOperation);
            IERPImporter erpImporter = eRPImportOperation.getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPImporter(eRPImportOperation.getFile().getStream());
            erpImporter.processAuditFile(newERPImportOperation);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.importoperation.success", (String[])new String[0]), model);
            return this.redirect(READ_URL + newERPImportOperation.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getERPImportOperation(model).getExternalId(), model, redirectAttributes);
    }

    private ERPImportOperation cloneERPImportOperation(ERPImportOperation eRPImportOperation) {
        return (ERPImportOperation)advice$cloneERPImportOperation.perform((Callable)new ERPImportOperationController$callable$cloneERPImportOperation(this, eRPImportOperation));
    }

    static /* synthetic */ ERPImportOperation advised$cloneERPImportOperation(ERPImportOperationController this_, ERPImportOperation erpImportOperation) {
        ERPImportOperation newERPImportOperation = ERPImportOperation.create((String)erpImportOperation.getFile().getFilename(), (byte[])erpImportOperation.getFile().getContent(), (FinantialInstitution)erpImportOperation.getFinantialInstitution(), (String)erpImportOperation.getErpOperationId(), (DateTime)new DateTime(), (boolean)false, (boolean)false, (boolean)false);
        return newERPImportOperation;
    }

    @RequestMapping(value={"/soapoutboundmessage/{oid}"})
    public void soapOutboundMessage(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPImportOperation(eRPImportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPImportOperation.getFinantialInstitution(), model);
            response.setContentType(MediaType.XML_UTF_8.toString());
            response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Outbound_Message_%s.xml", eRPImportOperation.getExternalId()));
            response.getWriter().write(eRPImportOperation.getSoapOutboundMessage() != null ? eRPImportOperation.getSoapOutboundMessage() : "");
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + eRPImportOperation.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/soapinboundmessage/{oid}"})
    public void soapInboundMessage(@PathVariable(value="oid") ERPImportOperation eRPImportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPImportOperation(eRPImportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPImportOperation.getFinantialInstitution(), model);
            response.setContentType(MediaType.XML_UTF_8.toString());
            response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Inbound_Message_%s.xml", eRPImportOperation.getExternalId()));
            response.getWriter().write(eRPImportOperation.getSoapInboundMessage() != null ? eRPImportOperation.getSoapInboundMessage() : "");
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + eRPImportOperation.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

