/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.integration.erp;

import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.integration.erp.ERPExportOperationController$callable$deleteERPExportOperation;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.integration.erp.export", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/integration/erp/erpexportoperation"})
public class ERPExportOperationController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/integration/erp/erpexportoperation";
    public static final long SEARCH_LIMIT_SIZE = 1000L;
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/integration/erp/erpexportoperation/";
    private static final String _SEARCH_TO_DELETEMULTIPLE_URI = "/search/deletemultiple";
    public static final String SEARCH_TO_DELETEMULTIPLE_URL = "/treasury/integration/erp/erpexportoperation/search/deletemultiple";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/integration/erp/erpexportoperation/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/integration/erp/erpexportoperation/read/";
    private static final String _DELETE_URI = "/delete/";
    private static final String _DELETE_MULTIPLE_URI = "/deletemultiple/";
    public static final String DELETE_URL = "/treasury/integration/erp/erpexportoperation/delete/";
    public static final Advice advice$deleteERPExportOperation = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/integration/erp/erpexportoperation/";
    }

    private ERPExportOperation getERPExportOperation(Model model) {
        return (ERPExportOperation)model.asMap().get("eRPExportOperation");
    }

    private void setERPExportOperation(ERPExportOperation eRPExportOperation, Model model) {
        model.addAttribute("eRPExportOperation", (Object)eRPExportOperation);
    }

    public void deleteERPExportOperation(ERPExportOperation eRPExportOperation) {
        Object object = advice$deleteERPExportOperation.perform((Callable)new ERPExportOperationController$callable$deleteERPExportOperation(this, eRPExportOperation));
    }

    static /* synthetic */ void advised$deleteERPExportOperation(ERPExportOperationController this_, ERPExportOperation eRPExportOperation) {
        eRPExportOperation.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="finantialinstitution", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="fromexecutiondate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime fromExecutionDate, @RequestParam(value="toexecutiondate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime toExecutionDate, @RequestParam(value="success", required=false) Boolean success, @RequestParam(value="documentnumber", required=false) String documentNumber, Model model) {
        List<ERPExportOperation> result;
        if (fromExecutionDate != null) {
            fromExecutionDate = fromExecutionDate.toLocalDate().toDateTimeAtStartOfDay();
        }
        if (toExecutionDate != null) {
            toExecutionDate = toExecutionDate.toLocalDate().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1);
        }
        model.addAttribute("limit_exceeded", (Object)((long)(result = this.filterSearch(finantialInstitution, fromExecutionDate, toExecutionDate, success, documentNumber)).size() > 1000L ? 1 : 0));
        model.addAttribute("searcherpexportoperationResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searcherpexportoperationResultsDataSet", result.stream().limit(1000L).collect(Collectors.toList()));
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/integration/erp/erpexportoperation/search";
    }

    private Stream<ERPExportOperation> getSearchUniverse(FinantialInstitution finantialInstitution, String documentNumber) {
        FinantialDocument finantialDocument = FinantialDocument.findByUiDocumentNumber((FinantialInstitution)finantialInstitution, (String)documentNumber);
        if (finantialDocument != null) {
            return ERPExportOperation.find((FinantialDocument)finantialDocument);
        }
        if (finantialInstitution != null) {
            return ERPExportOperation.findByFinantialInstitution((FinantialInstitution)finantialInstitution);
        }
        return ERPExportOperation.findAll();
    }

    private List<ERPExportOperation> filterSearch(FinantialInstitution finantialInstitution, DateTime fromExecutionDate, DateTime toExecutionDate, Boolean success, String documentNumber) {
        ArrayList result = Lists.newArrayList();
        boolean search = false;
        Predicate<ERPExportOperation> predicate = i -> true;
        if (!StringUtils.isEmpty((Object)documentNumber)) {
            search = true;
        }
        if (fromExecutionDate != null) {
            search = true;
            predicate = predicate.and(i -> i.getExecutionDate().isAfter((ReadableInstant)fromExecutionDate));
        }
        if (toExecutionDate != null) {
            search = true;
            predicate = predicate.and(i -> i.getExecutionDate().isBefore((ReadableInstant)toExecutionDate));
        }
        if (success != null) {
            search = true;
            predicate = predicate.and(i -> i.getSuccess() == success.booleanValue());
        }
        if (search) {
            this.getSearchUniverse(finantialInstitution, documentNumber).filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/deletemultiple"})
    public String processSearchToDeleteMultiple(@RequestParam(value="eRPExportOperations") List<ERPExportOperation> eRPExportOperations, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + eRPExportOperation.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model) {
        this.setERPExportOperation(eRPExportOperation, model);
        return "treasury/integration/erp/erpexportoperation/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes) {
        this.setERPExportOperation(eRPExportOperation, model);
        try {
            this.assertUserIsBackOfficeMember(eRPExportOperation.getFinantialInstitution(), model);
            this.deleteERPExportOperation(eRPExportOperation);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getERPExportOperation(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/deletemultiple/"}, method={RequestMethod.POST})
    public String deleteMultiple(@RequestParam(value="operations") List<ERPExportOperation> eRPExportOperations, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!eRPExportOperations.isEmpty()) {
                this.assertUserIsBackOfficeMember(eRPExportOperations.get(0).getFinantialInstitution(), model);
            }
            for (ERPExportOperation operation : eRPExportOperations) {
                this.deleteERPExportOperation(operation);
            }
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/downloadfile"})
    public void processReadToDownloadFile(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPExportOperation(eRPExportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPExportOperation.getFinantialInstitution(), model);
            response.setContentType(eRPExportOperation.getFile().getContentType());
            String filename = eRPExportOperation.getFile().getFilename();
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(eRPExportOperation.getFile().getContent());
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getERPExportOperation(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/retryimport"})
    public String processReadToRetryImport(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes) {
        this.setERPExportOperation(eRPExportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPExportOperation.getFinantialInstitution(), model);
            ERPExportOperation retryExportOperation = ERPExporterManager.retryExportToIntegration((ERPExportOperation)eRPExportOperation);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.exportoperation.success", (String[])new String[0]), model);
            return this.redirect(READ_URL + retryExportOperation.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + eRPExportOperation.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/soapoutboundmessage/{oid}"})
    public void soapOutboundMessage(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPExportOperation(eRPExportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPExportOperation.getFinantialInstitution(), model);
            response.setContentType(MediaType.XML_UTF_8.toString());
            response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Outbound_Message_%s.xml", eRPExportOperation.getExternalId()));
            response.getWriter().write(eRPExportOperation.getSoapOutboundMessage() != null ? eRPExportOperation.getSoapOutboundMessage() : "");
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getERPExportOperation(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/soapinboundmessage/{oid}"})
    public void soapInboundMessage(@PathVariable(value="oid") ERPExportOperation eRPExportOperation, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setERPExportOperation(eRPExportOperation, model);
        try {
            this.assertUserIsFrontOfficeMember(eRPExportOperation.getFinantialInstitution(), model);
            response.setContentType(MediaType.XML_UTF_8.toString());
            response.setHeader("Content-disposition", String.format("attachment; filename=SOAP_Inbound_Message_%s.xml", eRPExportOperation.getExternalId()));
            response.getWriter().write(eRPExportOperation.getSoapInboundMessage() != null ? eRPExportOperation.getSoapInboundMessage() : "");
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getERPExportOperation(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

