/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.PaymentRequest_Base;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentStatusBean;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=TreasuryController.class, title="label.ManageForwardPayments.functionality", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/document/forwardpayments/management"})
public class ManageForwardPaymentsController
extends TreasuryBaseController {
    private static final int MAX_SEARCH_SIZE = 1000;
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/management";
    private static final String JSP_PATH = "/treasury/document/forwardpayments/management";
    public static final String SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/treasury/document/forwardpayments/management/search";
    public static final String VIEW_URI = "/view";
    public static final String VIEW_URL = "/treasury/document/forwardpayments/management/view";
    private static final String VERIFY_FORWARD_PAYMENT_URI = "/verifyforwardpayment";
    public static final String VERIFY_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/management/verifyforwardpayment";
    private static final String REGISTER_PAYMENT_URI = "/registerpayment";
    public static final String REGISTER_PAYMENT_URL = "/treasury/document/forwardpayments/management/registerpayment";
    private static final String DOWNLOAD_EXCEPTION_LOG_URI = "/downloadexceptionlog";
    public static final String DOWNLOAD_EXCEPTION_LOG_URL = "/treasury/document/forwardpayments/management/downloadexceptionlog";
    public static final String EXPORT_URI = "/export";
    public static final String EXPORT_URL = "/treasury/document/forwardpayments/management/export";

    @RequestMapping
    public String home() {
        return "redirect:/treasury/document/forwardpayments/management/search";
    }

    @RequestMapping(value={"/search"}, method={RequestMethod.GET})
    public String search(@RequestParam(value="beginDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="endDate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="customerName", required=false) String customerName, @RequestParam(value="customerBusinessId", required=false) String customerBusinessId, @RequestParam(value="orderNumber", required=false) String orderNumber, @RequestParam(value="withPendingPlatformPayment", required=false) boolean withPendingPlatformPayment, @RequestParam(value="forwardPaymentStateType", required=false) ForwardPaymentStateType stateType, Model model) {
        boolean canLimitResults;
        Stream<Object> stream = ForwardPaymentRequest.findAll();
        if (!Strings.isNullOrEmpty((String)orderNumber)) {
            stream = stream.filter(p -> orderNumber.trim().equals(String.valueOf(p.getOrderNumber())));
        } else {
            if (beginDate != null) {
                stream = stream.filter(p -> !p.getRequestDate().isBefore((ReadableInstant)beginDate.toDateTimeAtStartOfDay()));
            }
            if (endDate != null) {
                stream = stream.filter(p -> !p.getRequestDate().isAfter((ReadableInstant)endDate.toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1)));
            }
            if (!Strings.isNullOrEmpty((String)customerName)) {
                stream = stream.filter(p -> TreasuryConstants.stringNormalizedContains((String)p.getDebtAccount().getCustomer().getName(), (String)customerName));
            }
            if (!Strings.isNullOrEmpty((String)customerBusinessId)) {
                stream = stream.filter(p -> p.getDebtAccount().getCustomer().getBusinessIdentification().equals(customerBusinessId));
            }
            if (stateType != null) {
                stream = stream.filter(p -> p.getState() == stateType);
            }
        }
        if (withPendingPlatformPayment) {
            List resultList = stream.collect(Collectors.toList());
            stream = resultList.stream();
            int MAX_PENDING_POSSIBLE_PAYMENTS = 500;
            if (resultList.stream().filter(p -> p.isInRequestedState()).count() > (long)MAX_PENDING_POSSIBLE_PAYMENTS) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.ManageForwardPayments.search.withPendingPlatformPayment.limited.narrow.search", (String[])new String[0]), model);
            } else {
                stream = stream.filter(p -> p.isInRequestedState());
                stream = stream.filter(p -> p.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(p).isAbleToRegisterPostPayment(p));
            }
        }
        String username = TreasuryConstants.getAuthenticatedUsername();
        stream = stream.filter(p -> TreasuryAccessControlAPI.isBackOfficeMember((String)username, (FinantialInstitution)p.getDigitalPaymentPlatform().getFinantialInstitution()));
        List forwardPayments = stream.sorted(Collections.reverseOrder(Comparator.comparing(PaymentRequest_Base::getRequestDate))).collect(Collectors.toList());
        boolean bl = canLimitResults = beginDate == null || endDate == null || Days.daysBetween((ReadablePartial)beginDate, (ReadablePartial)endDate).getDays() > 1;
        if (canLimitResults && forwardPayments.size() > 1000) {
            model.addAttribute("limitResults", (Object)true);
            model.addAttribute("limit", (Object)1000);
            model.addAttribute("total", (Object)forwardPayments.size());
            forwardPayments = forwardPayments.subList(0, 1000);
        }
        model.addAttribute("forwardPaymentStateTypes", Lists.newArrayList((Object[])ForwardPaymentStateType.values()).stream().sorted(ForwardPaymentStateType.COMPARE_BY_LOCALIZED_NAME).collect(Collectors.toList()));
        model.addAttribute("forwardPayments", forwardPayments);
        return this.jspPage(SEARCH_URI);
    }

    @RequestMapping(value={"/view/{forwardPaymentId}"})
    public String view(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model) {
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        return this.jspPage(VIEW_URI);
    }

    @RequestMapping(value={"/verifyforwardpayment/{forwardPaymentId}"})
    public String verifyforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model, RedirectAttributes redirectAttributes) {
        try {
            ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(forwardPayment);
            model.addAttribute("forwardPayment", (Object)forwardPayment);
            model.addAttribute("paymentStatusBeanList", Collections.singletonList(paymentStatusBean));
            return this.jspPage(VERIFY_FORWARD_PAYMENT_URI);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect("/treasury/document/forwardpayments/management/view/" + forwardPayment.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/registerpayment/{forwardPaymentId}"}, method={RequestMethod.POST})
    public String registerPayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, @RequestParam(value="justification") String justification, @RequestParam(value="transactionId") String transactionId, Model model, RedirectAttributes redirectAttributes) {
        try {
            ForwardPaymentStatusBean paymentStatusBean = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(forwardPayment);
            if (!forwardPayment.isInStateToPostProcessPayment() || !paymentStatusBean.isInPayedState()) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.ManageForwardPayments.forwardPayment.not.created.nor.payed.in.platform", (String[])new String[0]), model);
                return String.format("redirect:%s/%s", VERIFY_FORWARD_PAYMENT_URL, forwardPayment.getExternalId());
            }
            IForwardPaymentPlatformService implementation = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService();
            Optional<Object> optionalTransactionId = Optional.empty();
            if (StringUtils.isNotEmpty((String)transactionId)) {
                optionalTransactionId = Optional.of(transactionId);
            }
            implementation.postProcessPayment(forwardPayment, justification, optionalTransactionId);
            return String.format("redirect:%s/%s", VIEW_URL, forwardPayment.getExternalId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect(String.format("%s/%s", VERIFY_FORWARD_PAYMENT_URL, forwardPayment.getExternalId()), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/downloadexceptionlog/{forwardPaymentLogId}"}, method={RequestMethod.GET}, produces={"application/octet-stream"})
    @ResponseBody
    public byte[] downloadexceptionlog(@PathVariable(value="forwardPaymentLogId") PaymentRequestLog forwardPaymentLog, Model model, HttpServletResponse response) {
        this.assertUserIsManager(model);
        response.setHeader("Content-Disposition", "attachment; filename=" + String.format("exceptionLog-%s.txt", forwardPaymentLog.getExternalId()));
        if (forwardPaymentLog.getExceptionLogFile() != null) {
            return TreasuryPlataformDependentServicesFactory.implementation().getFileContent((IGenericFile)forwardPaymentLog.getExceptionLogFile());
        }
        return null;
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    @ResponseBody
    public void export() {
    }

    private String jspPage(String mapping) {
        return "/treasury/document/forwardpayments/management" + mapping;
    }
}

