/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.converters;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class BeanConverterService
implements ConditionalGenericConverter {
    private GsonBuilder builder;

    public BeanConverterService(GsonBuilder builder) {
        this.builder = builder;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return String.class.equals((Object)sourceType.getType()) && ITreasuryBean.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, ITreasuryBean.class));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        JsonParser parser = new JsonParser();
        String jsonStr = (String)source;
        JsonElement parse = parser.parse(jsonStr);
        if (parse instanceof JsonArray) {
            ArrayList<Object> list = new ArrayList<Object>();
            JsonArray jsonArray = (JsonArray)parse;
            for (int i = 0; i < jsonArray.size(); ++i) {
                String className = jsonArray.get(i).getAsJsonObject().get("classname").getAsString();
                list.add(this.convertObject(jsonArray.get(i), targetType));
            }
            return list;
        }
        return this.convertObject(parse, targetType);
    }

    private Object convertObject(JsonElement jsonElement, TypeDescriptor targetType) {
        String className = jsonElement.getAsJsonObject().get("classname").getAsString();
        try {
            Class<?> beanObjectClass = Class.forName(className);
            Gson gson = Converters.registerAll((GsonBuilder)this.builder).create();
            Object beanObject = gson.fromJson(jsonElement, beanObjectClass);
            return targetType.getType().cast(beanObject);
        }
        catch (Exception e) {
            System.out.print("Error deserializing bean :" + e.getMessage() + "\n");
            System.out.print("Bean JSON :" + jsonElement.toString() + "\n");
            return null;
        }
    }
}

