/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managesibsoutputfile;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managesibsoutputfile.SibsOutputFileController$callable$deleteSibsOutputFile;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.manageSibsOutputFile", accessGroup="treasuryBackOffice")
@RequestMapping(value={"/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile"})
public class SibsOutputFileController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/delete/";
    private static final String _DOWNLOAD_URI = "/read/download/";
    public static final String DOWNLOAD_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/read/download/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/create";
    public static final Advice advice$deleteSibsOutputFile = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/";
    }

    private SibsOutputFile getSibsOutputFile(Model model) {
        return (SibsOutputFile)model.asMap().get("sibsOutputFile");
    }

    private void setSibsOutputFile(SibsOutputFile sibsOutputFile, Model model) {
        model.addAttribute("sibsOutputFile", (Object)sibsOutputFile);
    }

    public void deleteSibsOutputFile(SibsOutputFile sibsOutputFile) {
        Object object = advice$deleteSibsOutputFile.perform((Callable)new SibsOutputFileController$callable$deleteSibsOutputFile(this, sibsOutputFile));
    }

    static /* synthetic */ void advised$deleteSibsOutputFile(SibsOutputFileController this_, SibsOutputFile sibsOutputFile) {
        sibsOutputFile.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="whenprocessedbysibs", required=false) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") LocalDate whencreated, Model model) {
        List<SibsOutputFile> searchsibsoutputfileResultsDataSet = this.filterSearchSibsOutputFile(whencreated);
        model.addAttribute("searchsibsoutputfileResultsDataSet", searchsibsoutputfileResultsDataSet);
        return "treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/search";
    }

    private Stream<SibsOutputFile> getSearchUniverseSearchSibsOutputFileDataSet() {
        return SibsOutputFile.findAll();
    }

    private List<SibsOutputFile> filterSearchSibsOutputFile(LocalDate whencreated) {
        return this.getSearchUniverseSearchSibsOutputFileDataSet().filter(sibsOutputFile -> whencreated == null || whencreated.equals((Object)TreasuryPlataformDependentServicesFactory.implementation().versioningCreationDate(sibsOutputFile).toLocalDate())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") SibsOutputFile sibsOutputFile, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + sibsOutputFile.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") SibsOutputFile sibsOutputFile, Model model) {
        this.setSibsOutputFile(sibsOutputFile, model);
        return "treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") SibsOutputFile sibsOutputFile, Model model, RedirectAttributes redirectAttributes) {
        this.setSibsOutputFile(sibsOutputFile, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsOutputFile.getFinantialInstitution(), model);
            this.deleteSibsOutputFile(sibsOutputFile);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSibsOutputFile(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/download/{oid}"}, method={RequestMethod.GET})
    public void processReadToDownloadFile(@PathVariable(value="oid") SibsOutputFile sibsOutputFile, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        this.setSibsOutputFile(sibsOutputFile, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsOutputFile.getFinantialInstitution(), model);
            response.setContentType(sibsOutputFile.getContentType());
            String filename = sibsOutputFile.getFilename();
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(sibsOutputFile.getContent());
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + this.getSibsOutputFile(model).getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("finantialinstitution_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/administration/payments/sibs/managesibsoutputfile/sibsoutputfile/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="lastsuccessfulexportation", required=true) @DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ss.SSSZ") DateTime lastSuccessfulExportation, @RequestParam(value="finantialinstitution", required=true) FinantialInstitution finantialInstitution, @RequestParam(value="sibsentityreferencecode", required=true) String sibsEntityReferenceCode, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            SibsOutputFile sibsOutputFile = (SibsOutputFile)FenixFramework.atomic(() -> SibsOutputFile.create((FinantialInstitution)finantialInstitution, (String)sibsEntityReferenceCode, (DateTime)lastSuccessfulExportation));
            model.addAttribute("sibsOutputFile", (Object)sibsOutputFile);
            return this.redirect(READ_URL + this.getSibsOutputFile(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }
}

