/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import java.util.HashSet;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.treasury.ui.accounting.managecustomer")
@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/paymentreferencecode";
    private static final String JSP_PATH = "treasury/accounting/managecustomer/paymentreferencecode";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URI = "/createpaymentcodeforseveraldebitentries";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentries";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URI = "/createpaymentcodeforseveraldebitentriespostback";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/paymentreferencecode/";
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.GET})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        this.checkPermissions(debtAccount, model);
        PaymentReferenceCodeBean bean = new PaymentReferenceCodeBean((DigitalPaymentPlatform)DigitalPaymentPlatform.findForSibsPaymentCodeServiceByActive((FinantialInstitution)debtAccount.getFinantialInstitution(), (boolean)true).findFirst().orElse(null), debtAccount);
        bean.setUsePaymentAmountWithInterests(false);
        return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
    }

    protected String _createPaymentCodeForSeveralDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean bean, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl(debtAccount));
        model.addAttribute("createUrl", (Object)this.getCreateUrl(debtAccount));
        model.addAttribute("createPostbackUrl", (Object)this.getCreatePostbackUrl(debtAccount));
        return this.jspPage("createpaymentcodeforseveraldebitentries");
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentriespostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createPaymentCodeForSeveralDebitEntriesPostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        this.checkPermissions(debtAccount, model);
        bean.updateAmountOnSelectedDebitEntries();
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.POST})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.checkPermissions(debtAccount, model);
        try {
            boolean hasSelectedInstallments;
            boolean hasSelectedDebitEntries = bean.getSelectedDebitEntries() != null && !bean.getSelectedDebitEntries().isEmpty();
            boolean bl = hasSelectedInstallments = bean.getSelectedInstallments() != null && !bean.getSelectedInstallments().isEmpty();
            if (!hasSelectedDebitEntries && !hasSelectedInstallments) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.MultipleEntriesPaymentCode.select.at.least.one.debit.entry", (String[])new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            if (bean.getPaymentCodePool() == null) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.MultipleEntriesPaymentCode.payment.code.pool.required", (String[])new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            bean.getPaymentCodePool().castToSibsPaymentCodePoolService().createSibsPaymentRequest(debtAccount, new HashSet(bean.getSelectedDebitEntries()), new HashSet(bean.getSelectedInstallments()), bean.getPaymentAmount());
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.document.managepayments.success.create.reference.code.selected.debit.entries", (String[])new String[0]), model);
            return this.redirect(String.format(this.readDebtAccountUrl(debtAccount), new Object[0]), model, redirectAttributes);
        }
        catch (TreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
        }
    }

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
    }

    protected String readDebtAccountUrl(DebtAccount debtAccount) {
        return String.format("%s/%s", "/treasury/accounting/managecustomer/debtaccount/read/", debtAccount.getExternalId());
    }

    protected String getCreateUrl(DebtAccount debtAccount) {
        return "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentries/" + debtAccount.getExternalId();
    }

    protected String getCreatePostbackUrl(DebtAccount debtAccount) {
        return "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback/" + debtAccount.getExternalId();
    }

    private String jspPage(String page) {
        return "treasury/accounting/managecustomer/paymentreferencecode/" + page;
    }
}

