/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments.implementations;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.exceptions.ForwardPaymentAlreadyPayedException;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentController;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.payline.PaylineConfiguration;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.forwardpayments.implementations.PaylineController$callable$rejectPayment;
import org.fenixedu.treasury.ui.document.forwardpayments.implementations.PaylineController$callable$rejectPaymentAndLogException;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.paylineReturnForwardPayment", accessGroup="logged")
@RequestMapping(value={"/treasury/document/forwardpayments/payline"})
public class PaylineController
extends TreasuryBaseController
implements IForwardPaymentController {
    public static final String CONTROLLER_URL = "/treasury/document/forwardpayments/payline";
    private static final String RETURN_FORWARD_PAYMENT_URI = "/returnforwardpayment";
    public static final String RETURN_FORWARD_PAYMENT_URL = "/treasury/document/forwardpayments/payline/returnforwardpayment";
    public static Map<Class<IForwardPaymentPlatformService>, Class<IForwardPaymentController>> CONTROLLER_MAP;
    public static final Advice advice$rejectPayment;
    public static final Advice advice$rejectPaymentAndLogException;

    public String processforwardpayment(ForwardPaymentRequest forwardPayment, Object model, HttpServletResponse response, HttpSession session) {
        ((Model)model).addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getDigitalPaymentPlatform());
        try {
            PaylineConfiguration paylineImplementation = (PaylineConfiguration)forwardPayment.getDigitalPaymentPlatform();
            boolean paylineSucess = paylineImplementation.doWebPayment(forwardPayment, this.readReturnForwardPaymentUrl(), session);
            if (!paylineSucess) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
            }
            return "redirect:" + forwardPayment.getRedirectUrl();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.rejectPaymentAndLogException(forwardPayment, "processforwardpayment", e.getMessage(), e.getLocalizedMessage(), e);
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
    }

    protected String readReturnForwardPaymentUrl() {
        return RETURN_FORWARD_PAYMENT_URL;
    }

    @RequestMapping(value={"/returnforwardpayment/{forwardPaymentId}/{action}/{urlChecksum}"}, method={RequestMethod.GET})
    public String returnforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, @PathVariable(value="action") String action, @PathVariable(value="urlChecksum") String urlChecksum, @RequestParam Map<String, String> responseData, Model model, HttpServletResponse response) {
        model.addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getDigitalPaymentPlatform());
        String operationCode = String.format("%s[%s]", "returnforwardpayment", action);
        try {
            if (Strings.isNullOrEmpty((String)urlChecksum) || !forwardPayment.getReturnForwardPaymentUrlChecksum().equals(urlChecksum)) {
                this.rejectPayment(forwardPayment, operationCode, "INVALID_CHECKSUM", "Invalid checksum");
                return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
            }
            PaylineConfiguration paylineImplementation = (PaylineConfiguration)forwardPayment.getDigitalPaymentPlatform();
            boolean success = paylineImplementation.processPayment(forwardPayment, action);
            if (success) {
                return String.format("redirect:%s", forwardPayment.getForwardPaymentSuccessUrl());
            }
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
        catch (ForwardPaymentAlreadyPayedException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return String.format("redirect:%s", forwardPayment.getForwardPaymentInsuccessUrl());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void rejectPayment(ForwardPaymentRequest forwardPaymentRequest, String string, String string2, String string3) {
        Object object = advice$rejectPayment.perform((Callable)new PaylineController$callable$rejectPayment(this, forwardPaymentRequest, string, string2, string3));
    }

    static /* synthetic */ void advised$rejectPayment(PaylineController this_, ForwardPaymentRequest forwardPayment, String operationCode, String statusCode, String statusMessage) {
        forwardPayment.reject(operationCode, statusCode, statusMessage, "", "");
    }

    private void rejectPaymentAndLogException(ForwardPaymentRequest forwardPaymentRequest, String string, String string2, String string3, Exception exception) {
        Object object = advice$rejectPaymentAndLogException.perform((Callable)new PaylineController$callable$rejectPaymentAndLogException(this, forwardPaymentRequest, string, string2, string3, exception));
    }

    static /* synthetic */ void advised$rejectPaymentAndLogException(PaylineController this_, ForwardPaymentRequest forwardPayment, String operationCode, String errorCode, String errorMessage, Exception e) {
        forwardPayment.reject(operationCode, errorCode, errorMessage, null, null).logException(e);
    }

    public static void registerForwardPaymentController(Class<IForwardPaymentPlatformService> implementationClass, Class<IForwardPaymentController> controllerClass) {
        CONTROLLER_MAP.put(implementationClass, controllerClass);
    }

    public static IForwardPaymentController getForwardPaymentController(ForwardPaymentRequest forwardPayment) {
        return new PaylineController();
    }

    static {
        advice$rejectPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$rejectPaymentAndLogException = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CONTROLLER_MAP = new HashMap<Class<IForwardPaymentPlatformService>, Class<IForwardPaymentController>>();
    }
}

