/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.managefinantialinstitution;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplateFile;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.TreasuryDocumentTemplateController$callable$createDocumentTemplate;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.TreasuryDocumentTemplateController$callable$deleteDocumentTemplate;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/managefinantialinstitution/treasurydocumenttemplate"})
public class TreasuryDocumentTemplateController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/managefinantialinstitution/treasurydocumenttemplate";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/managefinantialinstitution/treasurydocumenttemplate/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/managefinantialinstitution/treasurydocumenttemplate/delete/";
    private static final String SEARCH_UPLOAD_URI = "/search/upload/";
    public static final String SEARCH_UPLOAD_URL = "/treasury/administration/managefinantialinstitution/treasurydocumenttemplate/search/upload/";
    public static final Advice advice$deleteDocumentTemplate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createDocumentTemplate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        if (model.containsAttribute("finantialInstitutionId")) {
            return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + model.asMap().get("finantialInstitutionId");
        }
        return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/";
    }

    private TreasuryDocumentTemplate getDocumentTemplate(Model model) {
        return (TreasuryDocumentTemplate)model.asMap().get("documentTemplate");
    }

    private void setDocumentTemplate(TreasuryDocumentTemplate documentTemplate, Model model) {
        model.addAttribute("documentTemplate", (Object)documentTemplate);
    }

    public void deleteDocumentTemplate(TreasuryDocumentTemplate treasuryDocumentTemplate) {
        Object object = advice$deleteDocumentTemplate.perform((Callable)new TreasuryDocumentTemplateController$callable$deleteDocumentTemplate(this, treasuryDocumentTemplate));
    }

    static /* synthetic */ void advised$deleteDocumentTemplate(TreasuryDocumentTemplateController this_, TreasuryDocumentTemplate documentTemplate) {
        documentTemplate.delete();
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") TreasuryDocumentTemplate documentTemplate, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + documentTemplate.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") TreasuryDocumentTemplate documentTemplate, Model model) {
        this.setDocumentTemplate(documentTemplate, model);
        return "treasury/administration/managefinantialinstitution/treasurydocumenttemplate/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") TreasuryDocumentTemplate documentTemplate, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentTemplate(documentTemplate, model);
        try {
            FinantialInstitution finantialInstitution = documentTemplate.getFinantialEntity().getFinantialInstitution();
            this.assertUserIsFrontOfficeMember(finantialInstitution, model);
            this.deleteDocumentTemplate(documentTemplate);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + finantialInstitution.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getDocumentTemplate(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"})
    public String create(@RequestParam(value="finantialdocumenttypeid", required=true) FinantialDocumentType finantialDocumentTypes, @RequestParam(value="finantialentityid", required=true) FinantialEntity finantialEntity, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(finantialEntity.getFinantialInstitution(), model);
            TreasuryDocumentTemplate documentTemplate = this.createDocumentTemplate(finantialDocumentTypes, finantialEntity);
            model.addAttribute("documentTemplate", (Object)documentTemplate);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + finantialEntity.getFinantialInstitution().getExternalId(), model, redirectAttributes);
    }

    public TreasuryDocumentTemplate createDocumentTemplate(FinantialDocumentType finantialDocumentType, FinantialEntity finantialEntity) {
        return (TreasuryDocumentTemplate)advice$createDocumentTemplate.perform((Callable)new TreasuryDocumentTemplateController$callable$createDocumentTemplate(this, finantialDocumentType, finantialEntity));
    }

    static /* synthetic */ TreasuryDocumentTemplate advised$createDocumentTemplate(TreasuryDocumentTemplateController this_, FinantialDocumentType finantialDocumentTypes, FinantialEntity finantialEntity) {
        return TreasuryDocumentTemplate.create((FinantialDocumentType)finantialDocumentTypes, (FinantialEntity)finantialEntity);
    }

    @RequestMapping(value={"/search/upload/{oid}"}, method={RequestMethod.POST})
    public String processSearchToUploadAction(@PathVariable(value="oid") TreasuryDocumentTemplate documentTemplate, @RequestParam(value="documentTemplateFile", required=true) MultipartFile documentTemplateFile, Model model, RedirectAttributes redirectAttributes) {
        this.setDocumentTemplate(documentTemplate, model);
        try {
            this.assertUserIsFrontOfficeMember(documentTemplate.getFinantialEntity().getFinantialInstitution(), model);
            this.uploadDocumentTemplateFile(documentTemplate, documentTemplateFile, model);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.upload", (String[])new String[0]), model);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.upload", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.upload", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getDocumentTemplate(model).getExternalId(), model, redirectAttributes);
    }

    public void uploadDocumentTemplateFile(TreasuryDocumentTemplate documentTemplate, MultipartFile requestFile, Model model) {
        if (!requestFile.getOriginalFilename().endsWith(".odt")) {
            throw new TreasuryDomainException("error.file.different.content.type", new String[0]);
        }
        documentTemplate.addFile(documentTemplate, requestFile.getName(), requestFile.getOriginalFilename(), this.getContent(requestFile));
    }

    private byte[] getContent(MultipartFile requestFile) {
        try {
            return requestFile.getBytes();
        }
        catch (IOException e) {
            return null;
        }
    }

    @RequestMapping(value={"/search/download/{documentTemplateFileId}"}, method={RequestMethod.GET})
    public void processSearchToDownloadAction(@PathVariable(value="documentTemplateFileId") TreasuryDocumentTemplateFile documentTemplateFile, HttpServletResponse response) {
        try {
            response.setContentType(documentTemplateFile.getContentType());
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)documentTemplateFile.getFilename()).replaceAll("\\s", "_"), "UTF-8");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(documentTemplateFile.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

