/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.manageproductgroup;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.ProductGroup;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.manageproductgroup.ProductGroupController$callable$createProductGroup;
import org.fenixedu.treasury.ui.administration.base.manageproductgroup.ProductGroupController$callable$deleteProductGroup;
import org.fenixedu.treasury.ui.administration.base.manageproductgroup.ProductGroupController$callable$updateProductGroup;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageProductGroup", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/manageproductgroup/productgroup"})
public class ProductGroupController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/manageproductgroup/productgroup";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/manageproductgroup/productgroup/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/manageproductgroup/productgroup/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/manageproductgroup/productgroup/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/manageproductgroup/productgroup/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/manageproductgroup/productgroup/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/administration/base/manageproductgroup/productgroup/search/view/";
    public static final Advice advice$deleteProductGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createProductGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateProductGroup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/manageproductgroup/productgroup/";
    }

    private ProductGroup getProductGroup(Model m) {
        return (ProductGroup)m.asMap().get("productGroup");
    }

    private void setProductGroup(ProductGroup productGroup, Model m) {
        m.addAttribute("productGroup", (Object)productGroup);
    }

    public void deleteProductGroup(ProductGroup productGroup) {
        Object object = advice$deleteProductGroup.perform((Callable)new ProductGroupController$callable$deleteProductGroup(this, productGroup));
    }

    static /* synthetic */ void advised$deleteProductGroup(ProductGroupController this_, ProductGroup productGroup) {
        productGroup.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<ProductGroup> searchproductgroupResultsDataSet = this.filterSearchProductGroup(code, name);
        model.addAttribute("searchproductgroupResultsDataSet", searchproductgroupResultsDataSet);
        return "treasury/administration/base/manageproductgroup/productgroup/search";
    }

    private List<ProductGroup> getSearchUniverseSearchProductGroupDataSet() {
        return new ArrayList<ProductGroup>(ProductGroup.readAll());
    }

    private List<ProductGroup> filterSearchProductGroup(String code, LocalizedString name) {
        return this.getSearchUniverseSearchProductGroupDataSet().stream().filter(productGroup -> code == null || code.length() == 0 || productGroup.getCode() != null && productGroup.getCode().length() > 0 && productGroup.getCode().toLowerCase().contains(code.toLowerCase())).filter(productGroup -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> productGroup.getName().getContent(locale) != null && productGroup.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") ProductGroup productGroup, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect("/treasury/administration/base/manageproductgroup/productgroup/read//" + productGroup.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") ProductGroup productGroup, Model model) {
        this.setProductGroup(productGroup, model);
        return "treasury/administration/base/manageproductgroup/productgroup/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") ProductGroup productGroup, Model model, RedirectAttributes redirectAttributes) {
        this.setProductGroup(productGroup, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteProductGroup(productGroup);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getProductGroup(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/manageproductgroup/productgroup/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            ProductGroup productGroup = this.createProductGroup(code, name);
            model.addAttribute("productGroup", (Object)productGroup);
            return this.redirect(READ_URL + this.getProductGroup(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public ProductGroup createProductGroup(String string, LocalizedString localizedString) {
        return (ProductGroup)advice$createProductGroup.perform((Callable)new ProductGroupController$callable$createProductGroup(this, string, localizedString));
    }

    static /* synthetic */ ProductGroup advised$createProductGroup(ProductGroupController this_, String code, LocalizedString name) {
        ProductGroup productGroup = ProductGroup.create((String)code, (LocalizedString)name);
        return productGroup;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") ProductGroup productGroup, Model model) {
        this.setProductGroup(productGroup, model);
        return "treasury/administration/base/manageproductgroup/productgroup/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") ProductGroup productGroup, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setProductGroup(productGroup, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            this.updateProductGroup(code, name, model);
            return this.redirect(READ_URL + this.getProductGroup(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
            return this.update(productGroup, model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(productGroup, model);
        }
    }

    public void updateProductGroup(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateProductGroup.perform((Callable)new ProductGroupController$callable$updateProductGroup(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateProductGroup(ProductGroupController this_, String code, LocalizedString name, Model m) {
        this_.getProductGroup(m).edit(code, name);
    }
}

