/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.managepayments;

import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStateLog;
import org.fenixedu.treasury.ui.document.managepayments.SettlementNoteController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@BennuSpringController(value=SettlementNoteController.class)
@RequestMapping(value={"/treasury/document/managepayments/reimbursementprocessstatelog"})
public class ReimbursementProcessStateLogController {
    public static final String CONTROLLER_URL = "/treasury/document/managepayments/reimbursementprocessstatelog";
    private static final String JSP_PATH = "/treasury/document/managepayments/reimbursementprocessstatelog";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/treasury/document/managepayments/reimbursementprocessstatelog/search";

    @RequestMapping(value={"/search/{oid}"}, method={RequestMethod.GET})
    public String search(@PathVariable(value="oid") SettlementNote settlementNote, Model model) {
        List logs = settlementNote.getReimbursementProcessStateLogsSet().stream().sorted(ReimbursementProcessStateLog.COMPARE_BY_VERSIONING_DATE.reversed()).collect(Collectors.toList());
        model.addAttribute("settlementNote", (Object)settlementNote);
        model.addAttribute("logs", logs);
        return this.jspPage(_SEARCH_URI);
    }

    private String jspPage(String page) {
        return "/treasury/document/managepayments/reimbursementprocessstatelog" + page;
    }
}

