/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentcodepool;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.integration.SibsPaymentCodePool;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.FenixFramework;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.managePaymentCodePool", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool"})
public class PaymentCodePoolController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/create";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/update/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/";
    }

    private DigitalPaymentPlatform getPaymentCodePool(Model model) {
        return (DigitalPaymentPlatform)model.asMap().get("paymentCodePool");
    }

    @RequestMapping(value={"/"})
    public String search(Model model) {
        model.addAttribute("searchpaymentcodepoolResultsDataSet", this.filterSearchPaymentCodePool());
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/search";
    }

    private List<DigitalPaymentPlatform> filterSearchPaymentCodePool() {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        return FinantialInstitution.findAll().filter(f -> TreasuryAccessControlAPI.isBackOfficeMember((String)loggedUsername, (FinantialInstitution)f)).flatMap(f -> SibsPaymentCodePool.find((FinantialInstitution)f)).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") DigitalPaymentPlatform paymentCodePool, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + paymentCodePool.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DigitalPaymentPlatform paymentCodePool, Model model) {
        model.addAttribute("paymentCodePool", (Object)paymentCodePool);
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") DigitalPaymentPlatform paymentCodePool, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("paymentCodePool", (Object)paymentCodePool);
        try {
            this.assertUserIsManager(model);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read/" + this.getPaymentCodePool(model).getExternalId();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_documentSeriesForPayments_options", DocumentNumberSeries.findAll().filter(x -> x.getFinantialDocumentType().equals((Object)FinantialDocumentType.findForSettlementNote())).filter(x -> x.getSeries().getActive()).collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_paymentMethod_options", PaymentMethod.findAll().collect(Collectors.toList()));
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="finantialinstitution") FinantialInstitution finantialInstitution, @RequestParam(value="name") String name, @RequestParam(value="entityreferencecode", required=false) String entityReferenceCode, @RequestParam(value="minreferencecode", required=false) Long minReferenceCode, @RequestParam(value="maxreferencecode", required=false) Long maxReferenceCode, @RequestParam(value="minamount", required=false) BigDecimal minAmount, @RequestParam(value="maxamount", required=false) BigDecimal maxAmount, @RequestParam(value="validfrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validFrom, @RequestParam(value="validto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validTo, @RequestParam(value="active", required=false) boolean active, @RequestParam(value="usecheckdigit", required=false) boolean useCheckDigit, @RequestParam(value="sourceinstitutionid", required=false) String sourceInstitutionId, @RequestParam(value="destinationinstitutionid", required=false) String destinationInstitutionId, Model model, RedirectAttributes redirectAttributes) {
        throw new RuntimeException("deprecated");
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") SibsPaymentCodePool paymentCodePool, Model model) {
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_documentSeriesForPayments_options", DocumentNumberSeries.findAll().filter(x -> x.getFinantialDocumentType().equals((Object)FinantialDocumentType.findForSettlementNote())).collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_paymentMethod_options", PaymentMethod.findAll().collect(Collectors.toList()));
        model.addAttribute("paymentCodePool", (Object)paymentCodePool);
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") SibsPaymentCodePool paymentCodePool, @RequestParam(value="name") String name, @RequestParam(value="active", required=false) boolean active, @RequestParam(value="validfrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validFrom, @RequestParam(value="validto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validTo, @RequestParam(value="sourceinstitutionid", required=false) String sourceInstitutionId, @RequestParam(value="destinationinstitutionid", required=false) String destinationInstitutionId, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("paymentCodePool", (Object)paymentCodePool);
        try {
            this.assertUserIsManager(model);
            FenixFramework.atomic(() -> paymentCodePool.edit(name, active, validFrom, validTo, sourceInstitutionId, destinationInstitutionId));
            return this.redirect(READ_URL + this.getPaymentCodePool(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(paymentCodePool, model);
    }
}

