/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui;

import com.fatboyindustrial.gsonjodatime.Converters;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import freemarker.template.LocalizedString;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.treasury.adapters.CountryAdapter;
import org.fenixedu.treasury.adapters.DistrictAdapter;
import org.fenixedu.treasury.adapters.DomainObjectAdapter;
import org.fenixedu.treasury.adapters.LocalizedStringAdapter;
import org.fenixedu.treasury.adapters.MunicipalityAdapter;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.PaymentPenaltyEntryBean;
import org.fenixedu.treasury.dto.SettlementCreditEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementInterestEntryBean;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.payments.virtualpaymententries.IVirtualPaymentEntryHandler;
import org.fenixedu.treasury.services.payments.virtualpaymententries.VirtualInterestHandler;
import org.fenixedu.treasury.services.payments.virtualpaymententries.VirtualPaymentPenaltyHandler;
import org.fenixedu.treasury.ui.converters.BeanConverterService;
import org.fenixedu.treasury.ui.converters.CountryConverterService;
import org.fenixedu.treasury.ui.converters.DistrictConverterService;
import org.fenixedu.treasury.ui.converters.MunicipalityConverterService;
import org.fenixedu.treasury.ui.converters.RuntimeTypeAdapterFactory;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.ui.Model;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import pt.ist.fenixframework.DomainObject;
import pt.ist.standards.geographic.Country;
import pt.ist.standards.geographic.District;
import pt.ist.standards.geographic.Municipality;

public class TreasuryBaseController {
    protected static final String ERROR_MESSAGES = "errorMessages";
    protected static final String WARNING_MESSAGES = "warningMessages";
    protected static final String INFO_MESSAGES = "infoMessages";
    @Autowired
    protected HttpServletRequest request;

    protected void assertUserIsManager(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isManager((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.manager", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.manager", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isBackOfficeMember((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isFrontOfficeMember((String)loggedUsername)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isBackOfficeMember((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsAllowToModifySettlements(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isAllowToModifySettlements((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]));
    }

    protected void assertUserIsAllowToModifyInvoices(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isAllowToModifyInvoices((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.invoices", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.modify.invoices", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isFrontOfficeMember((String)loggedUsername, (FinantialInstitution)finantialInstitution)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }

    protected void addInfoMessage(String message, Model model) {
        ((List)model.asMap().get(INFO_MESSAGES)).add(message);
    }

    protected void addWarningMessage(String message, Model model) {
        ((List)model.asMap().get(WARNING_MESSAGES)).add(message);
    }

    protected void addErrorMessage(String message, Model model) {
        ((List)model.asMap().get(ERROR_MESSAGES)).add(message);
    }

    protected void clearMessages(Model model) {
        model.addAttribute(INFO_MESSAGES, new ArrayList());
        model.addAttribute(WARNING_MESSAGES, new ArrayList());
        model.addAttribute(ERROR_MESSAGES, new ArrayList());
    }

    protected String redirect(String destinationAction, Model model, RedirectAttributes redirectAttributes) {
        if (model.containsAttribute(INFO_MESSAGES)) {
            redirectAttributes.addFlashAttribute(INFO_MESSAGES, model.asMap().get(INFO_MESSAGES));
        }
        if (model.containsAttribute(WARNING_MESSAGES)) {
            redirectAttributes.addFlashAttribute(WARNING_MESSAGES, model.asMap().get(WARNING_MESSAGES));
        }
        if (model.containsAttribute(ERROR_MESSAGES)) {
            redirectAttributes.addFlashAttribute(ERROR_MESSAGES, model.asMap().get(ERROR_MESSAGES));
        }
        return "redirect:" + destinationAction;
    }

    protected String redirectToReferrer(Model model, RedirectAttributes redirectAttributes) {
        String previousURL = this.request.getHeader("referer");
        return this.redirect(previousURL, model, redirectAttributes);
    }

    @ModelAttribute
    protected void addModelProperties(Model model, HttpServletRequest request) {
        WebApplicationContext webAppContext;
        MessageSource messageSource;
        if (!model.containsAttribute(INFO_MESSAGES)) {
            model.addAttribute(INFO_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(WARNING_MESSAGES)) {
            model.addAttribute(WARNING_MESSAGES, new ArrayList());
        }
        if (!model.containsAttribute(ERROR_MESSAGES)) {
            model.addAttribute(ERROR_MESSAGES, new ArrayList());
        }
        if ((messageSource = (MessageSource)(webAppContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request)).getBean("messageSource")) != null && messageSource instanceof ReloadableResourceBundleMessageSource) {
            ((ReloadableResourceBundleMessageSource)messageSource).setUseCodeAsDefaultMessage(true);
        }
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        GenericConversionService conversionService = (GenericConversionService)binder.getConversionService();
        if (!conversionService.canConvert(String.class, ITreasuryBean.class)) {
            GsonBuilder builder = new GsonBuilder();
            this.registerTypeAdapters(builder);
            conversionService.addConverter((GenericConverter)new BeanConverterService(builder));
        }
        conversionService.addConverter((Converter)new CountryConverterService());
        conversionService.addConverter((Converter)new DistrictConverterService());
        conversionService.addConverter((Converter)new MunicipalityConverterService());
    }

    protected void registerTypeAdapters(GsonBuilder builder) {
        builder.registerTypeAdapter(LocalizedString.class, (Object)new LocalizedStringAdapter());
        builder.registerTypeAdapter(Country.class, (Object)new CountryAdapter());
        builder.registerTypeAdapter(District.class, (Object)new DistrictAdapter());
        builder.registerTypeAdapter(Municipality.class, (Object)new MunicipalityAdapter());
        builder.registerTypeHierarchyAdapter(DomainObject.class, (Object)new DomainObjectAdapter());
        RuntimeTypeAdapterFactory<PaymentPenaltyEntryBean> adapter = RuntimeTypeAdapterFactory.of(ISettlementInvoiceEntryBean.class).registerSubtype(SettlementDebitEntryBean.class).registerSubtype(SettlementCreditEntryBean.class).registerSubtype(SettlementInterestEntryBean.class).registerSubtype(InstallmentPaymenPlanBean.class).registerSubtype(PaymentPenaltyEntryBean.class);
        builder.registerTypeAdapterFactory(adapter);
        RuntimeTypeAdapterFactory<VirtualPaymentPenaltyHandler> virtualHandlerAdapter = RuntimeTypeAdapterFactory.of(IVirtualPaymentEntryHandler.class).registerSubtype(VirtualInterestHandler.class).registerSubtype(VirtualPaymentPenaltyHandler.class);
        builder.registerTypeAdapterFactory(virtualHandlerAdapter);
    }

    protected String getBeanJson(ITreasuryBean bean) {
        GsonBuilder builder = new GsonBuilder();
        this.registerTypeAdapters(builder);
        Gson gson = Converters.registerAll((GsonBuilder)builder).create();
        JsonElement jsonTree = gson.toJsonTree((Object)bean);
        jsonTree.getAsJsonObject().addProperty("classname", bean.getClass().getName());
        return jsonTree.toString();
    }
}

