/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.forwardpayments;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.i18n.I18N;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.dto.ISettlementInvoiceEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.InstallmentPaymenPlanBean;
import org.fenixedu.treasury.dto.SettlementCreditEntryBean;
import org.fenixedu.treasury.dto.SettlementDebitEntryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.reports.DocumentPrinter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.document.forwardpayments.ForwardPaymentController$callable$createForwardPayment;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/document/forwardpayments/forwardpayment"})
public class ForwardPaymentController
extends TreasuryBaseController {
    private static final Logger logger;
    private static final String JSP_PATH = "/treasury/document/forwardpayments/forwardpayment";
    private static final String CHOOSE_INVOICE_ENTRIES_URI = "/chooseInvoiceEntries/";
    public static final String CHOOSE_INVOICE_ENTRIES_URL = "/treasury/document/forwardpayments/forwardpayment/chooseInvoiceEntries/";
    private static final String SUMMARY_URI = "/summary/";
    public static final String SUMMARY_URL = "/treasury/document/forwardpayments/forwardpayment/summary/";
    private static final String FORWARD_PAYMENT_SUCCESS_URI = "/forwardpaymentsuccess";
    public static final String FORWARD_PAYMENT_SUCCESS_URL = "/treasury/document/forwardpayments/forwardpayment/forwardpaymentsuccess";
    private static final String FORWARD_PAYMENT_INSUCCESS_URI = "/forwardpaymentinsuccess";
    public static final String FORWARD_PAYMENT_INSUCCESS_URL = "/treasury/document/forwardpayments/forwardpayment/forwardpaymentinsuccess";
    private static final String PRINT_SETTLEMENT_NOTE_URI = "/printsettlementnote";
    public static final String PRINT_SETTLEMENT_NOTE_URL = "/treasury/document/forwardpayments/forwardpayment/printsettlementnote";
    public static final Advice advice$createForwardPayment;

    private void setSettlementNoteBean(SettlementNoteBean bean, Model model) {
        IForwardPaymentPlatformService platform = this.getActivePlatform(bean.getDebtAccount().getFinantialInstitution());
        model.addAttribute("settlementNoteBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("settlementNoteBean", (Object)bean);
        model.addAttribute("logosPage", (Object)platform.getLogosJspPage());
        model.addAttribute("warningBeforeRedirectionPage", (Object)platform.getWarningBeforeRedirectionJspPage());
        model.addAttribute("localeCode", (Object)I18N.getLocale().getLanguage());
        model.addAttribute("chooseInvoiceEntriesUrl", (Object)this.readChooseInvoiceEntriesUrl());
        model.addAttribute("summaryUrl", (Object)this.readSummaryUrl());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
    }

    protected String readChooseInvoiceEntriesUrl() {
        return CHOOSE_INVOICE_ENTRIES_URL;
    }

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        this.assertUserIsAllowToModifySettlements(debtAccount.getFinantialInstitution(), model);
    }

    protected String redirectToDebtAccountUrl(DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(this.readDebtAccountUrl() + debtAccount.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/chooseInvoiceEntries/{debtAccountId}/{digitalPaymentPlatformId}"}, method={RequestMethod.GET})
    public String chooseInvoiceEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="digitalPaymentPlatformId") DigitalPaymentPlatform digitalPaymentPlatform, @RequestParam(value="bean", required=false) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.checkPermissions(debtAccount, model);
        }
        catch (SecurityException e) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.ForwardPaymentController.payment.not.accessible.for.debt.account", (String[])new String[0]), model);
            return this.redirectToDebtAccountUrl(debtAccount, model, redirectAttributes);
        }
        if (bean == null) {
            bean = new SettlementNoteBean(debtAccount, digitalPaymentPlatform, false, true);
        }
        this.setSettlementNoteBean(bean, model);
        if (!digitalPaymentPlatform.isActive() || !digitalPaymentPlatform.isForwardPaymentServiceSupported()) {
            throw new TreasuryDomainException("error.ForwardPaymentRequest.invalid.platform.try.again", new String[0]);
        }
        model.addAttribute("forwardPaymentConfiguration", (Object)digitalPaymentPlatform);
        return this.jspPage("chooseInvoiceEntries");
    }

    @RequestMapping(value={"/chooseInvoiceEntries/"}, method={RequestMethod.POST})
    public String chooseInvoiceEntries(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        DebtAccount debtAccount = bean.getDebtAccount();
        IForwardPaymentPlatformService platform = this.getActivePlatform(bean.getDebtAccount().getFinantialInstitution());
        model.addAttribute("forwardPaymentConfiguration", (Object)platform);
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal creditSum = BigDecimal.ZERO;
        boolean error = false;
        try {
            this.checkPermissions(bean.getDebtAccount(), model);
        }
        catch (SecurityException e2) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.ForwardPaymentController.payment.not.accessible.for.debt.account", (String[])new String[0]), model);
            return this.redirectToDebtAccountUrl(debtAccount, model, redirectAttributes);
        }
        HashSet invoiceEntriesSet = Sets.newHashSet();
        for (int i = 0; i < bean.getDebitEntries().size(); ++i) {
            ISettlementInvoiceEntryBean entryBean = (ISettlementInvoiceEntryBean)bean.getDebitEntries().get(i);
            if (entryBean.isIncluded()) {
                if (entryBean.isForDebitEntry()) {
                    SettlementDebitEntryBean debitEntryBean = (SettlementDebitEntryBean)entryBean;
                    invoiceEntriesSet.add(debitEntryBean.getDebitEntry());
                    if (debitEntryBean.getDebtAmountWithVat().compareTo(BigDecimal.ZERO) == 0) {
                        debitEntryBean.setNotValid(true);
                        error = true;
                        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.debtAmount.equal.zero", (String[])new String[]{Integer.toString(i + 1)}), model);
                    } else if (debitEntryBean.getDebtAmountWithVat().compareTo(debitEntryBean.getDebitEntry().getOpenAmount()) > 0) {
                        debitEntryBean.setNotValid(true);
                        error = true;
                        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.exceeded.openAmount", (String[])new String[]{Integer.toString(i + 1)}), model);
                    } else {
                        debitEntryBean.setNotValid(false);
                    }
                    debitSum = debitSum.add(debitEntryBean.getDebtAmountWithVat());
                    continue;
                }
                InstallmentPaymenPlanBean installmentBean = (InstallmentPaymenPlanBean)entryBean;
                invoiceEntriesSet.addAll(installmentBean.getInstallment().getInstallmentEntriesSet().stream().map(e -> e.getDebitEntry()).collect(Collectors.toSet()));
                if (installmentBean.getSettledAmount().compareTo(BigDecimal.ZERO) == 0) {
                    installmentBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.debtAmount.equal.zero", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else if (installmentBean.getSettledAmount().compareTo(installmentBean.getInstallment().getOpenAmount()) > 0) {
                    installmentBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.exceeded.openAmount", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else {
                    installmentBean.setNotValid(false);
                }
                debitSum = debitSum.add(installmentBean.getSettledAmount());
                continue;
            }
            entryBean.setNotValid(false);
        }
        for (SettlementCreditEntryBean creditEntryBean : bean.getCreditEntries()) {
            if (!creditEntryBean.isIncluded()) continue;
            creditSum = creditSum.add(creditEntryBean.getCreditAmountWithVat());
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(debitSum) < 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.positive.payment.value", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && creditSum.compareTo(debitSum) > 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.negative.payment.value", (String[])new String[0]), model);
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.CreditEntry.no.creditEntries.selected", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && debitSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebiEntry.no.debitEntries.selected", (String[])new String[0]), model);
        }
        if (bean.getDate().toLocalDate().isAfter((ReadablePartial)new LocalDate())) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.date.is.after", (String[])new String[0]), model);
        }
        try {
            SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP((Set)invoiceEntriesSet);
        }
        catch (TreasuryDomainException e3) {
            error = true;
            this.addErrorMessage(e3.getLocalizedMessage(), model);
        }
        if (error) {
            this.setSettlementNoteBean(bean, model);
            return this.jspPage("chooseInvoiceEntries");
        }
        bean.calculateVirtualDebitEntries();
        this.setSettlementNoteBean(bean, model);
        boolean hasPaymentInStateOfPostPaymentAndPayedOnPlatformWarningMessage = false;
        try {
            SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP((List)bean.getIncludedInvoiceEntryBeans());
        }
        catch (TreasuryDomainException e4) {
            error = true;
            this.addErrorMessage(e4.getLocalizedMessage(), model);
        }
        if (error) {
            this.setSettlementNoteBean(bean, model);
            return this.jspPage("chooseInvoiceEntries");
        }
        model.addAttribute("paymentInStateOfPostPaymentAndPayedOnPlatformWarningMessage", (Object)hasPaymentInStateOfPostPaymentAndPayedOnPlatformWarningMessage);
        return this.jspPage("summary");
    }

    private boolean hasForwardPaymentInStateOfPostPaymentAndPayedOnPlatform(DebitEntry debitEntry) {
        try {
            return ForwardPaymentRequest.find((DebitEntry)debitEntry).filter(ForwardPaymentRequest::isInStateToPostProcessPayment).filter(p -> p.getDigitalPaymentPlatform().isActive()).anyMatch(p -> p.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().paymentStatus(p).isInPayedState());
        }
        catch (Exception e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    protected String readSummaryUrl() {
        return SUMMARY_URL;
    }

    @RequestMapping(value={"/summary/"}, method={RequestMethod.POST})
    public String summary(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        DebtAccount debtAccount = bean.getDebtAccount();
        IForwardPaymentPlatformService platform = this.getActivePlatform(debtAccount.getFinantialInstitution());
        model.addAttribute("forwardPaymentConfiguration", (Object)platform);
        try {
            try {
                this.checkPermissions(bean.getDebtAccount(), model);
            }
            catch (SecurityException e) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.ForwardPaymentController.payment.not.accessible.for.debt.account", (String[])new String[0]), model);
                return this.redirectToDebtAccountUrl(bean.getDebtAccount(), model, redirectAttributes);
            }
            ForwardPaymentRequest forwardPayment = this.createForwardPayment(bean);
            return this.redirect(this.readProcessForwardPaymentUrl() + "/" + forwardPayment.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            this.setSettlementNoteBean(bean, model);
            return this.jspPage("summary");
        }
    }

    private ForwardPaymentRequest createForwardPayment(SettlementNoteBean settlementNoteBean) {
        return (ForwardPaymentRequest)advice$createForwardPayment.perform((Callable)new ForwardPaymentController$callable$createForwardPayment(this, settlementNoteBean));
    }

    static /* synthetic */ ForwardPaymentRequest advised$createForwardPayment(ForwardPaymentController this_, SettlementNoteBean bean) {
        return ForwardPaymentRequest.create((SettlementNoteBean)bean, p -> this.forwardPaymentSuccessUrl((ForwardPaymentRequest)p), p -> this.forwardPaymentInsuccessUrl((ForwardPaymentRequest)p));
    }

    public String readProcessForwardPaymentUrl() {
        return "/treasury/document/forwardpayments/forwardpayment/processforwardpayment";
    }

    @RequestMapping(value={"/processforwardpayment/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String processforwardpayment(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model, HttpServletResponse response, HttpSession session) {
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        session.setAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        return forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().getForwardPaymentController(forwardPayment).processforwardpayment(forwardPayment, (Object)model, response, session);
    }

    protected String forwardPaymentInsuccessUrl(ForwardPaymentRequest forwardPayment) {
        return "/treasury/document/forwardpayments/forwardpayment/forwardpaymentinsuccess/" + forwardPayment.getExternalId();
    }

    protected String forwardPaymentSuccessUrl(ForwardPaymentRequest forwardPayment) {
        return "/treasury/document/forwardpayments/forwardpayment/forwardpaymentsuccess/" + forwardPayment.getExternalId();
    }

    @RequestMapping(value={"/forwardpaymentsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentsuccess(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model) {
        model.addAttribute("forwardPaymentConfiguration", (Object)forwardPayment.getDigitalPaymentPlatform());
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        model.addAttribute("settlementNotes", (Object)((PaymentTransaction)forwardPayment.getPaymentTransactionsSet().iterator().next()).getSettlementNotesSet());
        model.addAttribute("logosPage", (Object)forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService().getLogosJspPage());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        model.addAttribute("printSettlementNoteUrl", (Object)this.readPrintSettlementNoteUrl());
        return this.jspPage("paymentSuccess");
    }

    @RequestMapping(value={"/forwardpaymentinsuccess/{forwardPaymentId}"}, method={RequestMethod.GET})
    public String forwardpaymentinsuccess(@PathVariable(value="forwardPaymentId") ForwardPaymentRequest forwardPayment, Model model) {
        IForwardPaymentPlatformService service = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService();
        model.addAttribute("forwardPaymentConfiguration", (Object)service);
        model.addAttribute("forwardPayment", (Object)forwardPayment);
        model.addAttribute("logosPage", (Object)service.getLogosJspPage());
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl());
        return this.jspPage("paymentInsuccess");
    }

    protected String readPrintSettlementNoteUrl() {
        return PRINT_SETTLEMENT_NOTE_URL;
    }

    protected String readDebtAccountUrl() {
        return "/treasury/accounting/managecustomer/debtaccount/read/";
    }

    @RequestMapping(value={"/printsettlementnote/{settlementNoteId}"}, produces={"application/pdf"})
    @ResponseBody
    public Object printsettlementnote(@PathVariable(value="settlementNoteId") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            byte[] report = DocumentPrinter.printFinantialDocument((FinantialDocument)settlementNote, (String)"application/pdf");
            return new ResponseEntity((Object)report, HttpStatus.OK);
        }
        catch (RuntimeException rex) {
            this.addErrorMessage(rex.getLocalizedMessage(), model);
            this.addErrorMessage(rex.getCause().getLocalizedMessage(), model);
            return this.redirect(this.readDebtAccountUrl() + settlementNote.getDebtAccount().getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(this.readDebtAccountUrl() + settlementNote.getDebtAccount().getExternalId(), model, redirectAttributes);
        }
    }

    private String jspPage(String page) {
        return "/treasury/document/forwardpayments/forwardpayment/" + page;
    }

    private IForwardPaymentPlatformService getActivePlatform(FinantialInstitution finantialInstitution) {
        return (IForwardPaymentPlatformService)DigitalPaymentPlatform.findForForwardPaymentService((FinantialInstitution)finantialInstitution, (boolean)true).sorted(DigitalPaymentPlatform.COMPARE_BY_NAME).findFirst().get();
    }

    static {
        advice$createForwardPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(ForwardPaymentController.class);
    }
}

