/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managefiscalcountryregion;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FiscalCountryRegion;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managefiscalcountryregion.FiscalCountryRegionController$callable$createFiscalCountryRegion;
import org.fenixedu.treasury.ui.administration.base.managefiscalcountryregion.FiscalCountryRegionController$callable$deleteFiscalCountryRegion;
import org.fenixedu.treasury.ui.administration.base.managefiscalcountryregion.FiscalCountryRegionController$callable$updateFiscalCountryRegion;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageFiscalCountryRegion", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion"})
public class FiscalCountryRegionController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/delete/";
    public static final Advice advice$deleteFiscalCountryRegion = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createFiscalCountryRegion = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateFiscalCountryRegion = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/";
    }

    private FiscalCountryRegion getFiscalCountryRegion(Model m) {
        return (FiscalCountryRegion)m.asMap().get("fiscalCountryRegion");
    }

    private void setFiscalCountryRegion(FiscalCountryRegion fiscalCountryRegion, Model m) {
        m.addAttribute("fiscalCountryRegion", (Object)fiscalCountryRegion);
    }

    public void deleteFiscalCountryRegion(FiscalCountryRegion fiscalCountryRegion) {
        Object object = advice$deleteFiscalCountryRegion.perform((Callable)new FiscalCountryRegionController$callable$deleteFiscalCountryRegion(this, fiscalCountryRegion));
    }

    static /* synthetic */ void advised$deleteFiscalCountryRegion(FiscalCountryRegionController this_, FiscalCountryRegion fiscalCountryRegion) {
        fiscalCountryRegion.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="fiscalCode", required=false) String fiscalCode, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<FiscalCountryRegion> searchfiscalcountryregionResultsDataSet = this.filterSearchFiscalCountryRegion(fiscalCode, name);
        model.addAttribute("searchfiscalcountryregionResultsDataSet", searchfiscalcountryregionResultsDataSet);
        return "treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/search";
    }

    private List<FiscalCountryRegion> getSearchUniverseSearchFiscalCountryRegionDataSet() {
        return FiscalCountryRegion.findAll().collect(Collectors.toList());
    }

    private List<FiscalCountryRegion> filterSearchFiscalCountryRegion(String fiscalCode, LocalizedString name) {
        return this.getSearchUniverseSearchFiscalCountryRegionDataSet().stream().filter(fiscalCountryRegion -> fiscalCode == null || fiscalCode.length() == 0 || fiscalCountryRegion.getFiscalCode() != null && fiscalCountryRegion.getFiscalCode().length() > 0 && fiscalCountryRegion.getFiscalCode().toLowerCase().contains(fiscalCode.toLowerCase())).filter(fiscalCountryRegion -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> fiscalCountryRegion.getName().getContent(locale) != null && fiscalCountryRegion.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") FiscalCountryRegion fiscalCountryRegion, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + fiscalCountryRegion.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") FiscalCountryRegion fiscalCountryRegion, Model model) {
        this.setFiscalCountryRegion(fiscalCountryRegion, model);
        return "treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") FiscalCountryRegion fiscalCountryRegion, Model model, RedirectAttributes redirectAttributes) {
        this.setFiscalCountryRegion(fiscalCountryRegion, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteFiscalCountryRegion(fiscalCountryRegion);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + this.getFiscalCountryRegion(model).getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="fiscalCode", required=false) String fiscalCode, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            FiscalCountryRegion fiscalCountryRegion = this.createFiscalCountryRegion(fiscalCode, name);
            model.addAttribute("fiscalCountryRegion", (Object)fiscalCountryRegion);
            return this.redirect(READ_URL + this.getFiscalCountryRegion(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    public FiscalCountryRegion createFiscalCountryRegion(String string, LocalizedString localizedString) {
        return (FiscalCountryRegion)advice$createFiscalCountryRegion.perform((Callable)new FiscalCountryRegionController$callable$createFiscalCountryRegion(this, string, localizedString));
    }

    static /* synthetic */ FiscalCountryRegion advised$createFiscalCountryRegion(FiscalCountryRegionController this_, String fiscalCode, LocalizedString name) {
        FiscalCountryRegion fiscalCountryRegion = FiscalCountryRegion.create((String)fiscalCode, (LocalizedString)name);
        return fiscalCountryRegion;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") FiscalCountryRegion fiscalCountryRegion, Model model) {
        this.setFiscalCountryRegion(fiscalCountryRegion, model);
        return "treasury/administration/base/managefiscalcountryregion/fiscalcountryregion/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") FiscalCountryRegion fiscalCountryRegion, @RequestParam(value="fiscalCode", required=false) String fiscalCode, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setFiscalCountryRegion(fiscalCountryRegion, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateFiscalCountryRegion(fiscalCode, name, model);
            return this.redirect(READ_URL + this.getFiscalCountryRegion(model).getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(fiscalCountryRegion, model);
        }
    }

    public void updateFiscalCountryRegion(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateFiscalCountryRegion.perform((Callable)new FiscalCountryRegionController$callable$updateFiscalCountryRegion(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateFiscalCountryRegion(FiscalCountryRegionController this_, String fiscalCode, LocalizedString name, Model m) {
        this_.getFiscalCountryRegion(m).setFiscalCode(fiscalCode);
        this_.getFiscalCountryRegion(m).setName(name);
    }
}

