/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import java.util.HashSet;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/mbwaypaymentrequest"})
public class MbwayPaymentRequestController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/mbwaypaymentrequest";
    private static final String JSP_PATH = "treasury/document/managepayments/mbwaypaymentrequest";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/accounting/managecustomer/mbwaypaymentrequest/create";
    private static final String _CREATEPOSTBACK_URI = "/createpostback";
    public static final String CREATEPOSTBACK_URL = "/treasury/accounting/managecustomer/mbwaypaymentrequest/createpostback";
    private static final String _SHOW_MBWAY_PAYMENT_REQUEST_URI = "/showmbwaypaymentrequest";
    public static final String SHOW_MBWAY_PAYMENT_REQUEST_URL = "/treasury/accounting/managecustomer/mbwaypaymentrequest/showmbwaypaymentrequest";

    protected void checkPermissions(DebtAccount debtAccount, Model model) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        this.checkPermissions(debtAccount, model);
        if (!SibsPaymentsGateway.isMbwayServiceActive((FinantialInstitution)debtAccount.getFinantialInstitution())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.not.active", new String[0]);
        }
        PaymentReferenceCodeBean bean = new PaymentReferenceCodeBean(null, debtAccount);
        bean.setUsePaymentAmountWithInterests(true);
        bean.setPhoneNumberCountryPrefix("351");
        return this._create(debtAccount, bean, model);
    }

    private String _create(DebtAccount debtAccount, PaymentReferenceCodeBean bean, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl(debtAccount));
        model.addAttribute("createUrl", (Object)this.getCreateUrl());
        model.addAttribute("createPostbackUrl", (Object)this.getCreatePostbackUrl());
        IMbwayPaymentPlatformService sibsOnlinePaymentsGateway = (IMbwayPaymentPlatformService)SibsPaymentsGateway.findUniqueActive((FinantialInstitution)debtAccount.getFinantialInstitution()).get();
        model.addAttribute("mbwayService", (Object)sibsOnlinePaymentsGateway);
        return this.jspPage(_CREATE_URI);
    }

    @RequestMapping(value={"/createpostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        bean.updateAmountOnSelectedDebitEntries();
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String createpost(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        if (!SibsPaymentsGateway.isMbwayServiceActive((FinantialInstitution)debtAccount.getFinantialInstitution())) {
            throw new TreasuryDomainException("error.MbwayPaymentRequest.not.active", new String[0]);
        }
        this.checkPermissions(debtAccount, model);
        try {
            IMbwayPaymentPlatformService sibsOnlinePaymentsGateway = (IMbwayPaymentPlatformService)SibsPaymentsGateway.findUniqueActive((FinantialInstitution)debtAccount.getFinantialInstitution()).get();
            if ((bean.getSelectedDebitEntries() == null || bean.getSelectedDebitEntries().isEmpty()) && (bean.getSelectedInstallments() == null || bean.getSelectedInstallments().isEmpty())) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.MbwayPaymentRequest.invoiceEntriesSet.required", (String[])new String[0]), model);
                return this._create(debtAccount, bean, model);
            }
            bean.setUsePaymentAmountWithInterests(true);
            MbwayRequest mbwayPaymentRequest = sibsOnlinePaymentsGateway.createMbwayRequest(debtAccount, new HashSet(bean.getSelectedDebitEntries()), new HashSet(bean.getSelectedInstallments()), bean.getPhoneNumberCountryPrefix(), bean.getPhoneNumber());
            return this.redirect(String.format("%s/%s/%s", this.getShowMbwayPaymentRequest(), debtAccount.getExternalId(), mbwayPaymentRequest.getExternalId()), model, redirectAttributes);
        }
        catch (TreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._create(debtAccount, bean, model);
        }
    }

    @RequestMapping(value={"/showmbwaypaymentrequest/{debtAccountId}/{mbwayPaymentRequestId}"})
    public String showmbwaypaymentrequest(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="mbwayPaymentRequestId") MbwayRequest mbwayPaymentRequest, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("mbwayPaymentRequest", (Object)mbwayPaymentRequest);
        model.addAttribute("debtAccountUrl", (Object)this.readDebtAccountUrl(debtAccount));
        model.addAttribute("createUrl", (Object)this.getCreateUrl());
        model.addAttribute("createPostbackUrl", (Object)this.getCreatePostbackUrl());
        model.addAttribute("mbwayService", (Object)mbwayPaymentRequest.getDigitalPaymentPlatform());
        return this.jspPage(_SHOW_MBWAY_PAYMENT_REQUEST_URI);
    }

    protected String readDebtAccountUrl(DebtAccount debtAccount) {
        return String.format("%s/%s", "/treasury/accounting/managecustomer/debtaccount/read/", debtAccount.getExternalId());
    }

    protected String getCreateUrl() {
        return CREATE_URL;
    }

    protected String getCreatePostbackUrl() {
        return CREATEPOSTBACK_URL;
    }

    protected String getShowMbwayPaymentRequest() {
        return SHOW_MBWAY_PAYMENT_REQUEST_URL;
    }

    private String jspPage(String page) {
        return "treasury/document/managepayments/mbwaypaymentrequest/" + page;
    }
}

