/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.managetreasurysettings;

import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=TreasuryController.class, title="label.title.manageTreasurySettings", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/managetreasurysettings/treasurysettings"})
public class TreasurySettingsController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/managetreasurysettings/treasurysettings";
    private static final String UPDATE_URI = "/update";
    public static final String UPDATE_URL = "/treasury/managetreasurysettings/treasurysettings/update";
    private static final String READ_URI = "/read";
    public static final String READ_URL = "/treasury/managetreasurysettings/treasurysettings/read";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/managetreasurysettings/treasurysettings/read";
    }

    @RequestMapping(value={"/read"})
    public String read(Model model) {
        model.addAttribute("treasurySettings", (Object)TreasurySettings.getInstance());
        return "treasury/managetreasurysettings/treasurysettings/read";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.GET})
    public String update(Model model) {
        model.addAttribute("TreasurySettings_defaultCurrency_options", Currency.findAll().sorted((x, y) -> x.getName().getContent().compareToIgnoreCase(y.getName().getContent())).collect(Collectors.toList()));
        model.addAttribute("TreasurySettings_interestProduct_options", Product.findAllActive().sorted((x, y) -> x.getName().getContent().compareToIgnoreCase(y.getName().getContent())).collect(Collectors.toList()));
        model.addAttribute("treasurySettings", (Object)TreasurySettings.getInstance());
        return "treasury/managetreasurysettings/treasurysettings/update";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String update(@RequestParam(value="defaultcurrency", required=true) Currency defaultCurrency, @RequestParam(value="interestproduct", required=true) Product interestProduct, @RequestParam(value="advancedpaymentproduct", required=true) Product advancedPaymentProduct, @RequestParam(value="numberofpaymentplansperStudent", required=true) Integer numberOfPaymentPlansPerStudent, Model model, RedirectAttributes redirectAttributes) {
        TreasurySettings treasurySettings = TreasurySettings.getInstance();
        model.addAttribute("treasurySettings", (Object)treasurySettings);
        try {
            treasurySettings.edit(defaultCurrency, interestProduct, advancedPaymentProduct, numberOfPaymentPlansPerStudent, Boolean.valueOf(treasurySettings.getCanRegisterPaymentWithMultipleMethods()));
            return this.redirect(READ_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            return this.update(model);
        }
    }
}

