/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import com.qubit.solution.fenixedu.bennu.webservices.services.server.BennuWebService;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPImportOperation;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.dto.IntegrationStatusOutput;
import org.fenixedu.treasury.services.integration.erp.dto.InterestRequestValueInput;
import org.fenixedu.treasury.services.integration.erp.dto.InterestRequestValueOuptut;
import org.joda.time.DateTime;

@WebService
public class ERPIntegrationService
extends BennuWebService {
    public static boolean validate(String username, String password) {
        ERPConfiguration configuration;
        Optional findUniqueByFiscalCode = FinantialInstitution.findUniqueByFiscalCode((String)username);
        if (findUniqueByFiscalCode.isPresent() && (configuration = ((FinantialInstitution)findUniqueByFiscalCode.get()).getErpIntegrationConfiguration()) != null) {
            return password.compareToIgnoreCase(configuration.getPassword()) == 0;
        }
        return false;
    }

    @WebMethod
    public DocumentsInformationOutput sendInfoOnline(DocumentsInformationInput documentsInformation) {
        this.validateRequestHeader(documentsInformation.getFinantialInstitution());
        FinantialInstitution finantialInstitution = this.validateFinantialInstitution(documentsInformation);
        DateTime now = new DateTime();
        String filename = finantialInstitution.getFiscalNumber() + "_" + now.toString() + ".xml";
        ERPImportOperation operation = ERPImportOperation.create((String)filename, (byte[])documentsInformation.getData(), (FinantialInstitution)finantialInstitution, null, (DateTime)now, (boolean)false, (boolean)false, (boolean)false);
        IERPImporter erpImporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPImporter(operation.getFile().getStream());
        DocumentsInformationOutput result = erpImporter.processAuditFile(operation);
        return result;
    }

    private FinantialInstitution validateFinantialInstitution(DocumentsInformationInput documentsInformation) {
        FinantialInstitution finantialInstitution = FinantialInstitution.findUniqueByFiscalCode((String)documentsInformation.getFinantialInstitution()).orElse(null);
        if (finantialInstitution == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.fiscalinstitution", new String[0]);
        }
        return finantialInstitution;
    }

    @WebMethod
    public String sendInfoOffline(DocumentsInformationInput documentsInformation) {
        this.validateRequestHeader(documentsInformation.getFinantialInstitution());
        FinantialInstitution finantialInstitution = this.validateFinantialInstitution(documentsInformation);
        DateTime now = new DateTime();
        String filename = finantialInstitution.getFiscalNumber() + "_" + now.toString() + ".xml";
        IntegrationOperationLogBean logBean = new IntegrationOperationLogBean();
        ERPImportOperation operation = null;
        try {
            File externalFile = new File(documentsInformation.getDataURI());
            byte[] bytes = Files.toByteArray((File)externalFile);
            operation = ERPImportOperation.create((String)filename, (byte[])bytes, (FinantialInstitution)finantialInstitution, null, (DateTime)now, (boolean)false, (boolean)false, (boolean)false);
            IERPImporter erpImporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPImporter(operation.getFile().getStream());
            erpImporter.processAuditFile(operation);
            String string = operation.getExternalId();
            return string;
        }
        catch (Exception e) {
            if (operation != null) {
                logBean.appendErrorLog(e.getLocalizedMessage());
                String string = operation.getExternalId();
                return string;
            }
            throw new RuntimeException(e);
        }
        finally {
            operation.appendLog(logBean.getErrorLog(), logBean.getIntegrationLog(), logBean.getSoapInboundMessage(), logBean.getSoapOutboundMessage());
        }
    }

    @WebMethod
    public IntegrationStatusOutput getIntegrationStatusFor(String finantialInstitution, List<String> documentNumbers) {
        this.validateRequestHeader(finantialInstitution);
        IntegrationStatusOutput result = new IntegrationStatusOutput();
        ArrayList<DocumentStatusWS> statusList = new ArrayList<DocumentStatusWS>();
        for (String documentNumber : documentNumbers) {
            DocumentStatusWS docStatus = new DocumentStatusWS();
            FinantialDocument document = FinantialDocument.findByUiDocumentNumber((FinantialInstitution)FinantialInstitution.findUniqueByFiscalCode((String)finantialInstitution).orElse(null), (String)documentNumber);
            if (document == null) {
                docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.ERROR);
            } else {
                docStatus.setIntegrationStatus(DocumentStatusWS.StatusType.SUCCESS);
            }
            statusList.add(docStatus);
        }
        result.setDocumentStatus(statusList);
        result.setRequestId(finantialInstitution);
        return result;
    }

    @WebMethod
    @Deprecated
    public InterestRequestValueOuptut getInterestValueFor(InterestRequestValueInput interestRequest) {
        throw new RuntimeException("deprecated");
    }

    @WebMethod(operationName="reimbursementStateChange")
    public IntegrationStatusOutput processReimbursementStateChange(@WebParam(name="finantialInstitution") String finantialInstitutionFiscalNumber, @WebParam(name="finantialDocument") String finantialDocumentNumber, @WebParam(name="exerciseYear") String exerciseYear, @WebParam(name="reimbursementStatus") String reimbursementStatusCode, @WebParam(name="reimbursementStatusDate") Calendar reimbursementStatusDate) {
        if (Strings.isNullOrEmpty((String)finantialInstitutionFiscalNumber)) {
            throw new TreasuryDomainException("error.integration.erp.invalid.fiscalInstitution", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)finantialDocumentNumber)) {
            throw new TreasuryDomainException("error.integration.erp.invalid.fiscalInstitution", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)exerciseYear)) {
            throw new TreasuryDomainException("error.integration.erp.invalid.yearExercise", new String[0]);
        }
        try {
            Integer.valueOf(exerciseYear);
        }
        catch (NumberFormatException e) {
            throw new TreasuryDomainException("error.integration.erp.invalid.yearExercise", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)reimbursementStatusCode) || !ReimbursementProcessStatusType.findUniqueByCode((String)reimbursementStatusCode).isPresent()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementStatus", new String[0]);
        }
        if (reimbursementStatusDate == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.stateDate", new String[0]);
        }
        if (!FinantialInstitution.findUniqueByFiscalCode((String)finantialInstitutionFiscalNumber).isPresent()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.fiscalInstitution", new String[0]);
        }
        FinantialInstitution finantialInstitution = (FinantialInstitution)FinantialInstitution.findUniqueByFiscalCode((String)finantialInstitutionFiscalNumber).get();
        if (!FinantialDocument.findUniqueByDocumentNumber((String)finantialDocumentNumber).isPresent()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        FinantialDocument finantialDocument = (FinantialDocument)FinantialDocument.findUniqueByDocumentNumber((String)finantialDocumentNumber).get();
        if (!finantialDocument.isSettlementNote()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        SettlementNote settlementNote = (SettlementNote)finantialDocument;
        if (!settlementNote.isReimbursement()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote", new String[0]);
        }
        if (settlementNote.getDebtAccount().getFinantialInstitution() != finantialInstitution) {
            throw new TreasuryDomainException("error.integration.erp.invalid.settlementNote.not.of.finantialInstitution", new String[0]);
        }
        if (!settlementNote.isClosed()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.state", new String[0]);
        }
        if (settlementNote.getCurrentReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.invalid", new String[0]);
        }
        if (settlementNote.getCurrentReimbursementProcessStatus().isFinalStatus()) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.current.status.is.final", new String[0]);
        }
        ReimbursementProcessStatusType reimbursementStatus = (ReimbursementProcessStatusType)ReimbursementProcessStatusType.findUniqueByCode((String)reimbursementStatusCode).get();
        if (!reimbursementStatus.isAfter(settlementNote.getCurrentReimbursementProcessStatus())) {
            throw new TreasuryDomainException("error.integration.erp.invalid.reimbursementNote.next.status.invalid", new String[0]);
        }
        DocumentStatusWS documentStatusWs = new DocumentStatusWS();
        documentStatusWs.setDocumentNumber(finantialDocumentNumber);
        documentStatusWs.setErrorDescription("");
        documentStatusWs.setIntegrationStatus(DocumentStatusWS.StatusType.SUCCESS);
        IntegrationStatusOutput output = new IntegrationStatusOutput();
        output.setRequestId("");
        output.setDocumentStatus((List)Lists.newArrayList((Object[])new DocumentStatusWS[]{documentStatusWs}));
        return output;
    }

    private void validateRequestHeader(String finantialInstitution) {
    }
}

