/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.forwardpayments;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentStateType;
import org.fenixedu.treasury.domain.forwardpayments.PostForwardPaymentsReportFile;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.forwardpayments.implementations.PostProcessPaymentStatusBean;
import org.fenixedu.treasury.domain.payments.PaymentTransaction;
import org.fenixedu.treasury.services.forwardpayments.PostForwardPaymentsTask$callable$postForwardPaymentProcessService;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.fenixedu.treasury.util.streaming.spreadsheet.ExcelSheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.IErrorsLog;
import org.fenixedu.treasury.util.streaming.spreadsheet.Spreadsheet;
import org.fenixedu.treasury.util.streaming.spreadsheet.SpreadsheetRow;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Deprecated
@Task(englishTitle="Post forward payments registration", readOnly=true)
public class PostForwardPaymentsTask
extends CronTask {
    public static final Advice advice$postForwardPaymentProcessService = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));

    public void runTask() throws Exception {
        DateTime now = new DateTime();
        PostForwardPaymentsTask.postForwardPaymentProcessService(now.minusDays(3), now, this.getLogger());
    }

    public static void postForwardPaymentProcessService(DateTime dateTime, DateTime dateTime2, Logger logger) throws IOException {
        Object object = advice$postForwardPaymentProcessService.perform((Callable)new PostForwardPaymentsTask$callable$postForwardPaymentProcessService(dateTime, dateTime2, logger));
    }

    static /* synthetic */ void advised$postForwardPaymentProcessService(DateTime beginDate, DateTime endDate, Logger logger) throws IOException {
        if (beginDate == null || endDate == null) {
            throw new TreasuryDomainException("error.ForwardPayment.postForwardPaymentProcessService.dates.required", new String[0]);
        }
        DateTime postForwardPaymentsExecutionDate = new DateTime();
        ArrayList result = Lists.newArrayList();
        ForwardPaymentRequest.findAllByStateType((ForwardPaymentStateType[])new ForwardPaymentStateType[]{ForwardPaymentStateType.CREATED, ForwardPaymentStateType.REQUESTED}).filter(f -> f.getRequestDate().compareTo((ReadableInstant)beginDate) >= 0 && f.getRequestDate().compareTo((ReadableInstant)endDate) < 0).forEach(f -> {
            try {
                List<PostForwardPaymentReportBean> reportBeansList = PostForwardPaymentsTask.updateForwardPayment(f, logger);
                for (PostForwardPaymentReportBean bean : reportBeansList) {
                    logger.info(String.format("C\tPAYMENT REQUEST\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n", bean.executionDate, bean.forwardPaymentExternalId, bean.forwardPaymentOrderNumber, bean.customerCode, bean.customerName, bean.previousStateDescription, bean.nextStateDescription, bean.paymentRegisteredWithSuccess, bean.settlementNote, bean.advancedPaymentCreditNote, bean.paymentDate, bean.paidAmount, bean.advancedCreditAmount != null ? bean.advancedCreditAmount.toString() : "", bean.transactionId, bean.statusCode, bean.statusMessage, bean.remarks));
                    result.add(bean);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        PostForwardPaymentsTask.writeExcel(result, postForwardPaymentsExecutionDate, beginDate, endDate);
    }

    private static void writeExcel(final List<PostForwardPaymentReportBean> reportBeans, DateTime postForwardPaymentsExecutionDate, DateTime beginDate, DateTime endDate) {
        byte[] content = Spreadsheet.buildSpreadsheetContent(() -> new ExcelSheet[]{new ExcelSheet(){

            public String getName() {
                return TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.sheet.name", (String[])new String[0]);
            }

            public String[] getHeaders() {
                return new String[]{TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.executionDate", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.forwardPaymentExternalId", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.forwardPaymentOrderNumber", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.forwardPaymentWhenOccured", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.customerCode", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.customerName", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.previousStateDescription", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.nextStateDescription", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.paymentRegisteredWithSuccess", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.settlementNote", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.advancedCreditSettlementNote", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.paymentDate", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.paidAmount", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.advancedCreditAmount", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.transactionId", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.statusCode", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.statusMessage", (String[])new String[0]), TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentReportBean.cell.remarks", (String[])new String[0])};
            }

            public Stream<? extends SpreadsheetRow> getRows() {
                return reportBeans.stream();
            }
        }}, null);
        String filename = TreasuryConstants.treasuryBundle((String)"label.PostForwardPaymentsReportFile.filename", (String[])new String[]{postForwardPaymentsExecutionDate.toString("yyyy_MM_dd_HH_mm_ss")});
        PostForwardPaymentsReportFile.create((DateTime)postForwardPaymentsExecutionDate, (DateTime)beginDate, (DateTime)endDate, (String)filename, (byte[])content);
    }

    private static List<PostForwardPaymentReportBean> updateForwardPayment(ForwardPaymentRequest forwardPayment, Logger logger) throws IOException {
        ArrayList<PostForwardPaymentReportBean> result = new ArrayList<PostForwardPaymentReportBean>();
        try {
            FenixFramework.atomic(() -> {
                IForwardPaymentPlatformService service = forwardPayment.getDigitalPaymentPlatform().castToForwardPaymentPlatformService();
                String justification = TreasuryConstants.treasuryBundle((String)"error.PostForwardPaymentsTask.post.payment.justification", (String[])new String[0]);
                PostProcessPaymentStatusBean postProcessPaymentStatusBean = service.postProcessPayment(forwardPayment, justification, Optional.empty());
                if (forwardPayment.getPaymentTransactionsSet().isEmpty()) {
                    result.add(new PostForwardPaymentReportBean(forwardPayment, postProcessPaymentStatusBean));
                }
                for (PaymentTransaction paymentTransaction : forwardPayment.getPaymentTransactionsSet()) {
                    for (SettlementNote settlementNote : paymentTransaction.getSettlementNotesSet()) {
                        result.add(new PostForwardPaymentReportBean(paymentTransaction, settlementNote, postProcessPaymentStatusBean));
                    }
                }
            });
        }
        catch (Exception e) {
            String message = e.getMessage();
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
            String exceptionOutput = String.format("E\tERROR ON\t%s\t%s\n", forwardPayment.getExternalId(), message);
            logger.error(exceptionOutput);
            logger.error(stackTrace + "\n");
        }
        return result;
    }

    private static class PostForwardPaymentReportBean
    implements SpreadsheetRow {
        private String executionDate;
        private String forwardPaymentExternalId;
        private String forwardPaymentOrderNumber;
        private String forwardPaymentWhenOccured;
        private String customerCode;
        private String customerName;
        private String previousStateDescription;
        private String nextStateDescription;
        private boolean paymentRegisteredWithSuccess;
        private String settlementNote = "";
        private String advancedPaymentCreditNote = "";
        private String paymentDate = "";
        private String paidAmount = "";
        private BigDecimal advancedCreditAmount;
        private String transactionId = "";
        private String statusCode;
        private String statusMessage;
        private String remarks = "";

        private PostForwardPaymentReportBean(ForwardPaymentRequest forwardPayment, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
            this.executionDate = new DateTime().toString("yyyy/MM/dd HH:mm:ss");
            this.forwardPaymentExternalId = forwardPayment.getExternalId();
            this.forwardPaymentOrderNumber = "" + forwardPayment.getOrderNumber();
            this.forwardPaymentWhenOccured = forwardPayment.getRequestDate().toString("yyyy/MM/dd HH:mm:ss");
            this.customerCode = forwardPayment.getDebtAccount().getCustomer().getBusinessIdentification();
            this.customerName = forwardPayment.getDebtAccount().getCustomer().getName();
            this.previousStateDescription = postProcessPaymentStatusBean.getPreviousState().getLocalizedName().getContent();
            this.nextStateDescription = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStateType().getLocalizedName().getContent();
            this.paymentRegisteredWithSuccess = postProcessPaymentStatusBean.isSuccess();
        }

        private PostForwardPaymentReportBean(PaymentTransaction paymentTransaction, SettlementNote settlementNote, PostProcessPaymentStatusBean postProcessPaymentStatusBean) {
            ForwardPaymentRequest forwardPayment = (ForwardPaymentRequest)paymentTransaction.getPaymentRequest();
            this.executionDate = new DateTime().toString("yyyy/MM/dd HH:mm:ss");
            this.forwardPaymentExternalId = forwardPayment.getExternalId();
            this.forwardPaymentOrderNumber = "" + forwardPayment.getOrderNumber();
            this.forwardPaymentWhenOccured = forwardPayment.getRequestDate().toString("yyyy/MM/dd HH:mm:ss");
            this.customerCode = forwardPayment.getDebtAccount().getCustomer().getBusinessIdentification();
            this.customerName = forwardPayment.getDebtAccount().getCustomer().getName();
            this.previousStateDescription = postProcessPaymentStatusBean.getPreviousState().getLocalizedName().getContent();
            this.nextStateDescription = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStateType().getLocalizedName().getContent();
            this.paymentRegisteredWithSuccess = postProcessPaymentStatusBean.isSuccess();
            this.settlementNote = settlementNote.getUiDocumentNumber();
            this.paymentDate = settlementNote.getPaymentDate().toString("yyyy/MM/dd HH:mm:ss");
            this.paidAmount = settlementNote.getTotalPayedAmount().toString();
            this.transactionId = paymentTransaction.getTransactionId();
            if (settlementNote.getAdvancedPaymentCreditNote() != null) {
                this.advancedPaymentCreditNote = settlementNote.getAdvancedPaymentCreditNote().getUiDocumentNumber();
                this.advancedCreditAmount = settlementNote.getAdvancedPaymentCreditNote().getTotalAmount();
            }
            if (this.hasSettlementNotesOnSameDayForSameDebts(forwardPayment, settlementNote)) {
                this.remarks = TreasuryConstants.treasuryBundle((String)"warn.PostForwardPaymentsTask.settlement.notes.on.same.day.for.same.debts", (String[])new String[0]);
            }
            this.statusCode = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusCode();
            this.statusMessage = postProcessPaymentStatusBean.getForwardPaymentStatusBean().getStatusMessage();
        }

        private boolean hasSettlementNotesOnSameDayForSameDebts(ForwardPaymentRequest forwardPayment, SettlementNote settlementNote) {
            LocalDate paymentDate = settlementNote.getPaymentDate().toLocalDate();
            Set forwardPaymentDebitEntriesSet = forwardPayment.getDebitEntriesSet();
            for (SettlementNote s : SettlementNote.findByDebtAccount((DebtAccount)forwardPayment.getDebtAccount()).collect(Collectors.toSet())) {
                if (s == settlementNote || s.isAnnulled() || !s.getPaymentDate().toLocalDate().isEqual((ReadablePartial)paymentDate)) continue;
                for (SettlementEntry settlementEntry : s.getSettlemetEntriesSet()) {
                    if (!forwardPaymentDebitEntriesSet.contains(settlementEntry.getInvoiceEntry())) continue;
                    return true;
                }
            }
            return false;
        }

        public void writeCellValues(Row row, IErrorsLog errorsLog) {
            int i = 0;
            row.createCell(i++).setCellValue(this.executionDate);
            row.createCell(i++).setCellValue(this.forwardPaymentExternalId);
            row.createCell(i++).setCellValue(this.forwardPaymentOrderNumber);
            row.createCell(i++).setCellValue(this.forwardPaymentWhenOccured);
            row.createCell(i++).setCellValue(this.customerCode);
            row.createCell(i++).setCellValue(this.customerName);
            row.createCell(i++).setCellValue(this.previousStateDescription);
            row.createCell(i++).setCellValue(this.nextStateDescription);
            row.createCell(i++).setCellValue(TreasuryConstants.treasuryBundle((String)("label." + this.paymentRegisteredWithSuccess), (String[])new String[0]));
            row.createCell(i++).setCellValue(this.settlementNote);
            row.createCell(i++).setCellValue(this.advancedPaymentCreditNote);
            row.createCell(i++).setCellValue(this.paymentDate);
            row.createCell(i++).setCellValue(this.paidAmount);
            row.createCell(i++).setCellValue(this.advancedCreditAmount != null ? this.advancedCreditAmount.toString() : "");
            row.createCell(i++).setCellValue(this.transactionId);
            row.createCell(i++).setCellValue(this.statusCode);
            row.createCell(i++).setCellValue(this.statusMessage);
            row.createCell(i++).setCellValue(this.remarks);
        }
    }
}

